package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface GitLabBindingListFluent<A extends GitLabBindingListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,GitLabBinding item);
    public A setToItems(int index,GitLabBinding item);
    public A addToItems(GitLabBinding... items);
    public A addAllToItems(Collection<GitLabBinding> items);
    public A removeFromItems(GitLabBinding... items);
    public A removeAllFromItems(Collection<GitLabBinding> items);
    public A removeMatchingFromItems(Predicate<GitLabBindingBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<GitLabBinding> getItems();
    public List<GitLabBinding> buildItems();
    public GitLabBinding buildItem(int index);
    public GitLabBinding buildFirstItem();
    public GitLabBinding buildLastItem();
    public GitLabBinding buildMatchingItem(Predicate<GitLabBindingBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<GitLabBindingBuilder> predicate);
    public A withItems(List<GitLabBinding> items);
    public A withItems(GitLabBinding... items);
    public Boolean hasItems();
    public GitLabBindingListFluent.ItemsNested<A> addNewItem();
    public GitLabBindingListFluent.ItemsNested<A> addNewItemLike(GitLabBinding item);
    public GitLabBindingListFluent.ItemsNested<A> setNewItemLike(int index,GitLabBinding item);
    public GitLabBindingListFluent.ItemsNested<A> editItem(int index);
    public GitLabBindingListFluent.ItemsNested<A> editFirstItem();
    public GitLabBindingListFluent.ItemsNested<A> editLastItem();
    public GitLabBindingListFluent.ItemsNested<A> editMatchingItem(Predicate<GitLabBindingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GitLabBindingFluent<GitLabBindingListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
