package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AwsSqsSourceBuilder extends AwsSqsSourceFluentImpl<AwsSqsSourceBuilder> implements VisitableBuilder<AwsSqsSource,AwsSqsSourceBuilder> {

    AwsSqsSourceFluent<?> fluent;
    Boolean validationEnabled;

    public AwsSqsSourceBuilder() { 
        this(true);
    }


    public AwsSqsSourceBuilder(Boolean validationEnabled) { 
        this(new AwsSqsSource(), validationEnabled);
    }


    public AwsSqsSourceBuilder(AwsSqsSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public AwsSqsSourceBuilder(AwsSqsSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AwsSqsSource(), validationEnabled);
    }


    public AwsSqsSourceBuilder(AwsSqsSourceFluent<?> fluent,AwsSqsSource instance) { 
        this(fluent, instance, true);
    }


    public AwsSqsSourceBuilder(AwsSqsSourceFluent<?> fluent,AwsSqsSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public AwsSqsSourceBuilder(AwsSqsSource instance) { 
        this(instance,true);
    }


    public AwsSqsSourceBuilder(AwsSqsSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.EditableAwsSqsSource build() {
        EditableAwsSqsSource buildable = new EditableAwsSqsSource(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AwsSqsSourceBuilder that = (AwsSqsSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
