package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.serving.v1.ConfigurationBuilder;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabBinding;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.knative.serving.v1.Configuration;
import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceBuilder;
import java.lang.String;
import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.PrometheusSourceBuilder;
import io.fabric8.knative.sources.v1beta1.PingSource;
import io.fabric8.knative.sources.v1beta1.ContainerSourceBuilder;
import io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.CouchDbSource;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBindingBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceFluentImpl;
import java.lang.Boolean;
import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceFluentImpl;
import io.fabric8.knative.sources.v1beta1.ApiServerSourceFluentImpl;
import io.fabric8.knative.serving.v1.ConfigurationFluentImpl;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.knative.serving.v1.RevisionFluentImpl;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabSourceBuilder;
import io.fabric8.knative.eventing.v1.BrokerFluentImpl;
import io.fabric8.knative.eventing.v1.TriggerBuilder;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBinding;
import io.fabric8.knative.sources.v1beta1.ContainerSource;
import java.lang.Object;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannel;
import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.PrometheusSourceFluentImpl;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSource;
import io.fabric8.knative.serving.v1.RouteBuilder;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingBuilder;
import java.lang.Deprecated;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannelFluentImpl;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabSource;
import io.fabric8.knative.eventing.v1.BrokerBuilder;
import io.fabric8.knative.eventing.v1beta1.EventTypeBuilder;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceBuilder;
import io.fabric8.knative.eventing.v1.TriggerFluentImpl;
import io.fabric8.knative.sources.v1beta1.ApiServerSourceBuilder;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabBindingFluentImpl;
import io.fabric8.knative.serving.v1.RevisionBuilder;
import java.lang.StringBuffer;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabSourceFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.knative.eventing.v1beta1.EventType;
import io.fabric8.knative.eventing.v1beta1.EventTypeFluentImpl;
import io.fabric8.knative.eventing.v1.Trigger;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceBuilder;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBinding;
import io.fabric8.knative.serving.v1.Route;
import io.fabric8.knative.serving.v1.RouteFluentImpl;
import io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.CouchDbSourceBuilder;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSource;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceFluentImpl;
import io.fabric8.knative.flows.v1.Sequence;
import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSource;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBindingFluentImpl;
import io.fabric8.knative.sources.v1beta1.ContainerSourceFluentImpl;
import io.fabric8.knative.serving.v1.Revision;
import io.fabric8.knative.sources.v1beta1.ApiServerSource;
import io.fabric8.knative.flows.v1.SequenceFluentImpl;
import io.fabric8.knative.sources.v1beta1.SinkBinding;
import java.lang.StringBuilder;
import io.fabric8.knative.flows.v1.SequenceBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.knative.serving.v1.ServiceBuilder;
import io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.CouchDbSourceFluentImpl;
import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.PrometheusSource;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannelBuilder;
import io.fabric8.knative.eventing.v1.Broker;
import io.fabric8.knative.sources.v1beta1.SinkBindingBuilder;
import io.fabric8.knative.serving.v1.Service;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabBindingBuilder;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingFluentImpl;
import io.fabric8.knative.sources.v1beta1.PingSourceFluentImpl;
import io.fabric8.knative.serving.v1.ServiceFluentImpl;
import io.fabric8.knative.sources.v1beta1.SinkBindingFluentImpl;
import io.fabric8.knative.sources.v1beta1.PingSourceBuilder;

public class ChannelTemplateSpecFluentImpl<A extends ChannelTemplateSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ChannelTemplateSpecFluent<A> {

    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends HasMetadata,?> spec;

    public ChannelTemplateSpecFluentImpl() { 
    }


    public ChannelTemplateSpecFluentImpl(ChannelTemplateSpec instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withSpec(instance.getSpec()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public HasMetadata buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(HasMetadata spec) {
        if (spec instanceof GitLabBinding){ this.spec= new GitLabBindingBuilder((GitLabBinding)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof KafkaSource){ this.spec= new KafkaSourceBuilder((KafkaSource)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof Service){ this.spec= new ServiceBuilder((Service)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof io.fabric8.knative.serving.v1beta1.Route){ this.spec= new io.fabric8.knative.serving.v1beta1.RouteBuilder((io.fabric8.knative.serving.v1beta1.Route)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof CouchDbSource){ this.spec= new CouchDbSourceBuilder((CouchDbSource)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof io.fabric8.knative.serving.v1beta1.Configuration){ this.spec= new io.fabric8.knative.serving.v1beta1.ConfigurationBuilder((io.fabric8.knative.serving.v1beta1.Configuration)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof ContainerSource){ this.spec= new ContainerSourceBuilder((ContainerSource)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof Channel){ this.spec= new ChannelBuilder((Channel)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof Sequence){ this.spec= new SequenceBuilder((Sequence)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof GitLabSource){ this.spec= new GitLabSourceBuilder((GitLabSource)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof KafkaChannel){ this.spec= new KafkaChannelBuilder((KafkaChannel)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof io.fabric8.knative.serving.v1beta1.Service){ this.spec= new io.fabric8.knative.serving.v1beta1.ServiceBuilder((io.fabric8.knative.serving.v1beta1.Service)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof PrometheusSource){ this.spec= new PrometheusSourceBuilder((PrometheusSource)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof ApiServerSource){ this.spec= new ApiServerSourceBuilder((ApiServerSource)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof Revision){ this.spec= new RevisionBuilder((Revision)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof Broker){ this.spec= new BrokerBuilder((Broker)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof Trigger){ this.spec= new TriggerBuilder((Trigger)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof Configuration){ this.spec= new ConfigurationBuilder((Configuration)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof GitHubBinding){ this.spec= new GitHubBindingBuilder((GitHubBinding)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof PingSource){ this.spec= new PingSourceBuilder((PingSource)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof io.fabric8.knative.serving.v1beta1.Revision){ this.spec= new io.fabric8.knative.serving.v1beta1.RevisionBuilder((io.fabric8.knative.serving.v1beta1.Revision)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof InMemoryChannel){ this.spec= new InMemoryChannelBuilder((InMemoryChannel)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof KafkaBinding){ this.spec= new KafkaBindingBuilder((KafkaBinding)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof GitHubSource){ this.spec= new GitHubSourceBuilder((GitHubSource)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof SinkBinding){ this.spec= new SinkBindingBuilder((SinkBinding)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof Subscription){ this.spec= new SubscriptionBuilder((Subscription)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof AwsSqsSource){ this.spec= new AwsSqsSourceBuilder((AwsSqsSource)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof EventType){ this.spec= new EventTypeBuilder((EventType)spec); _visitables.get("spec").add(this.spec);}
        if (spec instanceof Route){ this.spec= new RouteBuilder((Route)spec); _visitables.get("spec").add(this.spec);}
        return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public A withGitLabBindingSpec(GitLabBinding gitLabBindingSpec) {
        _visitables.get("spec").remove(this.spec);
        if (gitLabBindingSpec!=null){ this.spec= new GitLabBindingBuilder(gitLabBindingSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.GitLabBindingSpecNested<A> withNewGitLabBindingSpec() {
        return new GitLabBindingSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.GitLabBindingSpecNested<A> withNewGitLabBindingSpecLike(GitLabBinding item) {
        return new GitLabBindingSpecNestedImpl(item);
    }

    public A withKafkaSourceSpec(KafkaSource kafkaSourceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (kafkaSourceSpec!=null){ this.spec= new KafkaSourceBuilder(kafkaSourceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.KafkaSourceSpecNested<A> withNewKafkaSourceSpec() {
        return new KafkaSourceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.KafkaSourceSpecNested<A> withNewKafkaSourceSpecLike(KafkaSource item) {
        return new KafkaSourceSpecNestedImpl(item);
    }

    public A withServiceSpec(Service serviceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (serviceSpec!=null){ this.spec= new ServiceBuilder(serviceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.ServiceSpecNested<A> withNewServiceSpec() {
        return new ServiceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.ServiceSpecNested<A> withNewServiceSpecLike(Service item) {
        return new ServiceSpecNestedImpl(item);
    }

    public A withRouteSpec(io.fabric8.knative.serving.v1beta1.Route routeSpec) {
        _visitables.get("spec").remove(this.spec);
        if (routeSpec!=null){ this.spec= new io.fabric8.knative.serving.v1beta1.RouteBuilder(routeSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.V1beta1RouteSpecNested<A> withNewV1beta1RouteSpec() {
        return new V1beta1RouteSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.V1beta1RouteSpecNested<A> withNewRouteSpecLike(io.fabric8.knative.serving.v1beta1.Route item) {
        return new V1beta1RouteSpecNestedImpl(item);
    }

    public A withCouchDbSourceSpec(CouchDbSource couchDbSourceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (couchDbSourceSpec!=null){ this.spec= new CouchDbSourceBuilder(couchDbSourceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.CouchDbSourceSpecNested<A> withNewCouchDbSourceSpec() {
        return new CouchDbSourceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.CouchDbSourceSpecNested<A> withNewCouchDbSourceSpecLike(CouchDbSource item) {
        return new CouchDbSourceSpecNestedImpl(item);
    }

    public A withConfigurationSpec(io.fabric8.knative.serving.v1beta1.Configuration configurationSpec) {
        _visitables.get("spec").remove(this.spec);
        if (configurationSpec!=null){ this.spec= new io.fabric8.knative.serving.v1beta1.ConfigurationBuilder(configurationSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.V1beta1ConfigurationSpecNested<A> withNewV1beta1ConfigurationSpec() {
        return new V1beta1ConfigurationSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.V1beta1ConfigurationSpecNested<A> withNewConfigurationSpecLike(io.fabric8.knative.serving.v1beta1.Configuration item) {
        return new V1beta1ConfigurationSpecNestedImpl(item);
    }

    public A withContainerSourceSpec(ContainerSource containerSourceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (containerSourceSpec!=null){ this.spec= new ContainerSourceBuilder(containerSourceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.ContainerSourceSpecNested<A> withNewContainerSourceSpec() {
        return new ContainerSourceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.ContainerSourceSpecNested<A> withNewContainerSourceSpecLike(ContainerSource item) {
        return new ContainerSourceSpecNestedImpl(item);
    }

    public A withChannelSpec(Channel channelSpec) {
        _visitables.get("spec").remove(this.spec);
        if (channelSpec!=null){ this.spec= new ChannelBuilder(channelSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.ChannelSpecNested<A> withNewChannelSpec() {
        return new ChannelSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.ChannelSpecNested<A> withNewChannelSpecLike(Channel item) {
        return new ChannelSpecNestedImpl(item);
    }

    public A withSequenceSpec(Sequence sequenceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (sequenceSpec!=null){ this.spec= new SequenceBuilder(sequenceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.SequenceSpecNested<A> withNewSequenceSpec() {
        return new SequenceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.SequenceSpecNested<A> withNewSequenceSpecLike(Sequence item) {
        return new SequenceSpecNestedImpl(item);
    }

    public A withGitLabSourceSpec(GitLabSource gitLabSourceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (gitLabSourceSpec!=null){ this.spec= new GitLabSourceBuilder(gitLabSourceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.GitLabSourceSpecNested<A> withNewGitLabSourceSpec() {
        return new GitLabSourceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.GitLabSourceSpecNested<A> withNewGitLabSourceSpecLike(GitLabSource item) {
        return new GitLabSourceSpecNestedImpl(item);
    }

    public A withKafkaChannelSpec(KafkaChannel kafkaChannelSpec) {
        _visitables.get("spec").remove(this.spec);
        if (kafkaChannelSpec!=null){ this.spec= new KafkaChannelBuilder(kafkaChannelSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.KafkaChannelSpecNested<A> withNewKafkaChannelSpec() {
        return new KafkaChannelSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.KafkaChannelSpecNested<A> withNewKafkaChannelSpecLike(KafkaChannel item) {
        return new KafkaChannelSpecNestedImpl(item);
    }

    public A withServiceSpec(io.fabric8.knative.serving.v1beta1.Service serviceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (serviceSpec!=null){ this.spec= new io.fabric8.knative.serving.v1beta1.ServiceBuilder(serviceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.V1beta1ServiceSpecNested<A> withNewV1beta1ServiceSpec() {
        return new V1beta1ServiceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.V1beta1ServiceSpecNested<A> withNewServiceSpecLike(io.fabric8.knative.serving.v1beta1.Service item) {
        return new V1beta1ServiceSpecNestedImpl(item);
    }

    public A withPrometheusSourceSpec(PrometheusSource prometheusSourceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (prometheusSourceSpec!=null){ this.spec= new PrometheusSourceBuilder(prometheusSourceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.PrometheusSourceSpecNested<A> withNewPrometheusSourceSpec() {
        return new PrometheusSourceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.PrometheusSourceSpecNested<A> withNewPrometheusSourceSpecLike(PrometheusSource item) {
        return new PrometheusSourceSpecNestedImpl(item);
    }

    public A withApiServerSourceSpec(ApiServerSource apiServerSourceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (apiServerSourceSpec!=null){ this.spec= new ApiServerSourceBuilder(apiServerSourceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.ApiServerSourceSpecNested<A> withNewApiServerSourceSpec() {
        return new ApiServerSourceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.ApiServerSourceSpecNested<A> withNewApiServerSourceSpecLike(ApiServerSource item) {
        return new ApiServerSourceSpecNestedImpl(item);
    }

    public A withRevisionSpec(Revision revisionSpec) {
        _visitables.get("spec").remove(this.spec);
        if (revisionSpec!=null){ this.spec= new RevisionBuilder(revisionSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.RevisionSpecNested<A> withNewRevisionSpec() {
        return new RevisionSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.RevisionSpecNested<A> withNewRevisionSpecLike(Revision item) {
        return new RevisionSpecNestedImpl(item);
    }

    public A withBrokerSpec(Broker brokerSpec) {
        _visitables.get("spec").remove(this.spec);
        if (brokerSpec!=null){ this.spec= new BrokerBuilder(brokerSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.BrokerSpecNested<A> withNewBrokerSpec() {
        return new BrokerSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.BrokerSpecNested<A> withNewBrokerSpecLike(Broker item) {
        return new BrokerSpecNestedImpl(item);
    }

    public A withTriggerSpec(Trigger triggerSpec) {
        _visitables.get("spec").remove(this.spec);
        if (triggerSpec!=null){ this.spec= new TriggerBuilder(triggerSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.TriggerSpecNested<A> withNewTriggerSpec() {
        return new TriggerSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.TriggerSpecNested<A> withNewTriggerSpecLike(Trigger item) {
        return new TriggerSpecNestedImpl(item);
    }

    public A withConfigurationSpec(Configuration configurationSpec) {
        _visitables.get("spec").remove(this.spec);
        if (configurationSpec!=null){ this.spec= new ConfigurationBuilder(configurationSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.ConfigurationSpecNested<A> withNewConfigurationSpec() {
        return new ConfigurationSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.ConfigurationSpecNested<A> withNewConfigurationSpecLike(Configuration item) {
        return new ConfigurationSpecNestedImpl(item);
    }

    public A withGitHubBindingSpec(GitHubBinding gitHubBindingSpec) {
        _visitables.get("spec").remove(this.spec);
        if (gitHubBindingSpec!=null){ this.spec= new GitHubBindingBuilder(gitHubBindingSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.GitHubBindingSpecNested<A> withNewGitHubBindingSpec() {
        return new GitHubBindingSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.GitHubBindingSpecNested<A> withNewGitHubBindingSpecLike(GitHubBinding item) {
        return new GitHubBindingSpecNestedImpl(item);
    }

    public A withPingSourceSpec(PingSource pingSourceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (pingSourceSpec!=null){ this.spec= new PingSourceBuilder(pingSourceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.PingSourceSpecNested<A> withNewPingSourceSpec() {
        return new PingSourceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.PingSourceSpecNested<A> withNewPingSourceSpecLike(PingSource item) {
        return new PingSourceSpecNestedImpl(item);
    }

    public A withRevisionSpec(io.fabric8.knative.serving.v1beta1.Revision revisionSpec) {
        _visitables.get("spec").remove(this.spec);
        if (revisionSpec!=null){ this.spec= new io.fabric8.knative.serving.v1beta1.RevisionBuilder(revisionSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.V1beta1RevisionSpecNested<A> withNewV1beta1RevisionSpec() {
        return new V1beta1RevisionSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.V1beta1RevisionSpecNested<A> withNewRevisionSpecLike(io.fabric8.knative.serving.v1beta1.Revision item) {
        return new V1beta1RevisionSpecNestedImpl(item);
    }

    public A withInMemoryChannelSpec(InMemoryChannel inMemoryChannelSpec) {
        _visitables.get("spec").remove(this.spec);
        if (inMemoryChannelSpec!=null){ this.spec= new InMemoryChannelBuilder(inMemoryChannelSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.InMemoryChannelSpecNested<A> withNewInMemoryChannelSpec() {
        return new InMemoryChannelSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.InMemoryChannelSpecNested<A> withNewInMemoryChannelSpecLike(InMemoryChannel item) {
        return new InMemoryChannelSpecNestedImpl(item);
    }

    public A withKafkaBindingSpec(KafkaBinding kafkaBindingSpec) {
        _visitables.get("spec").remove(this.spec);
        if (kafkaBindingSpec!=null){ this.spec= new KafkaBindingBuilder(kafkaBindingSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.KafkaBindingSpecNested<A> withNewKafkaBindingSpec() {
        return new KafkaBindingSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.KafkaBindingSpecNested<A> withNewKafkaBindingSpecLike(KafkaBinding item) {
        return new KafkaBindingSpecNestedImpl(item);
    }

    public A withGitHubSourceSpec(GitHubSource gitHubSourceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (gitHubSourceSpec!=null){ this.spec= new GitHubSourceBuilder(gitHubSourceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.GitHubSourceSpecNested<A> withNewGitHubSourceSpec() {
        return new GitHubSourceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.GitHubSourceSpecNested<A> withNewGitHubSourceSpecLike(GitHubSource item) {
        return new GitHubSourceSpecNestedImpl(item);
    }

    public A withSinkBindingSpec(SinkBinding sinkBindingSpec) {
        _visitables.get("spec").remove(this.spec);
        if (sinkBindingSpec!=null){ this.spec= new SinkBindingBuilder(sinkBindingSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.SinkBindingSpecNested<A> withNewSinkBindingSpec() {
        return new SinkBindingSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.SinkBindingSpecNested<A> withNewSinkBindingSpecLike(SinkBinding item) {
        return new SinkBindingSpecNestedImpl(item);
    }

    public A withSubscriptionSpec(Subscription subscriptionSpec) {
        _visitables.get("spec").remove(this.spec);
        if (subscriptionSpec!=null){ this.spec= new SubscriptionBuilder(subscriptionSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.SubscriptionSpecNested<A> withNewSubscriptionSpec() {
        return new SubscriptionSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.SubscriptionSpecNested<A> withNewSubscriptionSpecLike(Subscription item) {
        return new SubscriptionSpecNestedImpl(item);
    }

    public A withAwsSqsSourceSpec(AwsSqsSource awsSqsSourceSpec) {
        _visitables.get("spec").remove(this.spec);
        if (awsSqsSourceSpec!=null){ this.spec= new AwsSqsSourceBuilder(awsSqsSourceSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.AwsSqsSourceSpecNested<A> withNewAwsSqsSourceSpec() {
        return new AwsSqsSourceSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.AwsSqsSourceSpecNested<A> withNewAwsSqsSourceSpecLike(AwsSqsSource item) {
        return new AwsSqsSourceSpecNestedImpl(item);
    }

    public A withEventTypeSpec(EventType eventTypeSpec) {
        _visitables.get("spec").remove(this.spec);
        if (eventTypeSpec!=null){ this.spec= new EventTypeBuilder(eventTypeSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.EventTypeSpecNested<A> withNewEventTypeSpec() {
        return new EventTypeSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.EventTypeSpecNested<A> withNewEventTypeSpecLike(EventType item) {
        return new EventTypeSpecNestedImpl(item);
    }

    public A withRouteSpec(Route routeSpec) {
        _visitables.get("spec").remove(this.spec);
        if (routeSpec!=null){ this.spec= new RouteBuilder(routeSpec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public ChannelTemplateSpecFluent.RouteSpecNested<A> withNewRouteSpec() {
        return new RouteSpecNestedImpl();
    }

    public ChannelTemplateSpecFluent.RouteSpecNested<A> withNewRouteSpecLike(Route item) {
        return new RouteSpecNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ChannelTemplateSpecFluentImpl that = (ChannelTemplateSpecFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  spec,  super.hashCode());
    }

    public class GitLabBindingSpecNestedImpl<N> extends GitLabBindingFluentImpl<ChannelTemplateSpecFluent.GitLabBindingSpecNested<N>> implements ChannelTemplateSpecFluent.GitLabBindingSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitLabBindingBuilder builder;

        GitLabBindingSpecNestedImpl(GitLabBinding item) {
            this.builder = new GitLabBindingBuilder(this, item);
        }

        GitLabBindingSpecNestedImpl() {
            this.builder = new GitLabBindingBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endGitLabBindingSpec() {
             return and();
        }
    }


    public class KafkaSourceSpecNestedImpl<N> extends KafkaSourceFluentImpl<ChannelTemplateSpecFluent.KafkaSourceSpecNested<N>> implements ChannelTemplateSpecFluent.KafkaSourceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaSourceBuilder builder;

        KafkaSourceSpecNestedImpl(KafkaSource item) {
            this.builder = new KafkaSourceBuilder(this, item);
        }

        KafkaSourceSpecNestedImpl() {
            this.builder = new KafkaSourceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endKafkaSourceSpec() {
             return and();
        }
    }


    public class ServiceSpecNestedImpl<N> extends ServiceFluentImpl<ChannelTemplateSpecFluent.ServiceSpecNested<N>> implements ChannelTemplateSpecFluent.ServiceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceBuilder builder;

        ServiceSpecNestedImpl(Service item) {
            this.builder = new ServiceBuilder(this, item);
        }

        ServiceSpecNestedImpl() {
            this.builder = new ServiceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endServiceSpec() {
             return and();
        }
    }


    public class V1beta1RouteSpecNestedImpl<N> extends io.fabric8.knative.serving.v1beta1.RouteFluentImpl<ChannelTemplateSpecFluent.V1beta1RouteSpecNested<N>> implements ChannelTemplateSpecFluent.V1beta1RouteSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.serving.v1beta1.RouteBuilder builder;

        V1beta1RouteSpecNestedImpl(io.fabric8.knative.serving.v1beta1.Route item) {
            this.builder = new io.fabric8.knative.serving.v1beta1.RouteBuilder(this, item);
        }

        V1beta1RouteSpecNestedImpl() {
            this.builder = new io.fabric8.knative.serving.v1beta1.RouteBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endV1beta1RouteSpec() {
             return and();
        }
    }


    public class CouchDbSourceSpecNestedImpl<N> extends CouchDbSourceFluentImpl<ChannelTemplateSpecFluent.CouchDbSourceSpecNested<N>> implements ChannelTemplateSpecFluent.CouchDbSourceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CouchDbSourceBuilder builder;

        CouchDbSourceSpecNestedImpl(CouchDbSource item) {
            this.builder = new CouchDbSourceBuilder(this, item);
        }

        CouchDbSourceSpecNestedImpl() {
            this.builder = new CouchDbSourceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endCouchDbSourceSpec() {
             return and();
        }
    }


    public class V1beta1ConfigurationSpecNestedImpl<N> extends io.fabric8.knative.serving.v1beta1.ConfigurationFluentImpl<ChannelTemplateSpecFluent.V1beta1ConfigurationSpecNested<N>> implements ChannelTemplateSpecFluent.V1beta1ConfigurationSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.serving.v1beta1.ConfigurationBuilder builder;

        V1beta1ConfigurationSpecNestedImpl(io.fabric8.knative.serving.v1beta1.Configuration item) {
            this.builder = new io.fabric8.knative.serving.v1beta1.ConfigurationBuilder(this, item);
        }

        V1beta1ConfigurationSpecNestedImpl() {
            this.builder = new io.fabric8.knative.serving.v1beta1.ConfigurationBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endV1beta1ConfigurationSpec() {
             return and();
        }
    }


    public class ContainerSourceSpecNestedImpl<N> extends ContainerSourceFluentImpl<ChannelTemplateSpecFluent.ContainerSourceSpecNested<N>> implements ChannelTemplateSpecFluent.ContainerSourceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ContainerSourceBuilder builder;

        ContainerSourceSpecNestedImpl(ContainerSource item) {
            this.builder = new ContainerSourceBuilder(this, item);
        }

        ContainerSourceSpecNestedImpl() {
            this.builder = new ContainerSourceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endContainerSourceSpec() {
             return and();
        }
    }


    public class ChannelSpecNestedImpl<N> extends ChannelFluentImpl<ChannelTemplateSpecFluent.ChannelSpecNested<N>> implements ChannelTemplateSpecFluent.ChannelSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ChannelBuilder builder;

        ChannelSpecNestedImpl(Channel item) {
            this.builder = new ChannelBuilder(this, item);
        }

        ChannelSpecNestedImpl() {
            this.builder = new ChannelBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endChannelSpec() {
             return and();
        }
    }


    public class SequenceSpecNestedImpl<N> extends SequenceFluentImpl<ChannelTemplateSpecFluent.SequenceSpecNested<N>> implements ChannelTemplateSpecFluent.SequenceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SequenceBuilder builder;

        SequenceSpecNestedImpl(Sequence item) {
            this.builder = new SequenceBuilder(this, item);
        }

        SequenceSpecNestedImpl() {
            this.builder = new SequenceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endSequenceSpec() {
             return and();
        }
    }


    public class GitLabSourceSpecNestedImpl<N> extends GitLabSourceFluentImpl<ChannelTemplateSpecFluent.GitLabSourceSpecNested<N>> implements ChannelTemplateSpecFluent.GitLabSourceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitLabSourceBuilder builder;

        GitLabSourceSpecNestedImpl(GitLabSource item) {
            this.builder = new GitLabSourceBuilder(this, item);
        }

        GitLabSourceSpecNestedImpl() {
            this.builder = new GitLabSourceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endGitLabSourceSpec() {
             return and();
        }
    }


    public class KafkaChannelSpecNestedImpl<N> extends KafkaChannelFluentImpl<ChannelTemplateSpecFluent.KafkaChannelSpecNested<N>> implements ChannelTemplateSpecFluent.KafkaChannelSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaChannelBuilder builder;

        KafkaChannelSpecNestedImpl(KafkaChannel item) {
            this.builder = new KafkaChannelBuilder(this, item);
        }

        KafkaChannelSpecNestedImpl() {
            this.builder = new KafkaChannelBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endKafkaChannelSpec() {
             return and();
        }
    }


    public class V1beta1ServiceSpecNestedImpl<N> extends io.fabric8.knative.serving.v1beta1.ServiceFluentImpl<ChannelTemplateSpecFluent.V1beta1ServiceSpecNested<N>> implements ChannelTemplateSpecFluent.V1beta1ServiceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.serving.v1beta1.ServiceBuilder builder;

        V1beta1ServiceSpecNestedImpl(io.fabric8.knative.serving.v1beta1.Service item) {
            this.builder = new io.fabric8.knative.serving.v1beta1.ServiceBuilder(this, item);
        }

        V1beta1ServiceSpecNestedImpl() {
            this.builder = new io.fabric8.knative.serving.v1beta1.ServiceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endV1beta1ServiceSpec() {
             return and();
        }
    }


    public class PrometheusSourceSpecNestedImpl<N> extends PrometheusSourceFluentImpl<ChannelTemplateSpecFluent.PrometheusSourceSpecNested<N>> implements ChannelTemplateSpecFluent.PrometheusSourceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PrometheusSourceBuilder builder;

        PrometheusSourceSpecNestedImpl(PrometheusSource item) {
            this.builder = new PrometheusSourceBuilder(this, item);
        }

        PrometheusSourceSpecNestedImpl() {
            this.builder = new PrometheusSourceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endPrometheusSourceSpec() {
             return and();
        }
    }


    public class ApiServerSourceSpecNestedImpl<N> extends ApiServerSourceFluentImpl<ChannelTemplateSpecFluent.ApiServerSourceSpecNested<N>> implements ChannelTemplateSpecFluent.ApiServerSourceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ApiServerSourceBuilder builder;

        ApiServerSourceSpecNestedImpl(ApiServerSource item) {
            this.builder = new ApiServerSourceBuilder(this, item);
        }

        ApiServerSourceSpecNestedImpl() {
            this.builder = new ApiServerSourceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endApiServerSourceSpec() {
             return and();
        }
    }


    public class RevisionSpecNestedImpl<N> extends RevisionFluentImpl<ChannelTemplateSpecFluent.RevisionSpecNested<N>> implements ChannelTemplateSpecFluent.RevisionSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RevisionBuilder builder;

        RevisionSpecNestedImpl(Revision item) {
            this.builder = new RevisionBuilder(this, item);
        }

        RevisionSpecNestedImpl() {
            this.builder = new RevisionBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endRevisionSpec() {
             return and();
        }
    }


    public class BrokerSpecNestedImpl<N> extends BrokerFluentImpl<ChannelTemplateSpecFluent.BrokerSpecNested<N>> implements ChannelTemplateSpecFluent.BrokerSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BrokerBuilder builder;

        BrokerSpecNestedImpl(Broker item) {
            this.builder = new BrokerBuilder(this, item);
        }

        BrokerSpecNestedImpl() {
            this.builder = new BrokerBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endBrokerSpec() {
             return and();
        }
    }


    public class TriggerSpecNestedImpl<N> extends TriggerFluentImpl<ChannelTemplateSpecFluent.TriggerSpecNested<N>> implements ChannelTemplateSpecFluent.TriggerSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TriggerBuilder builder;

        TriggerSpecNestedImpl(Trigger item) {
            this.builder = new TriggerBuilder(this, item);
        }

        TriggerSpecNestedImpl() {
            this.builder = new TriggerBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endTriggerSpec() {
             return and();
        }
    }


    public class ConfigurationSpecNestedImpl<N> extends ConfigurationFluentImpl<ChannelTemplateSpecFluent.ConfigurationSpecNested<N>> implements ChannelTemplateSpecFluent.ConfigurationSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConfigurationBuilder builder;

        ConfigurationSpecNestedImpl(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        ConfigurationSpecNestedImpl() {
            this.builder = new ConfigurationBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endConfigurationSpec() {
             return and();
        }
    }


    public class GitHubBindingSpecNestedImpl<N> extends GitHubBindingFluentImpl<ChannelTemplateSpecFluent.GitHubBindingSpecNested<N>> implements ChannelTemplateSpecFluent.GitHubBindingSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitHubBindingBuilder builder;

        GitHubBindingSpecNestedImpl(GitHubBinding item) {
            this.builder = new GitHubBindingBuilder(this, item);
        }

        GitHubBindingSpecNestedImpl() {
            this.builder = new GitHubBindingBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endGitHubBindingSpec() {
             return and();
        }
    }


    public class PingSourceSpecNestedImpl<N> extends PingSourceFluentImpl<ChannelTemplateSpecFluent.PingSourceSpecNested<N>> implements ChannelTemplateSpecFluent.PingSourceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PingSourceBuilder builder;

        PingSourceSpecNestedImpl(PingSource item) {
            this.builder = new PingSourceBuilder(this, item);
        }

        PingSourceSpecNestedImpl() {
            this.builder = new PingSourceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endPingSourceSpec() {
             return and();
        }
    }


    public class V1beta1RevisionSpecNestedImpl<N> extends io.fabric8.knative.serving.v1beta1.RevisionFluentImpl<ChannelTemplateSpecFluent.V1beta1RevisionSpecNested<N>> implements ChannelTemplateSpecFluent.V1beta1RevisionSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.knative.serving.v1beta1.RevisionBuilder builder;

        V1beta1RevisionSpecNestedImpl(io.fabric8.knative.serving.v1beta1.Revision item) {
            this.builder = new io.fabric8.knative.serving.v1beta1.RevisionBuilder(this, item);
        }

        V1beta1RevisionSpecNestedImpl() {
            this.builder = new io.fabric8.knative.serving.v1beta1.RevisionBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endV1beta1RevisionSpec() {
             return and();
        }
    }


    public class InMemoryChannelSpecNestedImpl<N> extends InMemoryChannelFluentImpl<ChannelTemplateSpecFluent.InMemoryChannelSpecNested<N>> implements ChannelTemplateSpecFluent.InMemoryChannelSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InMemoryChannelBuilder builder;

        InMemoryChannelSpecNestedImpl(InMemoryChannel item) {
            this.builder = new InMemoryChannelBuilder(this, item);
        }

        InMemoryChannelSpecNestedImpl() {
            this.builder = new InMemoryChannelBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endInMemoryChannelSpec() {
             return and();
        }
    }


    public class KafkaBindingSpecNestedImpl<N> extends KafkaBindingFluentImpl<ChannelTemplateSpecFluent.KafkaBindingSpecNested<N>> implements ChannelTemplateSpecFluent.KafkaBindingSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaBindingBuilder builder;

        KafkaBindingSpecNestedImpl(KafkaBinding item) {
            this.builder = new KafkaBindingBuilder(this, item);
        }

        KafkaBindingSpecNestedImpl() {
            this.builder = new KafkaBindingBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endKafkaBindingSpec() {
             return and();
        }
    }


    public class GitHubSourceSpecNestedImpl<N> extends GitHubSourceFluentImpl<ChannelTemplateSpecFluent.GitHubSourceSpecNested<N>> implements ChannelTemplateSpecFluent.GitHubSourceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GitHubSourceBuilder builder;

        GitHubSourceSpecNestedImpl(GitHubSource item) {
            this.builder = new GitHubSourceBuilder(this, item);
        }

        GitHubSourceSpecNestedImpl() {
            this.builder = new GitHubSourceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endGitHubSourceSpec() {
             return and();
        }
    }


    public class SinkBindingSpecNestedImpl<N> extends SinkBindingFluentImpl<ChannelTemplateSpecFluent.SinkBindingSpecNested<N>> implements ChannelTemplateSpecFluent.SinkBindingSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SinkBindingBuilder builder;

        SinkBindingSpecNestedImpl(SinkBinding item) {
            this.builder = new SinkBindingBuilder(this, item);
        }

        SinkBindingSpecNestedImpl() {
            this.builder = new SinkBindingBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endSinkBindingSpec() {
             return and();
        }
    }


    public class SubscriptionSpecNestedImpl<N> extends SubscriptionFluentImpl<ChannelTemplateSpecFluent.SubscriptionSpecNested<N>> implements ChannelTemplateSpecFluent.SubscriptionSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SubscriptionBuilder builder;

        SubscriptionSpecNestedImpl(Subscription item) {
            this.builder = new SubscriptionBuilder(this, item);
        }

        SubscriptionSpecNestedImpl() {
            this.builder = new SubscriptionBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endSubscriptionSpec() {
             return and();
        }
    }


    public class AwsSqsSourceSpecNestedImpl<N> extends AwsSqsSourceFluentImpl<ChannelTemplateSpecFluent.AwsSqsSourceSpecNested<N>> implements ChannelTemplateSpecFluent.AwsSqsSourceSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AwsSqsSourceBuilder builder;

        AwsSqsSourceSpecNestedImpl(AwsSqsSource item) {
            this.builder = new AwsSqsSourceBuilder(this, item);
        }

        AwsSqsSourceSpecNestedImpl() {
            this.builder = new AwsSqsSourceBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endAwsSqsSourceSpec() {
             return and();
        }
    }


    public class EventTypeSpecNestedImpl<N> extends EventTypeFluentImpl<ChannelTemplateSpecFluent.EventTypeSpecNested<N>> implements ChannelTemplateSpecFluent.EventTypeSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EventTypeBuilder builder;

        EventTypeSpecNestedImpl(EventType item) {
            this.builder = new EventTypeBuilder(this, item);
        }

        EventTypeSpecNestedImpl() {
            this.builder = new EventTypeBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endEventTypeSpec() {
             return and();
        }
    }


    public class RouteSpecNestedImpl<N> extends RouteFluentImpl<ChannelTemplateSpecFluent.RouteSpecNested<N>> implements ChannelTemplateSpecFluent.RouteSpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RouteBuilder builder;

        RouteSpecNestedImpl(Route item) {
            this.builder = new RouteBuilder(this, item);
        }

        RouteSpecNestedImpl() {
            this.builder = new RouteBuilder(this);
        }

        public N and() {
             return (N) ChannelTemplateSpecFluentImpl.this.withSpec(builder.build());
        }

        public N endRouteSpec() {
             return and();
        }
    }


}
