package io.fabric8.knative.internal.pkg.apis.duck.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class CloudEventAttributesFluentImpl<A extends CloudEventAttributesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CloudEventAttributesFluent<A> {

    private String source;
    private String type;

    public CloudEventAttributesFluentImpl() { 
    }


    public CloudEventAttributesFluentImpl(CloudEventAttributes instance) { 
        this.withSource(instance.getSource()); 
        this.withType(instance.getType()); 
    }


    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source=source; return (A) this;
    }

    public Boolean hasSource() {
        return this.source != null;
    }

    public A withNewSource(String arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuilder arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuffer arg1) {
        return (A)withSource(new String(arg1));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CloudEventAttributesFluentImpl that = (CloudEventAttributesFluentImpl) o;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(source,  type,  super.hashCode());
    }

}
