package io.fabric8.knative.eventing.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface BrokerFluent<A extends BrokerFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public BrokerFluent.MetadataNested<A> withNewMetadata();
    public BrokerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public BrokerFluent.MetadataNested<A> editMetadata();
    public BrokerFluent.MetadataNested<A> editOrNewMetadata();
    public BrokerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public BrokerSpec getSpec();
    public BrokerSpec buildSpec();
    public A withSpec(BrokerSpec spec);
    public Boolean hasSpec();
    public BrokerFluent.SpecNested<A> withNewSpec();
    public BrokerFluent.SpecNested<A> withNewSpecLike(BrokerSpec item);
    public BrokerFluent.SpecNested<A> editSpec();
    public BrokerFluent.SpecNested<A> editOrNewSpec();
    public BrokerFluent.SpecNested<A> editOrNewSpecLike(BrokerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public BrokerStatus getStatus();
    public BrokerStatus buildStatus();
    public A withStatus(BrokerStatus status);
    public Boolean hasStatus();
    public BrokerFluent.StatusNested<A> withNewStatus();
    public BrokerFluent.StatusNested<A> withNewStatusLike(BrokerStatus item);
    public BrokerFluent.StatusNested<A> editStatus();
    public BrokerFluent.StatusNested<A> editOrNewStatus();
    public BrokerFluent.StatusNested<A> editOrNewStatusLike(BrokerStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<BrokerFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BrokerSpecFluent<BrokerFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BrokerStatusFluent<BrokerFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
