package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface GitLabSourceListFluent<A extends GitLabSourceListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,GitLabSource item);
    public A setToItems(int index,GitLabSource item);
    public A addToItems(GitLabSource... items);
    public A addAllToItems(Collection<GitLabSource> items);
    public A removeFromItems(GitLabSource... items);
    public A removeAllFromItems(Collection<GitLabSource> items);
    public A removeMatchingFromItems(Predicate<GitLabSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<GitLabSource> getItems();
    public List<GitLabSource> buildItems();
    public GitLabSource buildItem(int index);
    public GitLabSource buildFirstItem();
    public GitLabSource buildLastItem();
    public GitLabSource buildMatchingItem(Predicate<GitLabSourceBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<GitLabSourceBuilder> predicate);
    public A withItems(List<GitLabSource> items);
    public A withItems(GitLabSource... items);
    public Boolean hasItems();
    public GitLabSourceListFluent.ItemsNested<A> addNewItem();
    public GitLabSourceListFluent.ItemsNested<A> addNewItemLike(GitLabSource item);
    public GitLabSourceListFluent.ItemsNested<A> setNewItemLike(int index,GitLabSource item);
    public GitLabSourceListFluent.ItemsNested<A> editItem(int index);
    public GitLabSourceListFluent.ItemsNested<A> editFirstItem();
    public GitLabSourceListFluent.ItemsNested<A> editLastItem();
    public GitLabSourceListFluent.ItemsNested<A> editMatchingItem(Predicate<GitLabSourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GitLabSourceFluent<GitLabSourceListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
