package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitHubSourceSpecBuilder extends GitHubSourceSpecFluentImpl<GitHubSourceSpecBuilder> implements VisitableBuilder<GitHubSourceSpec,GitHubSourceSpecBuilder> {

    GitHubSourceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public GitHubSourceSpecBuilder() { 
        this(true);
    }


    public GitHubSourceSpecBuilder(Boolean validationEnabled) { 
        this(new GitHubSourceSpec(), validationEnabled);
    }


    public GitHubSourceSpecBuilder(GitHubSourceSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public GitHubSourceSpecBuilder(GitHubSourceSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new GitHubSourceSpec(), validationEnabled);
    }


    public GitHubSourceSpecBuilder(GitHubSourceSpecFluent<?> fluent,GitHubSourceSpec instance) { 
        this(fluent, instance, true);
    }


    public GitHubSourceSpecBuilder(GitHubSourceSpecFluent<?> fluent,GitHubSourceSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAccessToken(instance.getAccessToken()); 
        fluent.withCeOverrides(instance.getCeOverrides()); 
        fluent.withEventTypes(instance.getEventTypes()); 
        fluent.withGithubAPIURL(instance.getGithubAPIURL()); 
        fluent.withOwnerAndRepository(instance.getOwnerAndRepository()); 
        fluent.withSecretToken(instance.getSecretToken()); 
        fluent.withSecure(instance.getSecure()); 
        fluent.withServiceAccountName(instance.getServiceAccountName()); 
        fluent.withSink(instance.getSink()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitHubSourceSpecBuilder(GitHubSourceSpec instance) { 
        this(instance,true);
    }


    public GitHubSourceSpecBuilder(GitHubSourceSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAccessToken(instance.getAccessToken()); 
        this.withCeOverrides(instance.getCeOverrides()); 
        this.withEventTypes(instance.getEventTypes()); 
        this.withGithubAPIURL(instance.getGithubAPIURL()); 
        this.withOwnerAndRepository(instance.getOwnerAndRepository()); 
        this.withSecretToken(instance.getSecretToken()); 
        this.withSecure(instance.getSecure()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.eventing.contrib.github.v1alpha1.EditableGitHubSourceSpec build() {
        EditableGitHubSourceSpec buildable = new EditableGitHubSourceSpec(fluent.getAccessToken(),fluent.getCeOverrides(),fluent.getEventTypes(),fluent.getGithubAPIURL(),fluent.getOwnerAndRepository(),fluent.getSecretToken(),fluent.isSecure(),fluent.getServiceAccountName(),fluent.getSink());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitHubSourceSpecBuilder that = (GitHubSourceSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
