package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface CouchDbSourceFluent<A extends CouchDbSourceFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public CouchDbSourceFluent.MetadataNested<A> withNewMetadata();
    public CouchDbSourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public CouchDbSourceFluent.MetadataNested<A> editMetadata();
    public CouchDbSourceFluent.MetadataNested<A> editOrNewMetadata();
    public CouchDbSourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public CouchDbSourceSpec getSpec();
    public CouchDbSourceSpec buildSpec();
    public A withSpec(CouchDbSourceSpec spec);
    public Boolean hasSpec();
    public CouchDbSourceFluent.SpecNested<A> withNewSpec();
    public CouchDbSourceFluent.SpecNested<A> withNewSpecLike(CouchDbSourceSpec item);
    public CouchDbSourceFluent.SpecNested<A> editSpec();
    public CouchDbSourceFluent.SpecNested<A> editOrNewSpec();
    public CouchDbSourceFluent.SpecNested<A> editOrNewSpecLike(CouchDbSourceSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public CouchDbSourceStatus getStatus();
    public CouchDbSourceStatus buildStatus();
    public A withStatus(CouchDbSourceStatus status);
    public Boolean hasStatus();
    public CouchDbSourceFluent.StatusNested<A> withNewStatus();
    public CouchDbSourceFluent.StatusNested<A> withNewStatusLike(CouchDbSourceStatus item);
    public CouchDbSourceFluent.StatusNested<A> editStatus();
    public CouchDbSourceFluent.StatusNested<A> editOrNewStatus();
    public CouchDbSourceFluent.StatusNested<A> editOrNewStatusLike(CouchDbSourceStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<CouchDbSourceFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CouchDbSourceSpecFluent<CouchDbSourceFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CouchDbSourceStatusFluent<CouchDbSourceFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
