package io.fabric8.knative.eventing.contrib.awssqs.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class AwsSqsSourceSpecFluentImpl<A extends AwsSqsSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AwsSqsSourceSpecFluent<A> {

    private Map<String,String> annotations;
    private SecretKeySelector awsCredsSecret;
    private String queueUrl;
    private String serviceAccountName;
    private ObjectReference sink;

    public AwsSqsSourceSpecFluentImpl() { 
    }


    public AwsSqsSourceSpecFluentImpl(AwsSqsSourceSpec instance) { 
        this.withAnnotations(instance.getAnnotations()); 
        this.withAwsCredsSecret(instance.getAwsCredsSecret()); 
        this.withQueueUrl(instance.getQueueUrl()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSink(instance.getSink()); 
    }


    public A addToAnnotations(String key,String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(Map<String,String> map) {
        if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(Map<String,String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAnnotations() {
        return this.annotations;
    }

    public A withAnnotations(Map<String,String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public SecretKeySelector getAwsCredsSecret() {
        return this.awsCredsSecret;
    }

    public A withAwsCredsSecret(SecretKeySelector awsCredsSecret) {
        this.awsCredsSecret=awsCredsSecret; return (A) this;
    }

    public Boolean hasAwsCredsSecret() {
        return this.awsCredsSecret != null;
    }

    public A withNewAwsCredsSecret(String key,String name,Boolean optional) {
        return (A)withAwsCredsSecret(new SecretKeySelector(key, name, optional));
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public A withQueueUrl(String queueUrl) {
        this.queueUrl=queueUrl; return (A) this;
    }

    public Boolean hasQueueUrl() {
        return this.queueUrl != null;
    }

    public A withNewQueueUrl(String arg1) {
        return (A)withQueueUrl(new String(arg1));
    }

    public A withNewQueueUrl(StringBuilder arg1) {
        return (A)withQueueUrl(new String(arg1));
    }

    public A withNewQueueUrl(StringBuffer arg1) {
        return (A)withQueueUrl(new String(arg1));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public ObjectReference getSink() {
        return this.sink;
    }

    public A withSink(ObjectReference sink) {
        this.sink=sink; return (A) this;
    }

    public Boolean hasSink() {
        return this.sink != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AwsSqsSourceSpecFluentImpl that = (AwsSqsSourceSpecFluentImpl) o;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (awsCredsSecret != null ? !awsCredsSecret.equals(that.awsCredsSecret) :that.awsCredsSecret != null) return false;
        if (queueUrl != null ? !queueUrl.equals(that.queueUrl) :that.queueUrl != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (sink != null ? !sink.equals(that.sink) :that.sink != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(annotations,  awsCredsSecret,  queueUrl,  serviceAccountName,  sink,  super.hashCode());
    }

}
