/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.messaging.v1.InMemoryChannel;
import io.fabric8.knative.messaging.v1.InMemoryChannelBuilder;
import io.fabric8.knative.messaging.v1.InMemoryChannelFluentImpl;
import io.fabric8.knative.messaging.v1.InMemoryChannelList;
import io.fabric8.knative.messaging.v1.InMemoryChannelListFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class InMemoryChannelListFluentImpl<A extends InMemoryChannelListFluent<A>>
extends BaseFluent<A>
implements InMemoryChannelListFluent<A> {
    private String apiVersion;
    private List<InMemoryChannelBuilder> items;
    private String kind;
    private ListMeta metadata;

    public InMemoryChannelListFluentImpl() {
    }

    public InMemoryChannelListFluentImpl(InMemoryChannelList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, InMemoryChannel item) {
        if (this.items == null) {
            this.items = new ArrayList<InMemoryChannelBuilder>();
        }
        InMemoryChannelBuilder builder = new InMemoryChannelBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, InMemoryChannel item) {
        if (this.items == null) {
            this.items = new ArrayList<InMemoryChannelBuilder>();
        }
        InMemoryChannelBuilder builder = new InMemoryChannelBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(InMemoryChannel ... items) {
        if (this.items == null) {
            this.items = new ArrayList<InMemoryChannelBuilder>();
        }
        for (InMemoryChannel item : items) {
            InMemoryChannelBuilder builder = new InMemoryChannelBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<InMemoryChannel> items) {
        if (this.items == null) {
            this.items = new ArrayList<InMemoryChannelBuilder>();
        }
        for (InMemoryChannel item : items) {
            InMemoryChannelBuilder builder = new InMemoryChannelBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(InMemoryChannel ... items) {
        for (InMemoryChannel item : items) {
            InMemoryChannelBuilder builder = new InMemoryChannelBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<InMemoryChannel> items) {
        for (InMemoryChannel item : items) {
            InMemoryChannelBuilder builder = new InMemoryChannelBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<InMemoryChannelBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<InMemoryChannelBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            InMemoryChannelBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<InMemoryChannel> getItems() {
        return InMemoryChannelListFluentImpl.build(this.items);
    }

    @Override
    public List<InMemoryChannel> buildItems() {
        return InMemoryChannelListFluentImpl.build(this.items);
    }

    @Override
    public InMemoryChannel buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public InMemoryChannel buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public InMemoryChannel buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public InMemoryChannel buildMatchingItem(Predicate<InMemoryChannelBuilder> predicate) {
        for (InMemoryChannelBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<InMemoryChannelBuilder> predicate) {
        for (InMemoryChannelBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<InMemoryChannel> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<InMemoryChannelBuilder>();
            for (InMemoryChannel item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(InMemoryChannel ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (InMemoryChannel item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public InMemoryChannelListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public InMemoryChannelListFluent.ItemsNested<A> addNewItemLike(InMemoryChannel item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public InMemoryChannelListFluent.ItemsNested<A> setNewItemLike(int index, InMemoryChannel item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public InMemoryChannelListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public InMemoryChannelListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public InMemoryChannelListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public InMemoryChannelListFluent.ItemsNested<A> editMatchingItem(Predicate<InMemoryChannelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply((Object)this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemoryChannelListFluentImpl that = (InMemoryChannelListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends InMemoryChannelFluentImpl<InMemoryChannelListFluent.ItemsNested<N>>
    implements InMemoryChannelListFluent.ItemsNested<N>,
    Nested<N> {
        private final InMemoryChannelBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, InMemoryChannel item) {
            this.index = index;
            this.builder = new InMemoryChannelBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new InMemoryChannelBuilder(this);
        }

        @Override
        public N and() {
            return (N)InMemoryChannelListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

