package io.fabric8.knative.flows.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SequenceListBuilder extends SequenceListFluentImpl<SequenceListBuilder> implements VisitableBuilder<SequenceList,SequenceListBuilder> {

    SequenceListFluent<?> fluent;
    Boolean validationEnabled;

    public SequenceListBuilder() { 
        this(true);
    }


    public SequenceListBuilder(Boolean validationEnabled) { 
        this(new SequenceList(), validationEnabled);
    }


    public SequenceListBuilder(SequenceListFluent<?> fluent) { 
        this(fluent, true);
    }


    public SequenceListBuilder(SequenceListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new SequenceList(), validationEnabled);
    }


    public SequenceListBuilder(SequenceListFluent<?> fluent,SequenceList instance) { 
        this(fluent, instance, true);
    }


    public SequenceListBuilder(SequenceListFluent<?> fluent,SequenceList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public SequenceListBuilder(SequenceList instance) { 
        this(instance,true);
    }


    public SequenceListBuilder(SequenceList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.flows.v1.EditableSequenceList build() {
        EditableSequenceList buildable = new EditableSequenceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SequenceListBuilder that = (SequenceListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
