package io.fabric8.knative.eventing.contrib.gitlab.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitLabBindingStatusBuilder extends GitLabBindingStatusFluentImpl<GitLabBindingStatusBuilder> implements VisitableBuilder<GitLabBindingStatus,GitLabBindingStatusBuilder> {

    GitLabBindingStatusFluent<?> fluent;
    Boolean validationEnabled;

    public GitLabBindingStatusBuilder() { 
        this(true);
    }


    public GitLabBindingStatusBuilder(Boolean validationEnabled) { 
        this(new GitLabBindingStatus(), validationEnabled);
    }


    public GitLabBindingStatusBuilder(GitLabBindingStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public GitLabBindingStatusBuilder(GitLabBindingStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new GitLabBindingStatus(), validationEnabled);
    }


    public GitLabBindingStatusBuilder(GitLabBindingStatusFluent<?> fluent,GitLabBindingStatus instance) { 
        this(fluent, instance, true);
    }


    public GitLabBindingStatusBuilder(GitLabBindingStatusFluent<?> fluent,GitLabBindingStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withCeAttributes(instance.getCeAttributes()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitLabBindingStatusBuilder(GitLabBindingStatus instance) { 
        this(instance,true);
    }


    public GitLabBindingStatusBuilder(GitLabBindingStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.EditableGitLabBindingStatus build() {
        EditableGitLabBindingStatus buildable = new EditableGitLabBindingStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitLabBindingStatusBuilder that = (GitLabBindingStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
