package io.fabric8.knative.serving.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface RouteSpecFluent<A extends RouteSpecFluent<A>> extends Fluent<A> {


    public A addToTraffic(int index,TrafficTarget item);
    public A setToTraffic(int index,TrafficTarget item);
    public A addToTraffic(TrafficTarget... items);
    public A addAllToTraffic(Collection<TrafficTarget> items);
    public A removeFromTraffic(TrafficTarget... items);
    public A removeAllFromTraffic(Collection<TrafficTarget> items);
    public A removeMatchingFromTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTraffic instead.
 * @return The buildable object.
 */
@Deprecated public List<TrafficTarget> getTraffic();
    public List<TrafficTarget> buildTraffic();
    public TrafficTarget buildTraffic(int index);
    public TrafficTarget buildFirstTraffic();
    public TrafficTarget buildLastTraffic();
    public TrafficTarget buildMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate);
    public Boolean hasMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate);
    public A withTraffic(List<TrafficTarget> traffic);
    public A withTraffic(TrafficTarget... traffic);
    public Boolean hasTraffic();
    public RouteSpecFluent.TrafficNested<A> addNewTraffic();
    public RouteSpecFluent.TrafficNested<A> addNewTrafficLike(TrafficTarget item);
    public RouteSpecFluent.TrafficNested<A> setNewTrafficLike(int index,TrafficTarget item);
    public RouteSpecFluent.TrafficNested<A> editTraffic(int index);
    public RouteSpecFluent.TrafficNested<A> editFirstTraffic();
    public RouteSpecFluent.TrafficNested<A> editLastTraffic();
    public RouteSpecFluent.TrafficNested<A> editMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate);
    public interface TrafficNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TrafficTargetFluent<RouteSpecFluent.TrafficNested<N>> {

        public N and();
        public N endTraffic();    }


}
