package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface GitHubSourceListFluent<A extends GitHubSourceListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,GitHubSource item);
    public A setToItems(int index,GitHubSource item);
    public A addToItems(GitHubSource... items);
    public A addAllToItems(Collection<GitHubSource> items);
    public A removeFromItems(GitHubSource... items);
    public A removeAllFromItems(Collection<GitHubSource> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<GitHubSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<GitHubSource> getItems();
    public List<GitHubSource> buildItems();
    public GitHubSource buildItem(int index);
    public GitHubSource buildFirstItem();
    public GitHubSource buildLastItem();
    public GitHubSource buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<GitHubSourceBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<GitHubSourceBuilder> predicate);
    public A withItems(List<GitHubSource> items);
    public A withItems(GitHubSource... items);
    public Boolean hasItems();
    public GitHubSourceListFluent.ItemsNested<A> addNewItem();
    public GitHubSourceListFluent.ItemsNested<A> addNewItemLike(GitHubSource item);
    public GitHubSourceListFluent.ItemsNested<A> setNewItemLike(int index,GitHubSource item);
    public GitHubSourceListFluent.ItemsNested<A> editItem(int index);
    public GitHubSourceListFluent.ItemsNested<A> editFirstItem();
    public GitHubSourceListFluent.ItemsNested<A> editLastItem();
    public GitHubSourceListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<GitHubSourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GitHubSourceFluent<GitHubSourceListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
