package io.fabric8.knative.eventing.contrib.github.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GitHubBindingBuilder extends GitHubBindingFluentImpl<GitHubBindingBuilder> implements VisitableBuilder<GitHubBinding,GitHubBindingBuilder> {

    GitHubBindingFluent<?> fluent;
    Boolean validationEnabled;

    public GitHubBindingBuilder() { 
        this(true);
    }


    public GitHubBindingBuilder(Boolean validationEnabled) { 
        this(new GitHubBinding(), validationEnabled);
    }


    public GitHubBindingBuilder(GitHubBindingFluent<?> fluent) { 
        this(fluent, true);
    }


    public GitHubBindingBuilder(GitHubBindingFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new GitHubBinding(), validationEnabled);
    }


    public GitHubBindingBuilder(GitHubBindingFluent<?> fluent,GitHubBinding instance) { 
        this(fluent, instance, true);
    }


    public GitHubBindingBuilder(GitHubBindingFluent<?> fluent,GitHubBinding instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public GitHubBindingBuilder(GitHubBinding instance) { 
        this(instance,true);
    }


    public GitHubBindingBuilder(GitHubBinding instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.eventing.contrib.github.v1alpha1.EditableGitHubBinding build() {
        EditableGitHubBinding buildable = new EditableGitHubBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        GitHubBindingBuilder that = (GitHubBindingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
