package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CouchDbSourceStatusBuilder extends CouchDbSourceStatusFluentImpl<CouchDbSourceStatusBuilder> implements VisitableBuilder<CouchDbSourceStatus,CouchDbSourceStatusBuilder> {

    CouchDbSourceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public CouchDbSourceStatusBuilder() { 
        this(true);
    }


    public CouchDbSourceStatusBuilder(Boolean validationEnabled) { 
        this(new CouchDbSourceStatus(), validationEnabled);
    }


    public CouchDbSourceStatusBuilder(CouchDbSourceStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public CouchDbSourceStatusBuilder(CouchDbSourceStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CouchDbSourceStatus(), validationEnabled);
    }


    public CouchDbSourceStatusBuilder(CouchDbSourceStatusFluent<?> fluent,CouchDbSourceStatus instance) { 
        this(fluent, instance, true);
    }


    public CouchDbSourceStatusBuilder(CouchDbSourceStatusFluent<?> fluent,CouchDbSourceStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAnnotations(instance.getAnnotations()); 
        fluent.withCeAttributes(instance.getCeAttributes()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public CouchDbSourceStatusBuilder(CouchDbSourceStatus instance) { 
        this(instance,true);
    }


    public CouchDbSourceStatusBuilder(CouchDbSourceStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAnnotations(instance.getAnnotations()); 
        this.withCeAttributes(instance.getCeAttributes()); 
        this.withConditions(instance.getConditions()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withSinkUri(instance.getSinkUri()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.EditableCouchDbSourceStatus build() {
        EditableCouchDbSourceStatus buildable = new EditableCouchDbSourceStatus(fluent.getAnnotations(),fluent.getCeAttributes(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSinkUri());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CouchDbSourceStatusBuilder that = (CouchDbSourceStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
