package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.knative.internal.pkg.apis.duck.v1.Destination;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface CouchDbSourceSpecFluent<A extends CouchDbSourceSpecFluent<A>> extends Fluent<A> {


    public ObjectReference getCredentials();
    public A withCredentials(ObjectReference credentials);
    public Boolean hasCredentials();
    public String getDatabase();
    public A withDatabase(String database);
    public Boolean hasDatabase();
    public A withNewDatabase(String arg1);
    public A withNewDatabase(StringBuilder arg1);
    public A withNewDatabase(StringBuffer arg1);
    public String getFeed();
    public A withFeed(String feed);
    public Boolean hasFeed();
    public A withNewFeed(String arg1);
    public A withNewFeed(StringBuilder arg1);
    public A withNewFeed(StringBuffer arg1);
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(String arg1);
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSink instead.
 * @return The buildable object.
 */
@Deprecated public Destination getSink();
    public Destination buildSink();
    public A withSink(Destination sink);
    public Boolean hasSink();
    public CouchDbSourceSpecFluent.SinkNested<A> withNewSink();
    public CouchDbSourceSpecFluent.SinkNested<A> withNewSinkLike(Destination item);
    public CouchDbSourceSpecFluent.SinkNested<A> editSink();
    public CouchDbSourceSpecFluent.SinkNested<A> editOrNewSink();
    public CouchDbSourceSpecFluent.SinkNested<A> editOrNewSinkLike(Destination item);
    public interface SinkNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DestinationFluent<CouchDbSourceSpecFluent.SinkNested<N>> {

        public N and();
        public N endSink();    }


}
