package io.fabric8.knative.eventing.contrib.couchdb.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CouchDbSourceListFluent<A extends CouchDbSourceListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,CouchDbSource item);
    public A setToItems(int index,CouchDbSource item);
    public A addToItems(CouchDbSource... items);
    public A addAllToItems(Collection<CouchDbSource> items);
    public A removeFromItems(CouchDbSource... items);
    public A removeAllFromItems(Collection<CouchDbSource> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<CouchDbSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<CouchDbSource> getItems();
    public List<CouchDbSource> buildItems();
    public CouchDbSource buildItem(int index);
    public CouchDbSource buildFirstItem();
    public CouchDbSource buildLastItem();
    public CouchDbSource buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<CouchDbSourceBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<CouchDbSourceBuilder> predicate);
    public A withItems(List<CouchDbSource> items);
    public A withItems(CouchDbSource... items);
    public Boolean hasItems();
    public CouchDbSourceListFluent.ItemsNested<A> addNewItem();
    public CouchDbSourceListFluent.ItemsNested<A> addNewItemLike(CouchDbSource item);
    public CouchDbSourceListFluent.ItemsNested<A> setNewItemLike(int index,CouchDbSource item);
    public CouchDbSourceListFluent.ItemsNested<A> editItem(int index);
    public CouchDbSourceListFluent.ItemsNested<A> editFirstItem();
    public CouchDbSourceListFluent.ItemsNested<A> editLastItem();
    public CouchDbSourceListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<CouchDbSourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CouchDbSourceFluent<CouchDbSourceListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
