/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.process.support;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ProcessUtils.class);

    private ProcessUtils() {
    }

    public static File findInstallDir(File rootDir) {
        if (ProcessUtils.installExists(rootDir)) {
            return rootDir;
        }
        File[] files = rootDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!ProcessUtils.installExists(file)) continue;
                return file;
            }
        }
        return rootDir;
    }

    public static boolean installExists(File file) {
        if (file.getName().startsWith(".")) {
            return false;
        }
        if (file.isDirectory()) {
            File binDir = new File(file, "bin");
            return binDir.exists() && binDir.isDirectory();
        }
        return false;
    }
}

