/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.process.support;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.fabric8.jube.process.ProcessController;
import io.fabric8.jube.process.config.ProcessConfig;
import io.fabric8.jube.process.support.command.CommandFailedException;
import io.fabric8.jube.util.FilesHelper;
import io.fabric8.utils.ExecParseUtils;
import io.fabric8.utils.Processes;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProcessController
implements ProcessController {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProcessController.class);
    private static final int THREADS_PER_CONTROLLER = 2;
    private final String id;
    private File rootDir;
    private final File baseDir;
    private final ProcessConfig config;
    private transient Executor executor;

    public DefaultProcessController(String id, ProcessConfig config, File rootDir, File baseDir) {
        this.id = id;
        this.config = config;
        this.rootDir = rootDir;
        this.baseDir = baseDir;
    }

    public String toString() {
        return "DefaultProcessController(" + this.id + ")";
    }

    @Override
    public int install() throws InterruptedException, IOException, CommandFailedException {
        int answer = 0;
        List<String> installCommands = this.config.getInstallCommands();
        if (installCommands != null) {
            for (String installCommand : installCommands) {
                if (Strings.isNullOrEmpty((String)installCommand)) continue;
                this.runCommandLine(installCommand);
            }
        }
        return answer;
    }

    @Override
    public synchronized int uninstall() {
        String name = this.rootDir.getName();
        if (name.startsWith(".")) {
            LOG.debug("Uninstalling " + this.rootDir + " has already been done.");
        } else {
            File newName = new File(this.rootDir.getParentFile(), "." + name);
            FilesHelper.recursiveDelete((File)newName);
            if (FilesHelper.renameTo((File)this.rootDir, (File)newName)) {
                this.rootDir = newName;
            }
        }
        return 0;
    }

    @Override
    public int start() throws Exception {
        return this.runConfigCommandValueOrLaunchScriptWith(this.config.getStartCommand(), "start");
    }

    @Override
    public int stop() throws Exception {
        String customCommand = this.config.getKillCommand();
        if (Strings.isNullOrEmpty((String)customCommand)) {
            LOG.info("No stop command configured so lets just try killing it " + this);
            return Processes.killProcess((Long)this.getPid(), (String)"");
        }
        return this.runConfigCommandValueOrLaunchScriptWith(customCommand, "stop");
    }

    @Override
    public int kill() throws Exception {
        String customCommand = this.config.getKillCommand();
        if (Strings.isNullOrEmpty((String)customCommand)) {
            LOG.info("No kill command configured so lets just try killing it " + this);
            return Processes.killProcess((Long)this.getPid(), (String)"-9");
        }
        return this.runConfigCommandValueOrLaunchScriptWith(customCommand, "kill");
    }

    @Override
    public int restart() throws Exception {
        String customCommand = this.config.getRestartCommand();
        if (customCommand != null && customCommand.trim().isEmpty()) {
            LOG.info("No restart command configured so lets just try stopping " + this + " then starting again.");
            int answer = this.stop();
            if (answer == 0) {
                answer = this.start();
            }
            return answer;
        }
        return this.runConfigCommandValueOrLaunchScriptWith(customCommand, "restart");
    }

    @Override
    public int status() throws Exception {
        return this.runConfigCommandValueOrLaunchScriptWith(this.config.getStatusCommand(), "status");
    }

    @Override
    public int configure() throws Exception {
        String customCommand = this.config.getConfigureCommand();
        if (customCommand != null && customCommand.trim().isEmpty()) {
            LOG.info("No configure command configured " + this);
            return 0;
        }
        return this.runCommandLine(customCommand);
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("fuse-process-controller-%s").build());
        }
        return this.executor;
    }

    @Override
    public ProcessConfig getConfig() {
        return this.config;
    }

    @Override
    public Long getPid() throws IOException {
        File file;
        Long answer = null;
        String pidFileName = this.config.getPidFile();
        if (pidFileName != null && (file = new File(this.baseDir, pidFileName)).exists() && file.isFile()) {
            return this.extractPidFromFile(file);
        }
        File pidFile = new File(this.baseDir, "var/process.pid");
        if (pidFile.exists()) {
            return this.extractPidFromFile(pidFile);
        }
        File pidDir = new File(this.baseDir, "var/run");
        if (pidDir.exists() && pidDir.isDirectory()) {
            File[] files;
            String script = this.getLaunchScript();
            int idx = script.lastIndexOf("/");
            if (idx < 0) {
                idx = script.lastIndexOf("\\");
            }
            if (idx > 0) {
                script = script.substring(idx + 1);
            }
            if ((pidFile = new File(pidDir, script + ".pid")).exists()) {
                return this.extractPidFromFile(pidFile);
            }
            if (answer == null && (files = pidDir.listFiles()) != null) {
                File file2;
                File[] arr$ = files;
                int len$ = arr$.length;
                for (int i$ = 0; !(i$ >= len$ || (file2 = arr$[i$]).getName().toLowerCase().endsWith(".pid") && (answer = this.extractPidFromFile(file2)) != null); ++i$) {
                }
            }
        }
        return answer;
    }

    protected String getLaunchScript() {
        String launchScript = this.config.getLaunchScript();
        if (launchScript == null) {
            launchScript = "bin/launcher";
        }
        return launchScript;
    }

    private Long extractPidFromFile(File file) throws IOException {
        List lines = FilesHelper.readLines((File)file);
        for (String line : lines) {
            String text = line.trim();
            if (!text.matches("\\d+")) continue;
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse pid '" + text + "' as a number. Exception: " + e, e);
            }
        }
        return null;
    }

    protected int runConfigCommandValueOrLaunchScriptWith(String command, String launchArgument) throws InterruptedException, IOException, CommandFailedException {
        if (command != null) {
            return this.runCommandLine(command);
        }
        return this.config.runCommand(this.getExecutor(), this.baseDir, this.getLaunchScript(), launchArgument);
    }

    protected int runCommandLine(String command) throws IOException, InterruptedException, CommandFailedException {
        if (command != null) {
            List commandArgs = ExecParseUtils.splitToWhiteSpaceSeparatedTokens((String)command);
            return this.config.runCommand(this.getExecutor(), this.baseDir, commandArgs.toArray(new String[commandArgs.size()]));
        }
        return 0;
    }
}

