/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.process;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import io.fabric8.jube.process.DownloadStrategy;
import io.hawt.aether.OpenMavenURL;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class InstallOptions
implements Serializable {
    public static final String DEFAULT_EXTRACT_CMD = "tar zxf";
    private static final long serialVersionUID = 4943127368399800099L;
    private final String id;
    private final String name;
    private final OpenMavenURL url;
    private final boolean offline;
    private final String[] optionalDependencyPatterns;
    private final String[] excludeDependencyFilterPatterns;
    private final Map<String, Object> properties;
    private final Map<String, String> environment;
    private final String[] jvmOptions;
    private final Map<String, File> jarFiles;
    private final DownloadStrategy downloadStrategy;

    public InstallOptions(String id, String name, OpenMavenURL url, boolean offline, String[] optionalDependencyPatterns, String[] excludeDependencyFilterPatterns, Map<String, Object> properties, Map<String, String> environment, String[] jvmOptions, Map<String, File> jarFiles, DownloadStrategy downloadStrategy) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.offline = offline;
        this.optionalDependencyPatterns = optionalDependencyPatterns;
        this.excludeDependencyFilterPatterns = excludeDependencyFilterPatterns;
        this.properties = properties;
        this.environment = environment;
        this.jvmOptions = jvmOptions;
        this.jarFiles = jarFiles;
        this.downloadStrategy = downloadStrategy;
    }

    public static InstallOptionsBuilder builder() {
        return new InstallOptionsBuilder();
    }

    public String toString() {
        return "InstallOptions{id='" + this.id + '\'' + ", url=" + this.url + ", properties=" + this.properties + ", environment=" + this.environment + ", jvmOptions=" + Arrays.toString(this.jvmOptions) + ", jarFiles=" + this.jarFiles + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallOptions that = (InstallOptions)o;
        if (this.offline != that.offline) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) {
            return false;
        }
        if (!Arrays.equals(this.excludeDependencyFilterPatterns, that.excludeDependencyFilterPatterns)) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.jarFiles != null ? !this.jarFiles.equals(that.jarFiles) : that.jarFiles != null) {
            return false;
        }
        if (!Arrays.equals(this.jvmOptions, that.jvmOptions)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (!Arrays.equals(this.optionalDependencyPatterns, that.optionalDependencyPatterns)) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals((Object)that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.offline ? 1 : 0);
        result = 31 * result + (this.optionalDependencyPatterns != null ? Arrays.hashCode(this.optionalDependencyPatterns) : 0);
        result = 31 * result + (this.excludeDependencyFilterPatterns != null ? Arrays.hashCode(this.excludeDependencyFilterPatterns) : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
        result = 31 * result + (this.jvmOptions != null ? Arrays.hashCode(this.jvmOptions) : 0);
        result = 31 * result + (this.jarFiles != null ? this.jarFiles.hashCode() : 0);
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public OpenMavenURL getUrl() {
        return this.url;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public String[] getExcludeDependencyFilterPatterns() {
        return this.excludeDependencyFilterPatterns;
    }

    public String[] getOptionalDependencyPatterns() {
        return this.optionalDependencyPatterns;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public String[] getJvmOptions() {
        return this.jvmOptions;
    }

    public Map<String, File> getJarFiles() {
        return this.jarFiles;
    }

    public DownloadStrategy getDownloadStrategy() {
        return this.downloadStrategy;
    }

    public static class InstallOptionsBuilder<T extends InstallOptionsBuilder> {
        private String id;
        private String name;
        private OpenMavenURL url;
        private String groupId;
        private String artifactId;
        private String version = "LATEST";
        private String extension = "jar";
        private String classifier;
        private boolean offline;
        private String[] optionalDependencyPatterns = new String[0];
        private String[] excludeDependencyFilterPatterns = new String[0];
        private String mainClass;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private Map<String, String> environment = new HashMap<String, String>();
        private String[] jvmOptions = new String[0];
        private Map<String, File> jarFiles = new HashMap<String, File>();
        private DownloadStrategy downloadStrategy;

        public T id(String id) {
            this.id = id;
            return (T)this;
        }

        public T name(String name) {
            this.name = name;
            return (T)this;
        }

        public T url(OpenMavenURL url) {
            this.url = url;
            return (T)this;
        }

        public T groupId(String groupId) {
            this.groupId = groupId;
            return (T)this;
        }

        public T artifactId(String artifactId) {
            this.artifactId = artifactId;
            return (T)this;
        }

        public T version(String version) {
            if (!Strings.isNullOrEmpty((String)version)) {
                this.version = version;
            }
            return (T)this;
        }

        public T extension(String extension) {
            if (!Strings.isNullOrEmpty((String)extension)) {
                this.extension = extension;
            }
            return (T)this;
        }

        public T classifier(String classifier) {
            this.classifier = classifier;
            return (T)this;
        }

        public T offline(boolean offline) {
            this.offline = offline;
            return (T)this;
        }

        public T optionalDependencyPatterns(String ... optionalDependencyPatterns) {
            this.optionalDependencyPatterns = (String[])Objects.firstNonNull((Object)optionalDependencyPatterns, (Object)new String[0]);
            return (T)this;
        }

        public T excludeDependencyFilterPatterns(String ... excludeDependencyFilterPatterns) {
            this.excludeDependencyFilterPatterns = (String[])Objects.firstNonNull((Object)excludeDependencyFilterPatterns, (Object)new String[0]);
            return (T)this;
        }

        public T mainClass(String mainClass) {
            this.mainClass = mainClass;
            return (T)this;
        }

        public T mainClass(Class mainClass) {
            this.mainClass = mainClass.getName();
            return (T)this;
        }

        public T jarFiles(Map<String, File> jarFiles) {
            this.jarFiles = new HashMap<String, File>(jarFiles);
            return (T)this;
        }

        public T downloadStrategy(DownloadStrategy downloadStrategy) {
            this.downloadStrategy = downloadStrategy;
            return (T)this;
        }

        public String getId() {
            return this.id;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public String[] getOptionalDependencyPatterns() {
            return this.optionalDependencyPatterns;
        }

        public String[] getExcludeDependencyFilterPatterns() {
            return this.excludeDependencyFilterPatterns;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public Map<String, String> getEnvironment() {
            return this.environment;
        }

        public String[] getJvmOptions() {
            return this.jvmOptions;
        }

        public DownloadStrategy getDownloadStrategy() {
            return this.downloadStrategy;
        }

        public InstallOptionsBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public InstallOptionsBuilder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public InstallOptionsBuilder jvmOptions(String ... jvmOptions) {
            this.jvmOptions = jvmOptions;
            return this;
        }

        public InstallOptionsBuilder jvmOptionsString(String jvmOptions) {
            this.jvmOptions = jvmOptions.split("\\s+?");
            return this;
        }

        public OpenMavenURL getUrl() {
            return this.url;
        }

        public String getName() {
            if (!Strings.isNullOrEmpty((String)this.name)) {
                return this.name;
            }
            if (!(Strings.isNullOrEmpty((String)this.groupId) || Strings.isNullOrEmpty((String)this.artifactId) || Strings.isNullOrEmpty((String)this.version))) {
                return this.groupId + ":" + this.artifactId + ":" + this.version;
            }
            return null;
        }

        public InstallOptions build() throws MalformedURLException {
            return new InstallOptions(this.id, this.getName(), this.getUrl(), this.offline, this.optionalDependencyPatterns, this.excludeDependencyFilterPatterns, this.properties, this.environment, this.jvmOptions, this.jarFiles, this.downloadStrategy);
        }

        public Map<String, File> getJarFiles() {
            return this.jarFiles;
        }
    }
}

