/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.process.service;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailablePortFinder {
    public static final int MIN_PORT_NUMBER = 48000;
    public static final int MAX_PORT_NUMBER = 65535;
    private static final Logger LOG = LoggerFactory.getLogger(AvailablePortFinder.class);
    private static ServerSocket LOCK;
    private AtomicInteger currentMinPort;

    public AvailablePortFinder(int minPortNumber) {
        this.currentMinPort = new AtomicInteger(minPortNumber);
        int port = minPortNumber;
        ServerSocket ss = null;
        while (ss == null) {
            try {
                ss = new ServerSocket(port);
            }
            catch (Exception e) {
                ss = null;
                port += 200;
            }
        }
        LOCK = ss;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LOCK.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.currentMinPort.set(port + 1);
    }

    public synchronized int getNextAvailable() {
        int next = this.getNextAvailable(this.currentMinPort.get());
        this.currentMinPort.set(next + 1);
        return next;
    }

    public synchronized int getNextAvailable(int fromPort) {
        if (fromPort < this.currentMinPort.get() || fromPort > 65535) {
            throw new IllegalArgumentException("From port number not in valid range: " + fromPort);
        }
        for (int i = fromPort; i <= 65535; ++i) {
            if (!this.available(i)) continue;
            LOG.info("getNextAvailable({}) -> {}", (Object)fromPort, (Object)i);
            return i;
        }
        throw new NoSuchElementException("Could not find an available port above " + fromPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean available(int port) throws IllegalArgumentException {
        if (port < this.currentMinPort.get() || port > 65535) {
            throw new IllegalArgumentException("Invalid start currentMinPort: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }
}

