/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.process.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.fabric8.jube.process.DownloadStrategy;
import io.fabric8.jube.process.InstallContext;
import io.fabric8.jube.process.InstallOptions;
import io.fabric8.jube.process.InstallTask;
import io.fabric8.jube.process.Installation;
import io.fabric8.jube.process.ProcessController;
import io.fabric8.jube.process.config.ConfigHelper;
import io.fabric8.jube.process.config.ProcessConfig;
import io.fabric8.jube.process.service.ProcessManagerServiceMBean;
import io.fabric8.jube.process.support.DefaultProcessController;
import io.fabric8.jube.process.support.ProcessUtils;
import io.fabric8.jube.process.support.command.Duration;
import io.fabric8.jube.util.InstallHelper;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Zips;
import io.hawt.aether.OpenMavenURL;
import io.hawt.util.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.deltaspike.core.api.jmx.JmxManaged;
import org.apache.deltaspike.core.api.jmx.MBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@MBean(objectName="io.fabric8.jube:type=LocalProcesses", description="Manages local processes on this node")
public class ProcessManagerService
implements ProcessManagerServiceMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessManagerService.class);
    private static final String INSTALLED_BINARY = "install.bin";
    private Executor executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("jube-process-manager-%s").build());
    private File storageLocation;
    private int lastId;
    private final Duration untarTimeout = Duration.valueOf("1h");
    private final Duration postUnpackTimeout = Duration.valueOf("1h");
    private final Duration postInstallTimeout = Duration.valueOf("1h");
    private SortedMap<String, Installation> installations = Maps.newTreeMap();
    private MBeanServer mbeanServer;
    private AtomicInteger fallbackPortGenerator = new AtomicInteger(30000);

    @Inject
    public ProcessManagerService(@ConfigProperty(name="process_dir", defaultValue="./processes") String storageLocation) throws MalformedObjectNameException, IOException {
        this(new File(storageLocation));
    }

    public ProcessManagerService(File storageLocation) throws MalformedObjectNameException, IOException {
        this.storageLocation = storageLocation;
        this.lastId = 0;
        File[] files = storageLocation.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                String name = file.getName();
                if (name.startsWith(".")) {
                    LOGGER.debug("Ignoring deleted installation at folder " + name);
                    continue;
                }
                if (name.matches("\\d+")) {
                    try {
                        int id = Integer.parseInt(name);
                        if (id > this.lastId) {
                            this.lastId = id;
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                OpenMavenURL url = null;
                ProcessConfig config = ConfigHelper.loadProcessConfig(file);
                this.createInstallation(url, name, ProcessUtils.findInstallDir(file), config);
            }
        }
    }

    public String toString() {
        return "ProcessManager(" + this.storageLocation + ")";
    }

    public ImmutableList<Installation> listInstallations() {
        return ImmutableList.copyOf(this.installations.values());
    }

    @Override
    public ImmutableMap<String, Installation> listInstallationMap() {
        return ImmutableMap.copyOf(this.installations);
    }

    @Override
    public Installation getInstallation(String id) {
        return (Installation)this.installations.get(id);
    }

    @JmxManaged(description="Returns the set of installed processes")
    public String getInstallationIds() {
        return this.listInstallationMap().keySet().toString();
    }

    @JmxManaged(description="Returns the number of installed processes")
    public int getInstallationCount() {
        return this.listInstallationMap().keySet().size();
    }

    @Override
    public Installation install(final InstallOptions options, InstallTask postInstall) throws Exception {
        InstallTask installTask = new InstallTask(){

            @Override
            public void install(InstallContext installContext, ProcessConfig config, String id, File installDir) throws Exception {
                config.setName(options.getName());
                installDir.mkdirs();
                File archive = ProcessManagerService.this.getDownloadStrategy(options).downloadContent(options.getUrl(), installDir);
                if (archive == null) {
                    archive = new File(installDir, ProcessManagerService.INSTALLED_BINARY);
                }
                File nestedProcessDirectory = null;
                if (archive.exists()) {
                    Zips.unzip((InputStream)new FileInputStream(archive), (File)installDir);
                    InstallHelper.chmodAllScripts((File)installDir);
                    nestedProcessDirectory = ProcessUtils.findInstallDir(installDir);
                    ProcessManagerService.this.allocatePorts(options, nestedProcessDirectory);
                    ProcessManagerService.this.exportInstallDirEnvVar(options, nestedProcessDirectory, installContext, config);
                }
            }
        };
        return this.installViaScript(options, installTask);
    }

    protected DownloadStrategy getDownloadStrategy(InstallOptions options) {
        DownloadStrategy answer = options.getDownloadStrategy();
        if (answer == null) {
            answer = this.createDefaultDownloadStrategy();
        }
        return answer;
    }

    protected void allocatePorts(InstallOptions options, File nestedProcessDirectory) throws IOException {
        Map ports = InstallHelper.readPortsFromDirectory((File)nestedProcessDirectory);
        Set entries = ports.entrySet();
        if (!entries.isEmpty()) {
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!Strings.isNotBlank((String)key) || !Strings.isNotBlank((String)value)) continue;
                String envVarName = InstallHelper.portNameToHostEnvVarName((String)key);
                int port = this.allocatePortNumber(options, nestedProcessDirectory, key, value);
                if (port <= 0) {
                    System.out.println("Could not allocate port " + envVarName + " has value: " + port);
                    LOGGER.warn("Could not allocate port " + envVarName + " has value: " + port);
                    continue;
                }
                options.getEnvironment().put(envVarName, "" + port);
            }
            System.out.println("============ ports " + ports + " mapped to env vars: " + options.getEnvironment());
        }
    }

    public static String getLocalHostName() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            int colon;
            String host = uhe.getMessage();
            if (host != null && (colon = host.indexOf(58)) > 0) {
                return host.substring(0, colon);
            }
            throw uhe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int allocatePortNumber(InstallOptions options, File nestedProcessDirectory, String key, String value) {
        int n;
        ServerSocket ss = null;
        try {
            String hostName = ProcessManagerService.getLocalHostName();
            int idGeneratorPort = 0;
            ss = new ServerSocket(idGeneratorPort);
            n = ss.getLocalPort();
        }
        catch (Exception e) {
            int n2;
            try {
                LOGGER.warn("Failed to allocate port " + key + ". " + e, (Throwable)e);
                n2 = this.fallbackPortGenerator.incrementAndGet();
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(ss);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)ss);
            return n2;
        }
        Closeables.closeQuietly((Closeable)ss);
        return n;
    }

    protected void exportInstallDirEnvVar(InstallOptions options, File installDir, InstallContext installContext, ProcessConfig config) throws IOException {
        options.getEnvironment().put("APP_BASE", installDir.getAbsolutePath());
        ProcessManagerService.substituteEnvironmentVariableExpressions(options.getEnvironment(), options.getEnvironment());
        config.getEnvironment().putAll(options.getEnvironment());
    }

    @Override
    public void uninstall(Installation installation) {
        installation.getController().uninstall();
        this.installations.remove(installation.getId());
    }

    @Override
    public ProcessConfig loadProcessConfig(File installDir, InstallOptions options) throws IOException {
        ProcessConfig config = this.loadControllerJson(installDir, options);
        Map<String, String> configEnv = config.getEnvironment();
        Map<String, String> optionsEnv = options.getEnvironment();
        if (optionsEnv != null) {
            configEnv.putAll(optionsEnv);
        }
        return config;
    }

    public File getStorageLocation() {
        return this.storageLocation;
    }

    public void setStorageLocation(File storageLocation) {
        this.storageLocation = storageLocation;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    protected Installation installViaScript(InstallOptions options, InstallTask installTask) throws Exception {
        String id = this.createNextId(options);
        File installDir = this.createInstallDir(id);
        installDir.mkdirs();
        ProcessConfig config = this.loadProcessConfig(installDir, options);
        InstallContext installContext = new InstallContext(installDir, false);
        installTask.install(installContext, config, id, installDir);
        ConfigHelper.saveProcessConfig(config, installDir);
        Installation installation = this.createInstallation(options.getUrl(), id, installDir, config);
        installation.getController().install();
        return installation;
    }

    protected DownloadStrategy createDefaultDownloadStrategy() {
        return new DownloadStrategy(){

            @Override
            public File downloadContent(OpenMavenURL sourceUrl, File installDir) throws IOException {
                Objects.notNull((Object)sourceUrl, (String)"sourceUrl");
                File archive = new File(installDir, ProcessManagerService.INSTALLED_BINARY);
                InputStream from = sourceUrl.getInputStream();
                if (from == null) {
                    throw new FileNotFoundException("Could not open URL: " + sourceUrl);
                }
                ByteStreams.copy((InputStream)from, (OutputStream)new FileOutputStream(archive));
                return archive;
            }
        };
    }

    protected ProcessConfig loadControllerJson(File installDir, InstallOptions options) throws IOException {
        return ConfigHelper.loadProcessConfig(installDir);
    }

    protected synchronized String createNextId(InstallOptions options) {
        String answer;
        File dir;
        String id = options.getId();
        if (Strings.isNotBlank((String)id)) {
            return id;
        }
        do {
            ++this.lastId;
        } while ((dir = this.createInstallDir(answer = "" + this.lastId)).exists());
        return answer;
    }

    protected File createInstallDir(String id) {
        return new File(this.storageLocation, id);
    }

    protected Installation createInstallation(OpenMavenURL url, String id, File rootDir, ProcessConfig config) {
        File installDir = ProcessUtils.findInstallDir(rootDir);
        ProcessController controller = this.createController(id, config, rootDir, installDir);
        Installation installation = new Installation(url, id, installDir, controller, config);
        this.installations.put(id, installation);
        return installation;
    }

    protected ProcessController createController(String id, ProcessConfig config, File rootDir, File installDir) {
        return new DefaultProcessController(id, config, rootDir, installDir);
    }

    public static void substituteEnvironmentVariableExpressions(Map<String, String> map, Map<String, String> environmentVariables) {
        Set<Map.Entry<String, String>> envEntries = environmentVariables.entrySet();
        for (String key : map.keySet()) {
            String text;
            String oldText = text = map.get(key);
            if (!Strings.isNotBlank((String)text)) continue;
            for (Map.Entry<String, String> envEntry : envEntries) {
                String envKey = envEntry.getKey();
                String envValue = envEntry.getValue();
                if (!Strings.isNotBlank((String)envKey) || !Strings.isNotBlank((String)envValue)) continue;
                text = text.replace("${env:" + envKey + "}", envValue);
            }
            if (Objects.equal((Object)oldText, (Object)text)) continue;
            map.put(key, text);
        }
    }
}

