/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.process.config;

import io.fabric8.jube.process.config.ProcessConfig;
import io.fabric8.jube.util.InstallHelper;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConfigHelper.class);

    private ConfigHelper() {
    }

    public static ProcessConfig loadProcessConfig(File installDir) throws IOException {
        File file = ConfigHelper.createControllerConfigFile(installDir);
        ProcessConfig answer = new ProcessConfig(installDir);
        if (!file.exists()) {
            LOG.warn("Process configuration file " + file.getPath() + " does not exist");
            return answer;
        }
        return answer;
    }

    public static void saveProcessConfig(ProcessConfig config, File installDir) throws IOException {
        File file = ConfigHelper.createControllerConfigFile(installDir);
        InstallHelper.writeEnvironmentVariables((File)file, config.getEnvironment());
    }

    public static File createControllerConfigFile(File installDir) {
        return new File(installDir, "env.sh");
    }
}

