/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.process.support.command;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Duration
implements Comparable<Duration> {
    private static final Pattern DURATION_PATTERN = Pattern.compile("^\\s*(\\d+(?:\\.\\d+)?)\\s*(s|m|h|d|ms)\\s*$");
    private final double millis;

    public Duration(double value, TimeUnit timeUnit) {
        Preconditions.checkArgument((!Double.isInfinite(value) ? 1 : 0) != 0, (Object)"value is infinite");
        Preconditions.checkArgument((!Double.isNaN(value) ? 1 : 0) != 0, (Object)"value is not a number");
        Preconditions.checkArgument((value >= 0.0 ? 1 : 0) != 0, (Object)"value is negative");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"timeUnit is null");
        double conversionFactor = Duration.millisPerTimeUnit(timeUnit);
        this.millis = value * conversionFactor;
    }

    public static Duration nanosSince(long start) {
        long end = System.nanoTime();
        return new Duration(end - start, TimeUnit.NANOSECONDS);
    }

    public double toMillis() {
        return this.millis;
    }

    public double convertTo(TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is null");
        }
        return Duration.convertTo(this.millis, timeUnit);
    }

    private static double convertTo(double millis, TimeUnit timeUnit) {
        double conversionFactor = Duration.millisPerTimeUnit(timeUnit);
        return millis / conversionFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        return Double.compare(duration.millis, this.millis) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.millis);
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public int compareTo(Duration o) {
        return Double.compare(this.millis, o.millis);
    }

    public String toString() {
        return this.toString(TimeUnit.MILLISECONDS);
    }

    public String toString(TimeUnit timeUnit) {
        String timeUnitAbbreviation;
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is null");
        }
        double magnitude = Duration.convertTo(this.millis, timeUnit);
        switch (timeUnit) {
            case MILLISECONDS: {
                timeUnitAbbreviation = "ms";
                break;
            }
            case SECONDS: {
                timeUnitAbbreviation = "s";
                break;
            }
            case MINUTES: {
                timeUnitAbbreviation = "m";
                break;
            }
            case HOURS: {
                timeUnitAbbreviation = "h";
                break;
            }
            case DAYS: {
                timeUnitAbbreviation = "d";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported time unit " + (Object)((Object)timeUnit));
            }
        }
        return String.format("%.2f%s", magnitude, timeUnitAbbreviation);
    }

    private static double millisPerTimeUnit(TimeUnit timeUnit) {
        double conversionFactor;
        switch (timeUnit) {
            case NANOSECONDS: {
                conversionFactor = 1.0E-6;
                break;
            }
            case MICROSECONDS: {
                conversionFactor = 0.001;
                break;
            }
            case MILLISECONDS: {
                conversionFactor = 1.0;
                break;
            }
            case SECONDS: {
                conversionFactor = 1000.0;
                break;
            }
            case MINUTES: {
                conversionFactor = 60000.0;
                break;
            }
            case HOURS: {
                conversionFactor = 3600000.0;
                break;
            }
            case DAYS: {
                conversionFactor = 8.64E7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported time unit " + (Object)((Object)timeUnit));
            }
        }
        return conversionFactor;
    }

    public static Duration valueOf(String duration) throws IllegalArgumentException {
        TimeUnit timeUnit;
        Preconditions.checkNotNull((Object)duration, (Object)"duration is null");
        Preconditions.checkArgument((!duration.isEmpty() ? 1 : 0) != 0, (Object)"duration is empty");
        Matcher matcher = DURATION_PATTERN.matcher(duration);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("duration is not a valid duration string: " + duration);
        }
        String magnitudeString = matcher.group(1);
        double magnitude = Double.parseDouble(magnitudeString);
        String timeUnitString = matcher.group(2);
        if (timeUnitString.equals("ms")) {
            timeUnit = TimeUnit.MILLISECONDS;
        } else if (timeUnitString.equals("s")) {
            timeUnit = TimeUnit.SECONDS;
        } else if (timeUnitString.equals("m")) {
            timeUnit = TimeUnit.MINUTES;
        } else if (timeUnitString.equals("h")) {
            timeUnit = TimeUnit.HOURS;
        } else if (timeUnitString.equals("d")) {
            timeUnit = TimeUnit.DAYS;
        } else {
            throw new IllegalArgumentException("Unknown time unit: " + timeUnitString);
        }
        return new Duration(magnitude, timeUnit);
    }
}

