/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.process.support;

import io.fabric8.jube.process.InstallContext;
import io.fabric8.jube.process.InstallTask;
import io.fabric8.jube.process.config.ProcessConfig;
import io.fabric8.jube.process.support.ProcessUtils;
import io.fabric8.utils.Files;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveFilesTask
implements InstallTask {
    private static final transient Logger LOG = LoggerFactory.getLogger(RemoveFilesTask.class);
    private final String[] removePaths;

    public RemoveFilesTask(String[] removePaths) {
        this.removePaths = removePaths;
    }

    @Override
    public void install(InstallContext installContext, ProcessConfig config, String id, File installDir) throws Exception {
        if (this.removePaths != null) {
            File baseDir = ProcessUtils.findInstallDir(installDir);
            for (String removePath : this.removePaths) {
                File removeFile = new File(baseDir, removePath);
                if (removeFile.exists()) {
                    LOG.info("Removing file " + removeFile);
                    Files.recursiveDelete((File)removeFile);
                    continue;
                }
                LOG.warn("Post unpack removal path " + removePath + " does not exist at " + removeFile);
            }
        }
    }
}

