/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.process.config;

import io.fabric8.jube.process.support.command.Command;
import io.fabric8.jube.process.support.command.CommandFailedException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;

public class ProcessConfig
implements Serializable {
    private static final long serialVersionUID = -2472076539312397232L;
    private String name = "<unknown>";
    private String launchScript;
    private String startCommand;
    private String stopCommand;
    private String restartCommand;
    private String statusCommand;
    private String killCommand;
    private String configureCommand;
    private String pidFile;
    private Map<String, String> environment = new TreeMap<String, String>();
    private List<String> installCommands = new ArrayList<String>();
    private String deployPath;
    private String sharedLibraryPath;
    private File installDir;

    public ProcessConfig() {
        this.init(null);
    }

    public ProcessConfig(File installDir) {
        this.init(installDir);
    }

    private void init(File installDir) {
        this.installDir = installDir;
        this.startCommand = this.toCommand("start");
        this.stopCommand = this.toCommand("stop");
        this.restartCommand = this.toCommand("restart");
        this.statusCommand = this.toCommand("status");
        this.killCommand = this.toCommand("kill");
        this.pidFile = "process.pid";
    }

    protected String toCommand(String commandName) {
        if (ProcessConfig.isWindows()) {
            return commandName + ".bat";
        }
        String path = this.installDir != null ? this.installDir.getAbsolutePath() : ".";
        return "bash -c " + path + "/" + commandName + ".sh";
    }

    private static boolean isWindows() {
        try {
            String osName = System.getProperty("os.name");
            return osName != null && osName.startsWith("Windows");
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessConfig that = (ProcessConfig)o;
        if (this.configureCommand != null ? !this.configureCommand.equals(that.configureCommand) : that.configureCommand != null) {
            return false;
        }
        if (this.deployPath != null ? !this.deployPath.equals(that.deployPath) : that.deployPath != null) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) {
            return false;
        }
        if (this.installCommands != null ? !this.installCommands.equals(that.installCommands) : that.installCommands != null) {
            return false;
        }
        if (this.killCommand != null ? !this.killCommand.equals(that.killCommand) : that.killCommand != null) {
            return false;
        }
        if (this.launchScript != null ? !this.launchScript.equals(that.launchScript) : that.launchScript != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.pidFile != null ? !this.pidFile.equals(that.pidFile) : that.pidFile != null) {
            return false;
        }
        if (this.restartCommand != null ? !this.restartCommand.equals(that.restartCommand) : that.restartCommand != null) {
            return false;
        }
        if (this.sharedLibraryPath != null ? !this.sharedLibraryPath.equals(that.sharedLibraryPath) : that.sharedLibraryPath != null) {
            return false;
        }
        if (this.startCommand != null ? !this.startCommand.equals(that.startCommand) : that.startCommand != null) {
            return false;
        }
        if (this.statusCommand != null ? !this.statusCommand.equals(that.statusCommand) : that.statusCommand != null) {
            return false;
        }
        return !(this.stopCommand != null ? !this.stopCommand.equals(that.stopCommand) : that.stopCommand != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.launchScript != null ? this.launchScript.hashCode() : 0);
        result = 31 * result + (this.startCommand != null ? this.startCommand.hashCode() : 0);
        result = 31 * result + (this.stopCommand != null ? this.stopCommand.hashCode() : 0);
        result = 31 * result + (this.restartCommand != null ? this.restartCommand.hashCode() : 0);
        result = 31 * result + (this.statusCommand != null ? this.statusCommand.hashCode() : 0);
        result = 31 * result + (this.killCommand != null ? this.killCommand.hashCode() : 0);
        result = 31 * result + (this.configureCommand != null ? this.configureCommand.hashCode() : 0);
        result = 31 * result + (this.pidFile != null ? this.pidFile.hashCode() : 0);
        result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
        result = 31 * result + (this.installCommands != null ? this.installCommands.hashCode() : 0);
        result = 31 * result + (this.deployPath != null ? this.deployPath.hashCode() : 0);
        result = 31 * result + (this.sharedLibraryPath != null ? this.sharedLibraryPath.hashCode() : 0);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKillCommand() {
        return this.killCommand;
    }

    public void setKillCommand(String killCommand) {
        this.killCommand = killCommand;
    }

    public String getLaunchScript() {
        return this.launchScript;
    }

    public void setLaunchScript(String launchScript) {
        this.launchScript = launchScript;
    }

    public String getPidFile() {
        return this.pidFile;
    }

    public void setPidFile(String pidFile) {
        this.pidFile = pidFile;
    }

    public String getRestartCommand() {
        return this.restartCommand;
    }

    public void setRestartCommand(String restartCommand) {
        this.restartCommand = restartCommand;
    }

    public String getStartCommand() {
        return this.startCommand;
    }

    public void setStartCommand(String startCommand) {
        this.startCommand = startCommand;
    }

    public String getStatusCommand() {
        return this.statusCommand;
    }

    public void setStatusCommand(String statusCommand) {
        this.statusCommand = statusCommand;
    }

    public String getStopCommand() {
        return this.stopCommand;
    }

    public void setStopCommand(String stopCommand) {
        this.stopCommand = stopCommand;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public List<String> getInstallCommands() {
        return this.installCommands;
    }

    public String getConfigureCommand() {
        return this.configureCommand;
    }

    public void setConfigureCommand(String configureCommand) {
        this.configureCommand = configureCommand;
    }

    public String getDeployPath() {
        return this.deployPath;
    }

    public void setDeployPath(String deployPath) {
        this.deployPath = deployPath;
    }

    public String getSharedLibraryPath() {
        return this.sharedLibraryPath;
    }

    public void setSharedLibraryPath(String sharedLibraryPath) {
        this.sharedLibraryPath = sharedLibraryPath;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = new TreeMap<String, String>(environment);
    }

    public void setInstallCommands(List<String> installCommands) {
        this.installCommands = installCommands;
    }

    public int runCommand(Executor executor, File baseDir, String ... arguments) throws IOException, InterruptedException, CommandFailedException {
        if (arguments == null || arguments.length == 0) {
            return 0;
        }
        System.out.println("--- running command " + Arrays.asList(arguments) + " in directory " + baseDir.getAbsolutePath());
        Command command = new Command(arguments).setDirectory(baseDir);
        Map<String, String> environment = this.getEnvironment();
        if (environment != null && environment.size() > 0) {
            command = command.addEnvironment(environment);
        }
        return command.execute(executor);
    }
}

