/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.process;

import io.fabric8.utils.FileChangeInfo;
import io.fabric8.utils.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallContext {
    private static final transient Logger LOG = LoggerFactory.getLogger(InstallContext.class);
    private final File installDir;
    private final boolean updateMode;
    private List<String> restartReasons = new ArrayList<String>();
    private List<String> redeployReasons = new ArrayList<String>();
    private Properties containerChecksums;

    public InstallContext(File installDir, boolean updateMode) {
        this.installDir = installDir;
        this.updateMode = updateMode;
    }

    public void addRestartReason(String message) {
        this.restartReasons.add(message);
    }

    public void addRestartReason(File target) {
        String path = null;
        try {
            path = Files.getRelativePath((File)this.installDir, (File)target);
        }
        catch (IOException e) {
            LOG.warn("Failed to calculate relative path from " + this.installDir + " to " + target + ". " + e, (Throwable)e);
        }
        if (path == null) {
            path = target.getPath();
        }
        this.addRestartReason(path);
    }

    public void addRedeployReason(String message) {
        this.redeployReasons.add(message);
    }

    public File getInstallDir() {
        return this.installDir;
    }

    public List<String> getRestartReasons() {
        return this.restartReasons;
    }

    public List<String> getRedeployReasons() {
        return this.redeployReasons;
    }

    public boolean isUpdateMode() {
        return this.updateMode;
    }

    public boolean isRestartRequired() {
        return this.restartReasons.size() > 0;
    }

    public boolean isRedeployRequired() {
        return this.redeployReasons.size() > 0;
    }

    public FileChangeInfo onFileWrite(File target, FileChangeInfo oldChangeInfo) throws IOException {
        if (this.updateMode) {
            if (oldChangeInfo != null) {
                FileChangeInfo changeInfo = FileChangeInfo.newInstance((File)target);
                if (!oldChangeInfo.equals((Object)changeInfo)) {
                    this.addRestartReason(target);
                }
                return changeInfo;
            }
            if (target.isFile() && target.exists()) {
                this.addRestartReason(target);
            }
        }
        return null;
    }

    public void onDeploymentFileWrite(String location, File target, FileChangeInfo oldChangeInfo, boolean isSharedLibrary) throws IOException {
        FileChangeInfo changeInfo = FileChangeInfo.newInstance((File)target);
        boolean updateChecksums = true;
        if (this.updateMode) {
            if (oldChangeInfo != null) {
                if (oldChangeInfo.equals((Object)changeInfo)) {
                    updateChecksums = false;
                } else if (isSharedLibrary) {
                    this.addRestartReason(target);
                }
            } else if (target.isFile() && target.exists()) {
                if (isSharedLibrary) {
                    this.addRestartReason(target);
                }
            } else {
                updateChecksums = false;
            }
        }
    }

    public FileChangeInfo createChangeInfo(File destFile) throws IOException {
        if (this.updateMode) {
            return FileChangeInfo.newInstance((File)destFile);
        }
        return null;
    }

    public FileChangeInfo createChangeInfo(File destFile, Long cachedChecksum) throws IOException {
        if (cachedChecksum != null) {
            return new FileChangeInfo(destFile.length(), cachedChecksum.longValue());
        }
        return this.createChangeInfo(destFile);
    }
}

