/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jube.maven;

import io.fabric8.jube.maven.JubeArchiveConfigurationSource;
import io.fabric8.jube.util.ImageMavenCoords;
import io.fabric8.jube.util.InstallHelper;
import io.fabric8.utils.Objects;
import io.fabric8.utils.PropertiesHelper;
import io.fabric8.utils.Zips;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.io.AssemblyReadException;
import org.apache.maven.plugin.assembly.io.AssemblyReader;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="build")
public class BuildMojo
extends AbstractMojo {
    public static final String DOCKER_IMAGE_PROPERTY = "docker.dataImage";
    public static final String DOCKER_BASE_IMAGE_PROPERTY = "docker.baseImage";
    private static final transient Logger LOG = LoggerFactory.getLogger(BuildMojo.class);
    @Parameter(property="docker.dataImage", defaultValue="${project.groupId}/${project.artifactId}")
    private String image;
    @Parameter(property="docker.baseImage", defaultValue="fabric8/java")
    private String baseImage;
    @Parameter(property="exportDir", defaultValue="/maven")
    private String exportDir;
    @Parameter
    private Map<String, String> environmentVariables;
    @Parameter
    private Map<String, String> ports;
    @Parameter
    private String assemblyDescriptor;
    @Parameter(property="fabric8.assemblyDescriptorRef", defaultValue="artifact-with-dependencies")
    private String assemblyDescriptorRef;
    @Parameter(property="jube.outFile", defaultValue="${project.build.directory}/${project.artifactId}-${project.version}-image.zip")
    private File outputZipFile;
    @Parameter(property="jube.zip.artifactType", defaultValue="zip")
    private String artifactType = "zip";
    @Parameter(property="jube.zip.artifactClassifier", defaultValue="image")
    private String artifactClassifier = "image";
    @Parameter(property="fabric8.container.name", defaultValue="${project.artifactId}")
    private String service;
    @Parameter(property="fabric8.app.name", defaultValue="${project.name}")
    private String serviceName;
    @Parameter
    private MavenArchiveConfiguration archive;
    @Component
    private MavenProject project;
    @Component
    private MavenSession session;
    @Component
    private MavenFileFilter mavenFileFilter;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Component
    private AssemblyArchiver assemblyArchiver;
    @Component
    private AssemblyReader assemblyReader;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isIgnoreProject()) {
            return;
        }
        this.getLog().info((CharSequence)("Generating Jube image " + this.image + " from base image " + this.baseImage));
        this.getLog().info((CharSequence)("Assembly reference: " + this.assemblyDescriptorRef));
        if (this.assemblyDescriptor == null && this.assemblyDescriptorRef == null) {
            throw new MojoExecutionException("No assemblyDescriptor or assemblyDescriptorRef has been given");
        }
        System.out.println("Env vars: " + this.getEnvironmentVariables());
        this.createAssembly();
    }

    protected boolean isIgnoreProject() {
        return "pom".equals(this.project.getPackaging());
    }

    public Map<String, String> getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = new HashMap<String, String>();
        }
        if (this.environmentVariables.isEmpty()) {
            this.environmentVariables = PropertiesHelper.findPropertiesWithPrefix((Properties)this.project.getProperties(), (String)"docker.env.");
        }
        if (!this.environmentVariables.containsKey("SERVICE")) {
            this.environmentVariables.put("SERVICE", this.service);
        }
        if (!this.environmentVariables.containsKey("SERVICE_NAME")) {
            this.environmentVariables.put("SERVICE_NAME", this.serviceName);
        }
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public Map<String, String> getPorts() {
        if (this.ports == null) {
            this.ports = new HashMap<String, String>();
        }
        if (this.ports.isEmpty()) {
            this.ports = PropertiesHelper.findPropertiesWithPrefix((Properties)this.project.getProperties(), (String)"docker.port.container.");
        }
        return this.ports;
    }

    protected void createAssembly() throws MojoFailureException, MojoExecutionException {
        String extractBaseImageRef = "extractBaseImage";
        String createZipRef = "createZip";
        AssemblerConfigurationSource extractConfig = this.createAssemblyConfigurationSource(null, extractBaseImageRef);
        AssemblerConfigurationSource projectConfig = this.createAssemblyConfigurationSource(this.assemblyDescriptor, this.assemblyDescriptorRef);
        AssemblerConfigurationSource zipConfig = this.createAssemblyConfigurationSource(null, createZipRef);
        Assembly assembly = null;
        File buildDir = new File(this.project.getBasedir(), "target/jube");
        try {
            buildDir.mkdirs();
            try {
                this.unpackBaseImage(buildDir, false);
            }
            catch (ArtifactResolutionException e) {
                this.unpackBaseImage(buildDir, true);
            }
            catch (ArtifactNotFoundException e) {
                this.unpackBaseImage(buildDir, true);
            }
            this.writeEnvironmentVariables(buildDir);
            this.writePorts(buildDir);
            assembly = this.extractAssembly(projectConfig);
            assembly.setId("docker");
            if (this.exportDir.startsWith("/")) {
                this.exportDir = this.exportDir.substring(1);
            }
            this.assemblyArchiver.createArchive(assembly, this.exportDir, "dir", projectConfig, false);
            InstallHelper.chmodAllScripts((File)buildDir);
            Zips.createZipFile((Logger)LOG, (File)buildDir, (File)this.outputZipFile);
            this.getLog().info((CharSequence)("Created image zip: " + this.outputZipFile));
            this.attachArtifactToBuild();
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoFailureException((Object)assembly, "Assembly is incorrectly configured: " + assembly.getId(), "Assembly: " + assembly.getId() + " is not configured correctly: " + e.getMessage());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create assembly for image: " + e.getMessage(), e);
        }
    }

    protected void attachArtifactToBuild() {
        this.projectHelper.attachArtifact(this.project, this.artifactType, this.artifactClassifier, this.outputZipFile);
    }

    protected void writeEnvironmentVariables(File buildDir) throws IOException {
        Map<String, String> envMap = this.getEnvironmentVariables();
        File envScript = new File(buildDir, "env.sh");
        InstallHelper.writeEnvironmentVariables((File)envScript, envMap);
    }

    protected void writePorts(File buildDir) throws IOException {
        Map<String, String> portMap = this.getPorts();
        if (portMap.isEmpty()) {
            return;
        }
        File envScript = new File(buildDir, "ports.properties");
        InstallHelper.writePorts((File)envScript, portMap);
    }

    protected void unpackBaseImage(File buildDir, boolean useDefaultPrefix) throws Exception {
        String imageName = this.project.getProperties().getProperty(DOCKER_BASE_IMAGE_PROPERTY);
        Objects.notNull((Object)imageName, (String)DOCKER_BASE_IMAGE_PROPERTY);
        ImageMavenCoords baseImageCoords = ImageMavenCoords.parse((String)imageName, (boolean)useDefaultPrefix);
        String coords = baseImageCoords.getAetherCoords();
        this.getLog().info((CharSequence)("Looking up Jube: " + coords));
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(baseImageCoords.getGroupId(), baseImageCoords.getArtifactId(), baseImageCoords.getVersion(), baseImageCoords.getType(), baseImageCoords.getClassifier());
        this.artifactResolver.resolve(artifact, this.pomRemoteRepositories, this.localRepository);
        System.out.println(artifact.getFile());
        if (artifact.getFile() != null) {
            File file = artifact.getFile();
            this.getLog().info((CharSequence)("File: " + file));
            if (!file.exists() || file.isDirectory()) {
                throw new MojoExecutionException("Resolved file for " + coords + " is not a valid file: " + file.getAbsolutePath());
            }
            this.getLog().info((CharSequence)("Unpacking base image " + file.getAbsolutePath() + " to build dir: " + buildDir));
            Zips.unzip((InputStream)new FileInputStream(file), (File)buildDir);
        }
    }

    private AssemblerConfigurationSource createAssemblyConfigurationSource(String descriptor, String descriptorRef) {
        String[] descriptors = null;
        String[] descriptorRefs = null;
        if (descriptor != null) {
            descriptors = new String[]{descriptor};
        } else if (descriptorRef != null) {
            descriptorRefs = new String[]{descriptorRef};
        }
        return new JubeArchiveConfigurationSource(this.project, this.session, this.archive, this.mavenFileFilter, descriptors, descriptorRefs);
    }

    private Assembly extractAssembly(AssemblerConfigurationSource config) throws MojoExecutionException, MojoFailureException {
        try {
            List assemblies = this.assemblyReader.readAssemblies(config);
            if (assemblies.size() != 1) {
                throw new MojoFailureException("Only one assembly can be used for creating a Docker base image (and not " + assemblies.size() + ")");
            }
            return (Assembly)assemblies.get(0);
        }
        catch (AssemblyReadException e) {
            throw new MojoExecutionException("Error reading assembly: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoFailureException((Object)this.assemblyReader, e.getMessage(), "Docker assembly configuration is invalid: " + e.getMessage());
        }
    }
}

