/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsonSchema.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonSchema.types.ContainerTypeSchema;
import com.fasterxml.jackson.databind.jsonSchema.types.JsonSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSchema
extends ContainerTypeSchema {
    @JsonProperty
    private AdditionalProperties additionalProperties;
    @JsonProperty
    private List<Dependency> dependencies;
    @JsonProperty
    private Map<String, JsonSchema> patternProperties;
    @JsonProperty
    private Map<String, JsonSchema> properties;
    @JsonIgnore
    private final JsonFormatTypes type = JsonFormatTypes.OBJECT;

    public ObjectSchema() {
        this.dependencies = new ArrayList<Dependency>();
        this.patternProperties = new HashMap<String, JsonSchema>();
        this.properties = new HashMap<String, JsonSchema>();
    }

    public boolean addSchemaDependency(String depender, JsonSchema parentMustMatch) {
        return this.dependencies.add(new SchemaDependency(depender, parentMustMatch));
    }

    public boolean addSimpleDependency(String depender, String dependsOn) {
        return this.dependencies.add(new SimpleDependency(depender, dependsOn));
    }

    @Override
    public ObjectSchema asObjectSchema() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ObjectSchema) {
            ObjectSchema that = (ObjectSchema)obj;
            return this.getAdditionalProperties() == null ? that.getAdditionalProperties() == null : (this.getAdditionalProperties().equals(that.getAdditionalProperties()) && this.getDependencies() == null ? that.getDependencies() == null : (((Object)this.getDependencies()).equals(that.getDependencies()) && this.getPatternProperties() == null ? that.getPatternProperties() == null : (((Object)this.getPatternProperties()).equals(that.getPatternProperties()) && this.getProperties() == null ? that.getProperties() == null : ((Object)this.getProperties()).equals(that.getProperties()) && super.equals(obj))));
        }
        return false;
    }

    public AdditionalProperties getAdditionalProperties() {
        return this.additionalProperties;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Map<String, JsonSchema> getPatternProperties() {
        return this.patternProperties;
    }

    public Map<String, JsonSchema> getProperties() {
        return this.properties;
    }

    @Override
    public JsonFormatTypes getType() {
        return this.type;
    }

    @Override
    public boolean isObjectSchema() {
        return true;
    }

    public void putOptionalProperty(String name, JsonSchema jsonSchema) {
        this.properties.put(name, jsonSchema);
    }

    public JsonSchema putPatternProperty(String regex, JsonSchema value) {
        return this.patternProperties.put(regex, value);
    }

    public JsonSchema putProperty(String name, JsonSchema value) {
        value.setRequired(true);
        return this.properties.put(name, value);
    }

    public void rejectAdditionalProperties() {
        this.additionalProperties = NoAdditionalProperties.instance;
    }

    public void setAdditionalProperties(AdditionalProperties additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void setPatternProperties(Map<String, JsonSchema> patternProperties) {
        this.patternProperties = patternProperties;
    }

    public void setProperties(Map<String, JsonSchema> properties) {
        this.properties = properties;
    }

    public static class SimpleDependency
    extends Dependency {
        @JsonProperty(required=true)
        private String depender;
        @JsonProperty(required=true)
        private String dependsOn;

        public SimpleDependency(String depender, String dependsOn) {
            this.depender = depender;
            this.dependsOn = dependsOn;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SchemaDependency) {
                SimpleDependency that = (SimpleDependency)obj;
                return this.getDepender() == null ? that.getDepender() == null : (this.getDepender().equals(that.getDepender()) && this.getDependsOn() == null ? that.getDependsOn() == null : this.getDependsOn().equals(that.getDependsOn()));
            }
            return false;
        }

        public String getDepender() {
            return this.depender;
        }

        public String getDependsOn() {
            return this.dependsOn;
        }
    }

    public static class SchemaDependency
    extends Dependency {
        @JsonProperty(required=true)
        private String depender;
        @JsonProperty(required=true)
        private JsonSchema parentMustMatch;

        public SchemaDependency(String depender, JsonSchema parentMustMatch) {
            this.depender = depender;
            this.parentMustMatch = parentMustMatch;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SchemaDependency) {
                SchemaDependency that = (SchemaDependency)obj;
                return this.getDepender() == null ? that.getDepender() == null : (this.getDepender().equals(that.getDepender()) && this.getParentMustMatch() == null ? that.getParentMustMatch() == null : this.getParentMustMatch().equals(that.getParentMustMatch()));
            }
            return false;
        }

        public String getDepender() {
            return this.depender;
        }

        public JsonSchema getParentMustMatch() {
            return this.parentMustMatch;
        }
    }

    public static class SchemaAdditionalProperties
    extends AdditionalProperties {
        @JsonProperty
        private JsonSchema jsonSchema;

        public boolean equals(Object obj) {
            return obj instanceof SchemaAdditionalProperties && this.getJsonSchema() == null ? ((SchemaAdditionalProperties)obj).getJsonSchema() == null : this.getJsonSchema().equals(((SchemaAdditionalProperties)obj).getJsonSchema());
        }

        public JsonSchema getJsonSchema() {
            return this.jsonSchema;
        }

        public SchemaAdditionalProperties(JsonSchema jsonSchema) {
            this.jsonSchema = jsonSchema;
        }
    }

    public static class NoAdditionalProperties
    extends AdditionalProperties {
        public final Boolean schema = false;
        public static final NoAdditionalProperties instance = new NoAdditionalProperties();

        protected NoAdditionalProperties() {
        }

        public boolean equals(Object obj) {
            return obj instanceof NoAdditionalProperties;
        }

        @JsonValue
        public Boolean value() {
            return this.schema;
        }
    }

    public static abstract class Dependency {
        @JsonCreator
        public Dependency jsonCreator() {
            return null;
        }
    }

    public static abstract class AdditionalProperties {
        @JsonCreator
        public AdditionalProperties jsonCreator() {
            return null;
        }
    }
}

