/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.jboss.weld.environment.util.Collections;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public class WeldResourceLoader
implements ResourceLoader {
    @Override
    public Class<?> classForName(String name) {
        try {
            Class<?> clazz;
            for (Class<?> obj = clazz = WeldResourceLoader.getClassLoader().loadClass(name); obj != null && obj != Object.class; obj = obj.getSuperclass()) {
                obj.getDeclaredConstructors();
                obj.getDeclaredFields();
                obj.getDeclaredMethods();
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException(e);
        }
        catch (LinkageError e) {
            throw new ResourceLoadingException(e);
        }
    }

    @Override
    public URL getResource(String name) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            return tccl.getResource(name);
        }
        return this.getClass().getResource(name);
    }

    @Override
    public Collection<URL> getResources(String name) {
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl != null) {
                return Collections.asList(tccl.getResources(name));
            }
            return Collections.asList(this.getClass().getClassLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException(e);
        }
    }

    @Override
    public void cleanup() {
    }

    public static ClassLoader getClassLoader() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl != null) {
            return tccl;
        }
        return WeldResourceLoader.class.getClassLoader();
    }
}

