/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.quickstarts.cxfcdi;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import io.fabric8.quickstarts.cxfcdi.Customer;
import io.fabric8.quickstarts.cxfcdi.Order;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/customerservice/")
@Api(value="/customerservice", description="Operations about customerservice")
public class CustomerService {
    private static final Logger LOG = LoggerFactory.getLogger(CustomerService.class);
    long currentId = 123L;
    Map<Long, Customer> customers = new HashMap<Long, Customer>();
    Map<Long, Order> orders = new HashMap<Long, Order>();
    private MessageContext jaxrsContext;

    public CustomerService() {
        this.init();
    }

    @GET
    @Path(value="/customers/{id}/")
    @Produces(value={"application/xml"})
    @ApiOperation(value="Find Customer by ID", notes="More notes about this method", response=Customer.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Invalid ID supplied"), @ApiResponse(code=204, message="Customer not found")})
    public Customer getCustomer(@ApiParam(value="ID of Customer to fetch", required=true) @PathParam(value="id") String id) {
        LOG.info("Invoking getCustomer, Customer id is: {}", (Object)id);
        long idNumber = Long.parseLong(id);
        Customer c = this.customers.get(idNumber);
        return c;
    }

    @PUT
    @Path(value="/customers/")
    @Consumes(value={"application/xml", "application/json"})
    @ApiOperation(value="Update an existing Customer")
    @ApiResponses(value={@ApiResponse(code=500, message="Invalid ID supplied"), @ApiResponse(code=204, message="Customer not found")})
    public Response updateCustomer(@ApiParam(value="Customer object that needs to be updated", required=true) Customer customer) {
        Response r;
        LOG.info("Invoking updateCustomer, Customer name is: {}", (Object)customer.getName());
        Customer c = this.customers.get(customer.getId());
        if (c != null) {
            this.customers.put(customer.getId(), customer);
            r = Response.ok().build();
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @POST
    @Path(value="/customers/")
    @Consumes(value={"application/xml", "application/json"})
    @ApiOperation(value="Add a new Customer")
    @ApiResponses(value={@ApiResponse(code=500, message="Invalid ID supplied")})
    public Response addCustomer(@ApiParam(value="Customer object that needs to be updated", required=true) Customer customer) {
        LOG.info("Invoking addCustomer, Customer name is: {}", (Object)customer.getName());
        customer.setId(++this.currentId);
        this.customers.put(customer.getId(), customer);
        if (this.jaxrsContext.getHttpHeaders().getMediaType().getSubtype().equals("json")) {
            return Response.ok().type("application/json").entity((Object)customer).build();
        }
        return Response.ok().type("application/xml").entity((Object)customer).build();
    }

    @DELETE
    @Path(value="/customers/{id}/")
    @ApiOperation(value="Delete Customer")
    @ApiResponses(value={@ApiResponse(code=500, message="Invalid ID supplied"), @ApiResponse(code=204, message="Customer not found")})
    public Response deleteCustomer(@ApiParam(value="ID of Customer to delete", required=true) @PathParam(value="id") String id) {
        Response r;
        LOG.info("Invoking deleteCustomer, Customer id is: {}", (Object)id);
        long idNumber = Long.parseLong(id);
        Customer c = this.customers.get(idNumber);
        if (c != null) {
            r = Response.ok().build();
            this.customers.remove(idNumber);
        } else {
            r = Response.notModified().build();
        }
        return r;
    }

    @Path(value="/orders/{orderId}/")
    public Order getOrder(@PathParam(value="orderId") String orderId) {
        LOG.info("Invoking getOrder, Order id is: {}", (Object)orderId);
        long idNumber = Long.parseLong(orderId);
        Order c = this.orders.get(idNumber);
        return c;
    }

    final void init() {
        Customer c = new Customer();
        c.setName("John");
        c.setId(123L);
        this.customers.put(c.getId(), c);
        Order o = new Order();
        o.setDescription("order 223");
        o.setId(223L);
        this.orders.put(o.getId(), o);
    }

    @Context
    public void setMessageContext(MessageContext messageContext) {
        this.jaxrsContext = messageContext;
    }
}

