/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.testing.jenkins;

import com.offbytwo.jenkins.JenkinsServer;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.JobWithDetails;
import io.fabric8.utils.Asserts;
import io.fabric8.utils.Block;
import io.fabric8.utils.Millis;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsAsserts {
    private static final transient Logger LOG = LoggerFactory.getLogger(JenkinsAsserts.class);
    private static long defaultBuildWaitTime = Millis.minutes((int)2);

    public static JenkinsServer createJenkinsServer(String url) throws URISyntaxException {
        return new JenkinsServer(new URI(url));
    }

    public static JobWithDetails assertJobExists(JenkinsServer jenkins, String jobName) {
        JobWithDetails job = JenkinsAsserts.tryFindJob(jenkins, jobName);
        if (job != null) {
            return job;
        }
        Assertions.fail((String)("No job found called `" + jobName + "` for jenkins at " + jenkins));
        return job;
    }

    public static void assertJobLastBuildIsSuccessful(JenkinsServer jenkins, String jobName) throws Exception {
        JenkinsAsserts.assertJobLastBuildIsSuccessful(defaultBuildWaitTime, jenkins, jobName);
    }

    public static void assertJobLastBuildIsSuccessful(long timeMillis, final JenkinsServer jenkins, final String jobName) throws Exception {
        Asserts.assertWaitFor((long)timeMillis, (Block)new Block(){

            public void invoke() throws Exception {
                JobWithDetails job = JenkinsAsserts.assertJobExists(jenkins, jobName);
                Build lastBuild = job.getLastBuild();
                Assert.assertNotNull((String)("No lastBuild for job `" + jobName + "`"), (Object)lastBuild);
                System.out.println("Last build of `" + jobName + "` at " + lastBuild.getUrl());
                Build lastSuccessfulBuild = job.getLastSuccessfulBuild();
                Assert.assertNotNull((String)("No lastSuccessfulBuild for job `" + jobName + "` at: " + lastBuild.getUrl()), (Object)lastSuccessfulBuild);
                Assert.assertEquals((String)("Last successful build number was not the last build number: " + lastBuild.getUrl()), (long)lastBuild.getNumber(), (long)lastSuccessfulBuild.getNumber());
                System.out.println("Successful build of `" + jobName + "` at " + lastSuccessfulBuild.getUrl());
            }
        });
    }

    public static Build assertJobHasBuild(JenkinsServer jenkins, String jobName) {
        JobWithDetails job = JenkinsAsserts.assertJobExists(jenkins, jobName);
        Build lastBuild = job.getLastBuild();
        Assert.assertNotNull((String)("No lastBuild for job `" + jobName + "`"), (Object)lastBuild);
        return lastBuild;
    }

    public static void assertCreateJenkinsJob(JenkinsServer jenkinsServer, String xml, String jobName) {
        try {
            jenkinsServer.createJob(jobName, xml);
        }
        catch (IOException e) {
            Assertions.fail((String)("Failed to create Jenkins job " + jobName + " for XML `" + xml + "`. " + e), (Throwable)e);
        }
    }

    public static String assertJobXml(JenkinsServer jenkinsServer, String jobName) {
        try {
            return jenkinsServer.getJobXml(jobName);
        }
        catch (IOException e) {
            Assertions.fail((String)("Failed to find XML for Jenkins job " + jobName + ". " + e), (Throwable)e);
            return null;
        }
    }

    public static String createJenkinsPipelineJobXml(String jenkinsfile) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><org.jenkinsci.plugins.workflow.job.WorkflowJob plugin=\"workflow-job@1.15\">\n  <keepDependencies>false</keepDependencies>\n  <properties/>\n  <definition class=\"org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition\" plugin=\"workflow-cps@1.15\">\n    <script>" + jenkinsfile + "</script>\n" + "    <sandbox>false</sandbox>\n" + "  </definition>\n" + "  <triggers/>\n" + "</org.jenkinsci.plugins.workflow.job.WorkflowJob>";
    }

    protected static JobWithDetails tryFindJob(JenkinsServer jenkins, String jobName) {
        for (int i = 0; i < 15; ++i) {
            try {
                return jenkins.getJob(jobName);
            }
            catch (IOException e) {
                LOG.info("Caught: " + e, (Throwable)e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                continue;
            }
        }
        return null;
    }
}

