/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.maven.plugin;

import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.FileJavaGenerator;
import io.fabric8.java.generator.URLJavaGenerator;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class JavaGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="fabric8.java-generator.source")
    File source;
    @Parameter(property="fabric8.java-generator.urls", required=false)
    String[] urls;
    @Parameter(property="fabric8.java-generator.download-target", defaultValue="${basedir}/target/manifests")
    File downloadTarget;
    @Parameter(property="fabric8.java-generator.target", defaultValue="${basedir}/target/generated-sources/java")
    File target;
    @Parameter(property="fabric8.java-generator.enum-uppercase", required=false)
    Boolean enumUppercase = null;
    @Parameter(property="fabric8.java-generator.extra-annotations", required=false)
    Boolean extraAnnotations = null;
    @Parameter(property="fabric8.java-generator.generated-annotations", required=false)
    Boolean generatedAnnotations = null;
    @Parameter(property="fabric8.java-generator.always-preserve-unknown", required=false)
    Boolean alwaysPreserveUnknown = null;
    @Parameter(property="fabric8.java-generator.package-overrides", required=false)
    Map<String, String> packageOverrides = null;
    @Parameter(property="fabric8.java-generator.files-suffixes", required=false)
    List<String> filesSuffixes = null;
    @Parameter(property="fabric8.java-generator.datetime-serialization-format", required=false)
    String datetimeSerializationFormat = null;
    @Parameter(property="fabric8.java-generator.datetime-deserialization-format", required=false)
    String datetimeDeserializationFormat = null;

    public void execute() throws MojoExecutionException {
        Config config = Config.builder().uppercaseEnums(this.enumUppercase).objectExtraAnnotations(this.extraAnnotations).generatedAnnotations(this.generatedAnnotations).alwaysPreserveUnknown(this.alwaysPreserveUnknown).packageOverrides(this.packageOverrides).filesSuffixes(this.filesSuffixes).serDatetimeFormat(this.datetimeSerializationFormat).deserDatetimeFormat(this.datetimeDeserializationFormat).build();
        ArrayList<Object> runners = new ArrayList<Object>();
        if (this.urls != null && this.urls.length > 0) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (String url : this.urls) {
                try {
                    urlList.add(new URL(url));
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("URL '" + url + "' is not valid", (Exception)e);
                }
            }
            if (!this.downloadTarget.isDirectory()) {
                this.downloadTarget.mkdirs();
            }
            runners.add(new URLJavaGenerator(config, urlList, this.downloadTarget));
        }
        if (this.source != null) {
            runners.add(new FileJavaGenerator(config, this.source));
        }
        if (runners.isEmpty()) {
            throw new MojoExecutionException("No source or urls specified");
        }
        runners.forEach(r -> r.run(this.target));
        this.project.addCompileSourceRoot(this.target.getAbsolutePath());
    }
}

