/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.exceptions.JavaGeneratorException;
import io.fabric8.java.generator.nodes.GeneratorResult;
import io.fabric8.java.generator.nodes.JArray;
import io.fabric8.java.generator.nodes.JArrayNameAndType;
import io.fabric8.java.generator.nodes.JEnum;
import io.fabric8.java.generator.nodes.JEnumNameAndType;
import io.fabric8.java.generator.nodes.JMap;
import io.fabric8.java.generator.nodes.JMapNameAndType;
import io.fabric8.java.generator.nodes.JObject;
import io.fabric8.java.generator.nodes.JObjectNameAndType;
import io.fabric8.java.generator.nodes.JPrimitive;
import io.fabric8.java.generator.nodes.JPrimitiveNameAndType;
import io.fabric8.java.generator.nodes.JavaNameAndType;
import io.fabric8.java.generator.nodes.Keywords;
import io.fabric8.java.generator.nodes.ValidationProperties;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import java.util.Locale;
import java.util.function.Function;

public abstract class AbstractJSONSchema2Pojo {
    static final String BOOLEAN_CRD_TYPE = "boolean";
    static final String INTEGER_CRD_TYPE = "integer";
    static final String INT32_CRD_TYPE = "int32";
    static final String INT64_CRD_TYPE = "int64";
    static final String NUMBER_CRD_TYPE = "number";
    static final String FLOAT_CRD_TYPE = "float";
    static final String DOUBLE_CRD_TYPE = "double";
    static final String STRING_CRD_TYPE = "string";
    static final String OBJECT_CRD_TYPE = "object";
    static final String ARRAY_CRD_TYPE = "array";
    public static final AnnotationExpr GENERATED_ANNOTATION = new SingleMemberAnnotationExpr(new Name("javax.annotation.processing.Generated"), (Expression)new StringLiteralExpr("io.fabric8.java.generator.CRGeneratorRunner"));
    protected final String description;
    protected final Config config;
    protected final boolean isNullable;
    protected final JsonNode defaultValue;
    protected Double maximum;
    protected Double minimum;
    protected String pattern;

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public String getPattern() {
        return this.pattern;
    }

    public abstract String getType();

    public abstract GeneratorResult generateJava();

    public static String packageName(String str) {
        String pkg = str.toLowerCase(Locale.ROOT);
        if (pkg.equals(str)) {
            pkg = "_" + pkg;
        }
        return pkg;
    }

    public String getDescription() {
        return this.description;
    }

    protected JsonNode getDefaultValue() {
        return this.defaultValue;
    }

    protected String getClassType() {
        return this.getType();
    }

    protected AbstractJSONSchema2Pojo(Config config, String description, boolean isNullable, JsonNode defaultValue, ValidationProperties validationProperties) {
        this.config = config;
        this.description = description;
        this.isNullable = isNullable;
        this.defaultValue = defaultValue;
        if (validationProperties != null) {
            this.maximum = validationProperties.getMaximum();
            this.minimum = validationProperties.getMinimum();
            this.pattern = validationProperties.getPattern();
        }
    }

    public static String sanitizeString(String str) {
        str = str.trim();
        String sanitized = "";
        sanitized = Keywords.JAVA_KEYWORDS.contains(str) || !str.isEmpty() && !Character.isJavaIdentifierStart(str.charAt(0)) ? "_" + str : str;
        if (sanitized.startsWith("-")) {
            sanitized = sanitized.replaceFirst("-", "minus");
        }
        int index = sanitized.indexOf(45);
        while (index != -1) {
            int next = Math.min(index + 2, sanitized.length());
            sanitized = sanitized.substring(0, index) + sanitized.substring(index + 1, next).toUpperCase() + sanitized.substring(next);
            index = sanitized.indexOf(45);
        }
        return sanitized;
    }

    public static AbstractJSONSchema2Pojo fromJsonSchema(String key, JSONSchemaProps prop, String parentPkg, String classPrefix, String classSuffix, Config config) {
        Function<JavaNameAndType, AbstractJSONSchema2Pojo> fromJsonSchema = javaNameAndType -> AbstractJSONSchema2Pojo.fromJsonSchema(key, javaNameAndType, prop, parentPkg, classPrefix, classSuffix, config);
        String type = prop.getType();
        if (Boolean.TRUE.equals(prop.getXKubernetesIntOrString())) {
            return fromJsonSchema.apply(JPrimitiveNameAndType.INT_OR_STRING);
        }
        if (type == null && Boolean.TRUE.equals(prop.getXKubernetesPreserveUnknownFields())) {
            return fromJsonSchema.apply(JPrimitiveNameAndType.ANY_TYPE);
        }
        if (prop.getEnum() != null && prop.getEnum().size() > 0) {
            return fromJsonSchema.apply(new JEnumNameAndType(key));
        }
        if (type == null) {
            throw new IllegalArgumentException("Type for key:" + key + " is null");
        }
        switch (type) {
            case "boolean": {
                return fromJsonSchema.apply(JPrimitiveNameAndType.BOOL);
            }
            case "integer": {
                String intFormat = prop.getFormat();
                if (intFormat == null) {
                    intFormat = INT64_CRD_TYPE;
                }
                switch (intFormat) {
                    case "int32": {
                        return fromJsonSchema.apply(JPrimitiveNameAndType.INTEGER);
                    }
                }
                return fromJsonSchema.apply(JPrimitiveNameAndType.LONG);
            }
            case "number": {
                String numberFormat = prop.getFormat();
                if (numberFormat == null) {
                    numberFormat = DOUBLE_CRD_TYPE;
                }
                switch (numberFormat) {
                    case "float": {
                        return fromJsonSchema.apply(JPrimitiveNameAndType.FLOAT);
                    }
                }
                return fromJsonSchema.apply(JPrimitiveNameAndType.DOUBLE);
            }
            case "string": {
                return fromJsonSchema.apply(JPrimitiveNameAndType.STRING);
            }
            case "object": {
                if (prop.getAdditionalProperties() != null && prop.getAdditionalProperties().getSchema() != null) {
                    return fromJsonSchema.apply(new JMapNameAndType(key));
                }
                return fromJsonSchema.apply(new JObjectNameAndType(key));
            }
            case "array": {
                return fromJsonSchema.apply(new JArrayNameAndType(key));
            }
        }
        throw new JavaGeneratorException("Unmanaged type " + prop.getType());
    }

    private static AbstractJSONSchema2Pojo fromJsonSchema(String key, JavaNameAndType nt, JSONSchemaProps prop, String parentPkg, String classPrefix, String classSuffix, Config config) {
        boolean isNullable = Boolean.TRUE.equals(prop.getNullable());
        switch (nt.getType()) {
            case PRIMITIVE: {
                return new JPrimitive(nt.getName(), config, prop.getDescription(), isNullable, prop.getDefault(), ValidationProperties.Builder.getInstance().withMaximum(prop.getMaximum()).withMinimum(prop.getMinimum()).withPattern(prop.getPattern()).build());
            }
            case ARRAY: {
                return new JArray(AbstractJSONSchema2Pojo.fromJsonSchema(key, prop.getItems().getSchema(), parentPkg, classPrefix, classSuffix, config), config, prop.getDescription(), isNullable, prop.getDefault());
            }
            case MAP: {
                return new JMap(AbstractJSONSchema2Pojo.fromJsonSchema(key, prop.getAdditionalProperties().getSchema(), parentPkg, classPrefix, classSuffix, config), config, prop.getDescription(), isNullable, prop.getDefault());
            }
            case OBJECT: {
                boolean preserveUnknownFields = Boolean.TRUE.equals(prop.getXKubernetesPreserveUnknownFields());
                return new JObject(parentPkg, key, prop.getProperties(), prop.getRequired(), preserveUnknownFields, classPrefix, classSuffix, config, prop.getDescription(), isNullable, prop.getDefault());
            }
            case ENUM: {
                return new JEnum(key, prop.getEnum(), config, prop.getDescription(), isNullable, prop.getDefault());
            }
        }
        throw new JavaGeneratorException("Unreachable " + (Object)((Object)nt.getType()));
    }
}

