/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator;

import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.FileJavaGenerator;
import io.fabric8.java.generator.JavaGenerator;
import io.fabric8.java.generator.exceptions.JavaGeneratorException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLJavaGenerator
implements JavaGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLJavaGenerator.class);
    private final Collection<URL> urls;
    private final File downloadDirectory;
    private final FileJavaGenerator delegate;

    public URLJavaGenerator(Config config, Collection<URL> urls, File downloadDirectory) {
        this.urls = urls;
        this.downloadDirectory = downloadDirectory;
        this.delegate = new FileJavaGenerator(config, downloadDirectory);
    }

    @Override
    public void run(File outputDirectory) {
        if (this.urls == null || this.urls.isEmpty()) {
            throw new JavaGeneratorException("No URLs provided");
        }
        if (this.downloadDirectory == null) {
            throw new JavaGeneratorException("Download directory is required");
        }
        if (!this.downloadDirectory.isDirectory()) {
            throw new JavaGeneratorException("Download directory " + this.downloadDirectory.getAbsolutePath() + " is not a valid directory");
        }
        if (!this.downloadDirectory.exists() && !this.downloadDirectory.mkdirs()) {
            throw new JavaGeneratorException("Unable to create download directory " + this.downloadDirectory.getAbsolutePath());
        }
        LOGGER.info("Downloading CRDs from URLs: {}", this.urls);
        this.urls.forEach(this::downloadCRD);
        LOGGER.info("Generating Java classes from downloaded CRDs");
        this.delegate.run(outputDirectory);
    }

    private void downloadCRD(URL url) {
        File finalDestination = new File(this.downloadDirectory, new File(url.getFile()).getName());
        if (finalDestination.exists()) {
            LOGGER.warn("Skipping download of {} because it already exists at {}", (Object)url, (Object)finalDestination);
            return;
        }
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(url.openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(finalDestination);){
            fileOutputStream.getChannel().transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            throw new JavaGeneratorException("Error downloading CRD from URL: " + url, e);
        }
    }
}

