/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.nodes.AbstractJSONSchema2Pojo;
import io.fabric8.java.generator.nodes.GeneratorResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public class JEnum
extends AbstractJSONSchema2Pojo {
    private static final String VALUE = "value";
    private final String type;
    private final String underlyingType;
    private final Set<String> values;

    public JEnum(String type, String underlyingType, List<JsonNode> values, Config config, String description, boolean isNullable, JsonNode defaultValue) {
        super(config, description, isNullable, defaultValue, null);
        this.type = AbstractJSONSchema2Pojo.sanitizeString(type.substring(0, 1).toUpperCase() + type.substring(1));
        this.underlyingType = underlyingType;
        this.values = values.stream().map(JsonNode::asText).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public String getType() {
        return this.type;
    }

    private String sanitizeEnumEntry(String str) {
        String ret = str;
        if (this.config.isUppercaseEnums()) {
            ret = ret.toUpperCase(Locale.ROOT);
        }
        if (ret.isEmpty()) {
            return "_EMPTY";
        }
        return ret.replaceAll("[\\s|\\./]", "_");
    }

    @Override
    public GeneratorResult generateJava() {
        CompilationUnit cu = new CompilationUnit();
        EnumDeclaration en = cu.addEnum(this.type);
        en.addField(this.underlyingType, VALUE, new Modifier.Keyword[0]);
        ConstructorDeclaration cd = en.addConstructor(new Modifier.Keyword[0]);
        cd.addParameter(this.underlyingType, VALUE);
        cd.createBody();
        cd.setBody((BlockStmt)new BlockStmt().addStatement((Expression)new AssignExpr((Expression)new NameExpr("this.value"), (Expression)new NameExpr(VALUE), AssignExpr.Operator.ASSIGN)));
        MethodDeclaration getValue = en.addMethod("getValue", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
        getValue.setType(this.underlyingType);
        getValue.setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt(VALUE)));
        getValue.addAnnotation("com.fasterxml.jackson.annotation.JsonValue");
        HashSet<String> constantNames = new HashSet<String>(this.values.size());
        for (String k : this.values) {
            StringBuilder constantNameBuilder = new StringBuilder();
            try {
                Integer.valueOf(k);
                constantNameBuilder.append("V_" + this.sanitizeEnumEntry(JEnum.sanitizeString(k)));
            }
            catch (Exception e) {
                constantNameBuilder.append(this.sanitizeEnumEntry(JEnum.sanitizeString(k)));
            }
            while (constantNames.contains(constantNameBuilder.toString())) {
                String tmp = constantNameBuilder.toString();
                constantNameBuilder.setLength(0);
                constantNameBuilder.append("_" + tmp);
            }
            String constantName = constantNameBuilder.toString();
            constantNames.add(constantName);
            String originalName = AbstractJSONSchema2Pojo.escapeQuotes(k);
            StringLiteralExpr valueArgument = new StringLiteralExpr(originalName);
            if (!this.underlyingType.equals("java.lang.String")) {
                valueArgument = this.underlyingType.equals("java.lang.Long") && !originalName.endsWith("L") ? new IntegerLiteralExpr(originalName + "L") : new IntegerLiteralExpr(originalName);
            }
            EnumConstantDeclaration decl = new EnumConstantDeclaration();
            decl.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonProperty"), (Expression)new StringLiteralExpr(originalName)));
            decl.setName(constantName);
            decl.addArgument((Expression)valueArgument);
            en.addEntry(decl);
        }
        return new GeneratorResult(new ArrayList<GeneratorResult.ClassResult>(), Collections.singletonList(new GeneratorResult.ClassResult(this.type, cu)));
    }
}

