/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.utils.StringEscapeUtils;
import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.exceptions.JavaGeneratorException;
import io.fabric8.java.generator.nodes.AbstractJSONSchema2Pojo;
import io.fabric8.java.generator.nodes.GeneratorResult;
import io.fabric8.java.generator.nodes.JObjectExtraAnnotations;
import io.fabric8.java.generator.nodes.JPrimitiveNameAndType;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JObject
extends AbstractJSONSchema2Pojo
implements JObjectExtraAnnotations {
    public static final String DEPRECATED_FIELD_MARKER = "deprecated";
    private final String type;
    private final String className;
    private final String pkg;
    private final Map<String, AbstractJSONSchema2Pojo> fields;
    private final Set<String> required;
    private final Set<String> deprecated = new HashSet<String>();
    private final boolean preserveUnknownFields;

    public JObject(String pkg, String type, Map<String, JSONSchemaProps> fields, List<String> required, boolean preserveUnknownFields, Config config, String description, boolean isNullable, JsonNode defaultValue) {
        super(config, description, isNullable, defaultValue, null);
        this.required = new HashSet<String>(Optional.ofNullable(required).orElse(Collections.emptyList()));
        this.fields = new HashMap<String, AbstractJSONSchema2Pojo>();
        this.preserveUnknownFields = preserveUnknownFields;
        this.pkg = pkg == null ? "" : pkg.trim();
        String pkgPrefix = this.pkg.isEmpty() ? this.pkg : this.pkg + ".";
        String upperCasedClassName = type.substring(0, 1).toUpperCase() + type.substring(1);
        this.className = AbstractJSONSchema2Pojo.sanitizeString(upperCasedClassName);
        this.type = pkgPrefix + this.className;
        if (fields != null) {
            String nextPackagePath = pkgPrefix + AbstractJSONSchema2Pojo.packageName(this.className);
            Map<String, Map<String, JSONSchemaProps>> groupedFieldDefinitions = fields.entrySet().stream().collect(Collectors.groupingBy(f -> AbstractJSONSchema2Pojo.sanitizeString((String)f.getKey()), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            for (Map.Entry<String, JSONSchemaProps> field : fields.entrySet()) {
                String fieldKey = field.getKey();
                Map<String, JSONSchemaProps> fieldDuplicatesDefinition = groupedFieldDefinitions.get(AbstractJSONSchema2Pojo.sanitizeString(field.getKey()));
                int duplicatesCount = fieldDuplicatesDefinition.size();
                if (duplicatesCount > 1) {
                    if (duplicatesCount > 2) {
                        throw new JavaGeneratorException(String.format("The %s field has %d duplicates, which is not a supported configuration", field.getKey(), duplicatesCount - 1));
                    }
                    boolean deprecatedDuplicatesExist = fieldDuplicatesDefinition.entrySet().stream().anyMatch(d -> ((JSONSchemaProps)d.getValue()).getDescription().trim().toLowerCase().startsWith(DEPRECATED_FIELD_MARKER));
                    if (!deprecatedDuplicatesExist) {
                        throw new JavaGeneratorException(String.format("The %s field has a duplicate, but it's not marked as deprecated, which is not a supported configuration", field.getKey()));
                    }
                    if (field.getValue().getDescription().trim().toLowerCase().startsWith(DEPRECATED_FIELD_MARKER)) {
                        fieldKey = fieldKey + "-deprecated";
                        this.deprecated.add(fieldKey);
                    }
                }
                this.fields.put(fieldKey, AbstractJSONSchema2Pojo.fromJsonSchema(fieldKey, field.getValue(), nextPackagePath, config));
            }
        }
    }

    @Override
    public String getType() {
        return this.config.getExistingJavaTypes().getOrDefault(this.type, this.type);
    }

    private String getSortedFieldsAsParam(Set<String> list) {
        List sortedFields = list.stream().map(AbstractJSONSchema2Pojo::escapeQuotes).sorted().collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        while (!sortedFields.isEmpty()) {
            sb.append("\"" + (String)sortedFields.remove(0) + "\"");
            if (sortedFields.isEmpty()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public GeneratorResult generateJava() {
        if (this.config.getExistingJavaTypes().containsKey(this.type)) {
            return new GeneratorResult(Collections.emptyList());
        }
        CompilationUnit cu = new CompilationUnit();
        if (!this.pkg.isEmpty()) {
            cu.setPackageDeclaration(new PackageDeclaration(new Name(this.pkg)));
        }
        ClassOrInterfaceDeclaration clz = cu.addClass(this.className);
        clz.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonInclude"), (Expression)new NameExpr("com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL")));
        clz.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonPropertyOrder"), (Expression)new NameExpr(this.getSortedFieldsAsParam(this.fields.keySet()))));
        clz.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.databind.annotation.JsonDeserialize"), (Expression)new NameExpr("using = com.fasterxml.jackson.databind.JsonDeserializer.None.class")));
        if (this.config.isGeneratedAnnotations()) {
            clz.addAnnotation(JObject.newGeneratedAnnotation());
        }
        if (this.config.isObjectExtraAnnotations()) {
            this.addExtraAnnotations(clz);
        }
        clz.addImplementedType(new ClassOrInterfaceType(null, "io.fabric8.kubernetes.api.model.KubernetesResource"));
        ArrayList<GeneratorResult.ClassResult> buffer = new ArrayList<GeneratorResult.ClassResult>(this.fields.size() + 1);
        List sortedKeys = this.fields.keySet().stream().sorted().collect(Collectors.toList());
        for (String k : sortedKeys) {
            boolean isEnum;
            AbstractJSONSchema2Pojo prop = this.fields.get(k);
            boolean isRequired = this.required.contains(k);
            boolean isDeprecated = this.deprecated.contains(k);
            GeneratorResult gr = prop.generateJava();
            boolean bl = isEnum = !gr.getInnerClasses().isEmpty();
            if (isEnum) {
                for (GeneratorResult.ClassResult enumCR : gr.getInnerClasses()) {
                    Optional<EnumDeclaration> ed = enumCR.getEnumByName(enumCR.getName());
                    if (!ed.isPresent()) continue;
                    clz.addMember((BodyDeclaration)ed.get());
                }
            }
            buffer.addAll(gr.getTopLevelClasses());
            String originalFieldName = AbstractJSONSchema2Pojo.escapeQuotes(k);
            String fieldName = AbstractJSONSchema2Pojo.sanitizeString(k);
            String fieldType = prop.getType();
            try {
                FieldDeclaration objField = clz.addField((Type)JObject.toClassOrInterfaceType(fieldType), fieldName, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
                objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonProperty"), (Expression)new StringLiteralExpr(originalFieldName)));
                MethodDeclaration fieldGetter = objField.createGetter();
                MethodDeclaration fieldSetter = objField.createSetter();
                if (prop.getClassType().equals("java.time.ZonedDateTime")) {
                    fieldGetter.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonFormat"), (Expression)new NameExpr("pattern = \"" + this.config.getSerDatetimeFormat() + "\"")));
                    fieldSetter.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonFormat"), (Expression)new NameExpr("pattern = \"" + this.config.getDeserDatetimeFormat() + "\"")));
                }
                if (isRequired) {
                    objField.addAnnotation("io.fabric8.generator.annotation.Required");
                }
                if (prop.getMaximum() != null) {
                    objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("io.fabric8.generator.annotation.Max"), (Expression)new DoubleLiteralExpr(prop.getMaximum().doubleValue())));
                }
                if (prop.getMinimum() != null) {
                    objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("io.fabric8.generator.annotation.Min"), (Expression)new DoubleLiteralExpr(prop.getMinimum().doubleValue())));
                }
                if (prop.getPattern() != null) {
                    objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("io.fabric8.generator.annotation.Pattern"), (Expression)new StringLiteralExpr(StringEscapeUtils.escapeJava((String)prop.getPattern()))));
                }
                if (Utils.isNotNullOrEmpty((String)prop.getDescription())) {
                    objField.setJavadocComment(prop.getDescription().replace("*/", "&#042;&#047;"));
                    objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonPropertyDescription"), (Expression)new StringLiteralExpr(StringEscapeUtils.escapeJava((String)prop.getDescription()))));
                }
                if (!prop.isNullable) {
                    objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonSetter"), (Expression)new NameExpr("nulls = com.fasterxml.jackson.annotation.Nulls.SKIP")));
                } else {
                    objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonSetter"), (Expression)new NameExpr("nulls = com.fasterxml.jackson.annotation.Nulls.SET")));
                    objField.addAnnotation((AnnotationExpr)new NormalAnnotationExpr(new Name("io.fabric8.generator.annotation.Nullable"), new NodeList()));
                }
                if (prop.getDefaultValue() != null) {
                    Expression primitiveDefault;
                    Expression expression = primitiveDefault = isEnum ? null : this.generatePrimitiveDefaultInitializerExpression(prop);
                    if (primitiveDefault != null) {
                        objField.getVariable(0).setInitializer(primitiveDefault);
                    } else {
                        objField.getVariable(0).setInitializer((Expression)new NameExpr("io.fabric8.kubernetes.client.utils.Serialization.unmarshal(\"" + StringEscapeUtils.escapeJava((String)Serialization.asJson((Object)prop.getDefaultValue())) + "\", " + prop.getClassType() + ".class)"));
                    }
                }
                if (!isDeprecated) continue;
                objField.addAnnotation("java.lang.Deprecated");
            }
            catch (Exception cause) {
                throw new JavaGeneratorException("Error generating field " + fieldName + " with type " + prop.getType(), cause);
            }
        }
        if (this.preserveUnknownFields || this.config.isAlwaysPreserveUnknown()) {
            ClassOrInterfaceType mapType = (ClassOrInterfaceType)((ClassOrInterfaceType)new ClassOrInterfaceType().setName("java.util.Map")).setTypeArguments(new Type[]{(Type)new ClassOrInterfaceType().setName("String"), (Type)new ClassOrInterfaceType().setName("Object")});
            FieldDeclaration objField = clz.addField((Type)mapType, "additionalProperties", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
            objField.setVariables(new NodeList((Node[])new VariableDeclarator[]{((VariableDeclarator)new VariableDeclarator().setName("additionalProperties")).setType((Type)mapType).setInitializer("new java.util.HashMap<>()")}));
            objField.addAnnotation((AnnotationExpr)new NormalAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonIgnore"), new NodeList()));
            objField.createGetter().addAnnotation((AnnotationExpr)new NormalAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonAnyGetter"), new NodeList()));
            objField.createSetter().addAnnotation((AnnotationExpr)new NormalAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonAnySetter"), new NodeList()));
            MethodDeclaration additionalSetter = clz.addMethod("setAdditionalProperty", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC});
            additionalSetter.addAnnotation((AnnotationExpr)new NormalAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonAnySetter"), new NodeList()));
            additionalSetter.addParameter((Type)new ClassOrInterfaceType(null, "java.lang.String"), "key");
            additionalSetter.addParameter((Type)new ClassOrInterfaceType(null, "java.lang.Object"), "value");
            additionalSetter.setBody((BlockStmt)new BlockStmt().addStatement((Expression)new NameExpr("this.additionalProperties.put(key, value)")));
        }
        buffer.add(new GeneratorResult.ClassResult(this.className, cu));
        return new GeneratorResult(buffer);
    }

    private Expression generatePrimitiveDefaultInitializerExpression(AbstractJSONSchema2Pojo prop) {
        if (prop.getDefaultValue().isValueNode()) {
            String value = prop.getDefaultValue().toString();
            if (prop.getClassType().equals("Long") && prop.getDefaultValue().canConvertToLong()) {
                return new LongLiteralExpr(value + "L");
            }
            if (prop.getClassType().equals("Float") && prop.getDefaultValue().isFloatingPointNumber()) {
                return new DoubleLiteralExpr(value + "f");
            }
            if (prop.getClassType().equals("Boolean") && prop.getDefaultValue().isBoolean()) {
                return new BooleanLiteralExpr(prop.getDefaultValue().booleanValue());
            }
            if (prop.getClassType().equals("java.time.ZonedDateTime") && prop.getDefaultValue().isTextual()) {
                return new NameExpr("java.time.ZonedDateTime.parse(" + prop.getDefaultValue() + ", java.time.format.DateTimeFormatter.ofPattern(\"" + this.config.getDeserDatetimeFormat() + "\"))");
            }
            if (prop.getClassType().equals(JPrimitiveNameAndType.INT_OR_STRING.getName())) {
                return prop.getDefaultValue().isInt() ? new NameExpr("new " + JPrimitiveNameAndType.INT_OR_STRING.getName() + "(" + prop.getDefaultValue().intValue() + ")") : new NameExpr("new " + JPrimitiveNameAndType.INT_OR_STRING.getName() + "(\"" + StringEscapeUtils.escapeJava((String)prop.getDefaultValue().asText()) + "\")");
            }
            return new NameExpr(value);
        }
        return null;
    }

    static ClassOrInterfaceType toClassOrInterfaceType(String className) {
        String withoutDollars = className.replace("$", ".");
        return withoutDollars.indexOf(60) >= 0 ? StaticJavaParser.parseClassOrInterfaceType((String)withoutDollars) : new ClassOrInterfaceType(null, withoutDollars);
    }
}

