/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.utils.StringEscapeUtils;
import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.exceptions.JavaGeneratorException;
import io.fabric8.java.generator.nodes.AbstractJSONSchema2Pojo;
import io.fabric8.java.generator.nodes.GeneratorResult;
import io.fabric8.java.generator.nodes.JObjectExtraAnnotations;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JObject
extends AbstractJSONSchema2Pojo
implements JObjectExtraAnnotations {
    private static final Set<String> IGNORED_FIELDS = new HashSet<String>();
    private final String type;
    private final String className;
    private final String pkg;
    private final Map<String, AbstractJSONSchema2Pojo> fields;
    private final Set<String> required;
    private final boolean preserveUnknownFields;

    public JObject(String pkg, String type, Map<String, JSONSchemaProps> fields, List<String> required, boolean preserveUnknownFields, String classPrefix, String classSuffix, Config config, String description, boolean isNullable, JsonNode defaultValue) {
        super(config, description, isNullable, defaultValue);
        this.required = new HashSet<String>(Optional.ofNullable(required).orElse(Collections.emptyList()));
        this.fields = new HashMap<String, AbstractJSONSchema2Pojo>();
        this.preserveUnknownFields = preserveUnknownFields;
        this.pkg = pkg == null ? "" : pkg.trim();
        String pkgPrefix = this.pkg.isEmpty() ? this.pkg : this.pkg + ".";
        String clazzPrefix = classPrefix == null ? "" : classPrefix.trim();
        String clazzSuffix = classSuffix == null || type.toLowerCase(Locale.ROOT).endsWith(classSuffix.toLowerCase(Locale.ROOT)) ? "" : classSuffix.trim();
        String upperCasedClassName = type.substring(0, 1).toUpperCase() + type.substring(1);
        this.className = AbstractJSONSchema2Pojo.sanitizeString(clazzPrefix + upperCasedClassName + clazzSuffix);
        this.type = pkgPrefix + this.className;
        if (fields != null) {
            String nextPackagePath = null;
            switch (config.getCodeStructure()) {
                case FLAT: {
                    nextPackagePath = this.pkg;
                    break;
                }
                case PACKAGE_NESTED: {
                    nextPackagePath = pkgPrefix + AbstractJSONSchema2Pojo.packageName(this.className);
                }
            }
            for (Map.Entry<String, JSONSchemaProps> field : fields.entrySet()) {
                if (IGNORED_FIELDS.contains(field.getKey())) continue;
                String nextPrefix = config.getPrefixStrategy() == Config.Prefix.ALWAYS ? classPrefix : "";
                String nextSuffix = config.getSuffixStrategy() == Config.Suffix.ALWAYS ? classSuffix : "";
                this.fields.put(field.getKey(), AbstractJSONSchema2Pojo.fromJsonSchema(field.getKey(), field.getValue(), nextPackagePath, nextPrefix, nextSuffix, config));
            }
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    private String getSortedFieldsAsParam(Set<String> list) {
        List sortedFields = list.stream().sorted().collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        while (!sortedFields.isEmpty()) {
            sb.append("\"" + (String)sortedFields.remove(0) + "\"");
            if (sortedFields.isEmpty()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public GeneratorResult generateJava() {
        CompilationUnit cu = new CompilationUnit();
        if (!this.pkg.isEmpty()) {
            cu.setPackageDeclaration(this.pkg);
        }
        ClassOrInterfaceDeclaration clz = cu.addClass(this.className);
        clz.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonInclude"), (Expression)new NameExpr("com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL")));
        clz.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonPropertyOrder"), (Expression)new NameExpr(this.getSortedFieldsAsParam(this.fields.keySet()))));
        clz.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.databind.annotation.JsonDeserialize"), (Expression)new NameExpr("using = com.fasterxml.jackson.databind.JsonDeserializer.None.class")));
        if (this.config.isObjectExtraAnnotations()) {
            this.addExtraAnnotations(clz);
        }
        clz.addImplementedType("io.fabric8.kubernetes.api.model.KubernetesResource");
        ArrayList<GeneratorResult.ClassResult> buffer = new ArrayList<GeneratorResult.ClassResult>(this.fields.size() + 1);
        List sortedKeys = this.fields.keySet().stream().sorted().collect(Collectors.toList());
        for (String k : sortedKeys) {
            AbstractJSONSchema2Pojo prop = this.fields.get(k);
            boolean isRequired = this.required.contains(k);
            GeneratorResult gr = prop.generateJava();
            if (!gr.getInnerClasses().isEmpty()) {
                for (GeneratorResult.ClassResult enumCR : gr.getInnerClasses()) {
                    Optional ed = enumCR.getCompilationUnit().getEnumByName(enumCR.getName());
                    if (!ed.isPresent()) continue;
                    clz.addMember((BodyDeclaration)ed.get());
                }
            }
            buffer.addAll(gr.getTopLevelClasses());
            String originalFieldName = k;
            String fieldName = AbstractJSONSchema2Pojo.sanitizeString(k);
            String fieldType = prop.getType();
            try {
                FieldDeclaration objField = clz.addField(fieldType, fieldName, new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
                objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonProperty"), (Expression)new StringLiteralExpr(originalFieldName)));
                if (isRequired) {
                    objField.addAnnotation("javax.validation.constraints.NotNull");
                }
                objField.createGetter();
                objField.createSetter();
                if (Utils.isNotNullOrEmpty((String)prop.getDescription())) {
                    objField.setJavadocComment(prop.getDescription());
                    objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonPropertyDescription"), (Expression)new StringLiteralExpr(prop.getDescription().replace("\"", "\\\""))));
                }
                if (!prop.isNullable) {
                    objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonSetter"), (Expression)new NameExpr("nulls = com.fasterxml.jackson.annotation.Nulls.SKIP")));
                } else {
                    objField.addAnnotation((AnnotationExpr)new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonSetter"), (Expression)new NameExpr("nulls = com.fasterxml.jackson.annotation.Nulls.SET")));
                }
                if (prop.getDefaultValue() == null) continue;
                objField.getVariable(0).setInitializer(this.generateDefaultInitializerExpression(prop));
            }
            catch (Exception cause) {
                throw new JavaGeneratorException("Error generating field " + fieldName + " with type " + prop.getType(), cause);
            }
        }
        if (this.preserveUnknownFields || this.config.isAlwaysPreserveUnknownFields()) {
            ClassOrInterfaceType mapType = (ClassOrInterfaceType)((ClassOrInterfaceType)new ClassOrInterfaceType().setName("java.util.Map")).setTypeArguments(new Type[]{(Type)new ClassOrInterfaceType().setName("String"), (Type)new ClassOrInterfaceType().setName("Object")});
            FieldDeclaration objField = clz.addField((Type)mapType, "additionalProperties", new Modifier.Keyword[]{Modifier.Keyword.PRIVATE});
            objField.setVariables(new NodeList((Node[])new VariableDeclarator[]{((VariableDeclarator)new VariableDeclarator().setName("additionalProperties")).setType((Type)mapType).setInitializer("new java.util.HashMap<>()")}));
            objField.addAnnotation("com.fasterxml.jackson.annotation.JsonIgnore");
            objField.createGetter().addAnnotation("com.fasterxml.jackson.annotation.JsonAnyGetter");
            objField.createSetter().addAnnotation("com.fasterxml.jackson.annotation.JsonAnySetter");
        }
        buffer.add(new GeneratorResult.ClassResult(this.className, cu));
        return new GeneratorResult(buffer);
    }

    private Expression generateDefaultInitializerExpression(AbstractJSONSchema2Pojo prop) {
        return new NameExpr("io.fabric8.kubernetes.client.utils.Serialization.unmarshal(\"" + StringEscapeUtils.escapeJava((String)Serialization.asJson((Object)prop.getDefaultValue())) + "\", " + prop.getClassType() + ".class)");
    }

    static {
        IGNORED_FIELDS.add("description");
        IGNORED_FIELDS.add("schema");
        IGNORED_FIELDS.add("example");
        IGNORED_FIELDS.add("examples");
    }
}

