/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.HTTPRouteStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteParentStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteParentStatusBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteParentStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPRouteStatusFluent<A extends HTTPRouteStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RouteParentStatusBuilder> parents = new ArrayList();
    private Map<String, Object> additionalProperties;

    public HTTPRouteStatusFluent() {
    }

    public HTTPRouteStatusFluent(HTTPRouteStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPRouteStatus instance) {
        HTTPRouteStatus hTTPRouteStatus = instance = instance != null ? instance : new HTTPRouteStatus();
        if (instance != null) {
            this.withParents(instance.getParents());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToParents(int index, RouteParentStatus item) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
        if (index < 0 || index >= this.parents.size()) {
            this._visitables.get("parents").add(builder);
            this.parents.add(builder);
        } else {
            this._visitables.get("parents").add(index, builder);
            this.parents.add(index, builder);
        }
        return (A)this;
    }

    public A setToParents(int index, RouteParentStatus item) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
        if (index < 0 || index >= this.parents.size()) {
            this._visitables.get("parents").add(builder);
            this.parents.add(builder);
        } else {
            this._visitables.get("parents").set(index, builder);
            this.parents.set(index, builder);
        }
        return (A)this;
    }

    public A addToParents(RouteParentStatus ... items) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        for (RouteParentStatus item : items) {
            RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
            this._visitables.get("parents").add(builder);
            this.parents.add(builder);
        }
        return (A)this;
    }

    public A addAllToParents(Collection<RouteParentStatus> items) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        for (RouteParentStatus item : items) {
            RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
            this._visitables.get("parents").add(builder);
            this.parents.add(builder);
        }
        return (A)this;
    }

    public A removeFromParents(RouteParentStatus ... items) {
        if (this.parents == null) {
            return (A)this;
        }
        for (RouteParentStatus item : items) {
            RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
            this._visitables.get("parents").remove(builder);
            this.parents.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromParents(Collection<RouteParentStatus> items) {
        if (this.parents == null) {
            return (A)this;
        }
        for (RouteParentStatus item : items) {
            RouteParentStatusBuilder builder = new RouteParentStatusBuilder(item);
            this._visitables.get("parents").remove(builder);
            this.parents.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromParents(Predicate<RouteParentStatusBuilder> predicate) {
        if (this.parents == null) {
            return (A)this;
        }
        Iterator<RouteParentStatusBuilder> each = this.parents.iterator();
        Object visitables = this._visitables.get("parents");
        while (each.hasNext()) {
            RouteParentStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RouteParentStatus> buildParents() {
        return this.parents != null ? HTTPRouteStatusFluent.build(this.parents) : null;
    }

    public RouteParentStatus buildParent(int index) {
        return this.parents.get(index).build();
    }

    public RouteParentStatus buildFirstParent() {
        return this.parents.get(0).build();
    }

    public RouteParentStatus buildLastParent() {
        return this.parents.get(this.parents.size() - 1).build();
    }

    public RouteParentStatus buildMatchingParent(Predicate<RouteParentStatusBuilder> predicate) {
        for (RouteParentStatusBuilder item : this.parents) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingParent(Predicate<RouteParentStatusBuilder> predicate) {
        for (RouteParentStatusBuilder item : this.parents) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withParents(List<RouteParentStatus> parents) {
        if (this.parents != null) {
            this._visitables.get("parents").clear();
        }
        if (parents != null) {
            this.parents = new ArrayList();
            for (RouteParentStatus item : parents) {
                this.addToParents(item);
            }
        } else {
            this.parents = null;
        }
        return (A)this;
    }

    public A withParents(RouteParentStatus ... parents) {
        if (this.parents != null) {
            this.parents.clear();
            this._visitables.remove("parents");
        }
        if (parents != null) {
            for (RouteParentStatus item : parents) {
                this.addToParents(item);
            }
        }
        return (A)this;
    }

    public boolean hasParents() {
        return this.parents != null && !this.parents.isEmpty();
    }

    public ParentsNested<A> addNewParent() {
        return new ParentsNested(-1, null);
    }

    public ParentsNested<A> addNewParentLike(RouteParentStatus item) {
        return new ParentsNested(-1, item);
    }

    public ParentsNested<A> setNewParentLike(int index, RouteParentStatus item) {
        return new ParentsNested(index, item);
    }

    public ParentsNested<A> editParent(int index) {
        if (this.parents.size() <= index) {
            throw new RuntimeException("Can't edit parents. Index exceeds size.");
        }
        return this.setNewParentLike(index, this.buildParent(index));
    }

    public ParentsNested<A> editFirstParent() {
        if (this.parents.size() == 0) {
            throw new RuntimeException("Can't edit first parents. The list is empty.");
        }
        return this.setNewParentLike(0, this.buildParent(0));
    }

    public ParentsNested<A> editLastParent() {
        int index = this.parents.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last parents. The list is empty.");
        }
        return this.setNewParentLike(index, this.buildParent(index));
    }

    public ParentsNested<A> editMatchingParent(Predicate<RouteParentStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.parents.size(); ++i) {
            if (!predicate.test(this.parents.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching parents. No match found.");
        }
        return this.setNewParentLike(index, this.buildParent(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPRouteStatusFluent that = (HTTPRouteStatusFluent)o;
        if (!Objects.equals(this.parents, that.parents)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parents, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parents != null && !this.parents.isEmpty()) {
            sb.append("parents:");
            sb.append(this.parents + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ParentsNested<N>
    extends RouteParentStatusFluent<ParentsNested<N>>
    implements Nested<N> {
        RouteParentStatusBuilder builder;
        int index;

        ParentsNested(int index, RouteParentStatus item) {
            this.index = index;
            this.builder = new RouteParentStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HTTPRouteStatusFluent.this.setToParents(this.index, this.builder.build());
        }

        public N endParent() {
            return this.and();
        }
    }
}

