/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator;

import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.WritableCRCompilationUnit;
import io.fabric8.java.generator.exceptions.JavaGeneratorException;
import io.fabric8.java.generator.nodes.AbstractJSONSchema2Pojo;
import io.fabric8.java.generator.nodes.GeneratorResult;
import io.fabric8.java.generator.nodes.JCRObject;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionSpec;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class CRGeneratorRunner {
    private final Config config;

    public CRGeneratorRunner(Config config) {
        this.config = config;
    }

    public List<WritableCRCompilationUnit> generate(CustomResourceDefinition crd, String basePackageName) {
        CustomResourceDefinitionSpec crSpec = crd.getSpec();
        String crName = crSpec.getNames().getKind();
        String group = crSpec.getGroup();
        String scope = crSpec.getScope();
        ArrayList<WritableCRCompilationUnit> writableCUs = new ArrayList<WritableCRCompilationUnit>(crSpec.getVersions().size());
        for (CustomResourceDefinitionVersion crdv : crSpec.getVersions()) {
            String version = crdv.getName();
            String pkg = Optional.ofNullable(basePackageName).map(p -> p + "." + version).orElse(version);
            if (this.config.getPackageOverrides().containsKey(pkg)) {
                pkg = this.config.getPackageOverrides().get(pkg);
            }
            AbstractJSONSchema2Pojo specGenerator = null;
            JSONSchemaProps spec = crdv.getSchema().getOpenAPIV3Schema().getProperties().get("spec");
            if (spec != null) {
                specGenerator = AbstractJSONSchema2Pojo.fromJsonSchema(crName + "Spec", spec, pkg, this.config);
            }
            AbstractJSONSchema2Pojo statusGenerator = null;
            JSONSchemaProps status = crdv.getSchema().getOpenAPIV3Schema().getProperties().get("status");
            if (status != null) {
                statusGenerator = AbstractJSONSchema2Pojo.fromJsonSchema(crName + "Status", status, pkg, this.config);
            }
            JCRObject crGenerator = new JCRObject(pkg, crName, group, version, scope, crName + "Spec", crName + "Status", specGenerator != null, statusGenerator != null, crdv.getStorage(), crdv.getServed(), crSpec.getNames().getSingular(), crSpec.getNames().getPlural(), this.config);
            List<GeneratorResult.ClassResult> classResults = this.validateAndAggregate(crGenerator, specGenerator, statusGenerator);
            writableCUs.add(new WritableCRCompilationUnit(classResults, basePackageName));
        }
        return writableCUs;
    }

    private List<GeneratorResult.ClassResult> validateAndAggregate(AbstractJSONSchema2Pojo ... generators) {
        return Arrays.stream(generators).filter(Objects::nonNull).map(AbstractJSONSchema2Pojo::generateJava).map(CRGeneratorRunner::validateTopLevel).flatMap(g -> g.getTopLevelClasses().stream()).collect(Collectors.toList());
    }

    private static GeneratorResult validateTopLevel(GeneratorResult generatorResult) {
        if (!generatorResult.getInnerClasses().isEmpty()) {
            throw new JavaGeneratorException("Unmatched inner class spilled up to top level " + generatorResult.getInnerClasses().get(0));
        }
        return generatorResult;
    }

    protected static String groupToPackage(String group) {
        List<String> groupElements = Arrays.asList(group.replace('-', '_').split("\\."));
        Collections.reverse(groupElements);
        return String.join((CharSequence)".", groupElements);
    }
}

