/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.OAuthTokenProvider;
import io.fabric8.kubernetes.client.http.TlsVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConfigFluent<A extends ConfigFluent<A>>
extends BaseFluent<A> {
    private boolean trustCerts;
    private boolean disableHostnameVerification;
    private String masterUrl;
    private String apiVersion;
    private String namespace;
    private boolean defaultNamespace;
    private String caCertFile;
    private String caCertData;
    private String clientCertFile;
    private String clientCertData;
    private String clientKeyFile;
    private String clientKeyData;
    private String clientKeyAlgo;
    private String clientKeyPassphrase;
    private String trustStoreFile;
    private String trustStorePassphrase;
    private String keyStoreFile;
    private String keyStorePassphrase;
    private AuthProviderConfig authProvider;
    private String username;
    private String password;
    private String oauthToken;
    private String autoOAuthToken;
    private OAuthTokenProvider oauthTokenProvider;
    private long websocketPingInterval;
    private int connectionTimeout;
    private int maxConcurrentRequests;
    private int maxConcurrentRequestsPerHost;
    private List<NamedContext> contexts;
    private NamedContext currentContext;
    private int watchReconnectInterval;
    private int watchReconnectLimit;
    private int uploadRequestTimeout;
    private int requestRetryBackoffLimit;
    private int requestRetryBackoffInterval;
    private int requestTimeout;
    private long scaleTimeout;
    private int loggingInterval;
    private String impersonateUsername;
    private List<String> impersonateGroups;
    private Map<String, List<String>> impersonateExtras;
    private boolean http2Disable;
    private String httpProxy;
    private String httpsProxy;
    private String proxyUsername;
    private String proxyPassword;
    private List<String> noProxy;
    private String userAgent;
    private List<TlsVersion> tlsVersions;
    private boolean onlyHttpWatches;
    private Map<Integer, String> errorMessages;
    private Map<String, String> customHeaders;
    private boolean autoConfigure;
    private File file;

    public ConfigFluent() {
    }

    public ConfigFluent(Config instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Config instance) {
        Config config = instance = instance != null ? instance : new Config();
        if (instance != null) {
            this.withMasterUrl(instance.getMasterUrl());
            this.withApiVersion(instance.getApiVersion());
            this.withNamespace(instance.getNamespace());
            this.withTrustCerts(instance.isTrustCerts());
            this.withDisableHostnameVerification(instance.isDisableHostnameVerification());
            this.withCaCertFile(instance.getCaCertFile());
            this.withCaCertData(instance.getCaCertData());
            this.withClientCertFile(instance.getClientCertFile());
            this.withClientCertData(instance.getClientCertData());
            this.withClientKeyFile(instance.getClientKeyFile());
            this.withClientKeyData(instance.getClientKeyData());
            this.withClientKeyAlgo(instance.getClientKeyAlgo());
            this.withClientKeyPassphrase(instance.getClientKeyPassphrase());
            this.withUsername(instance.getUsername());
            this.withPassword(instance.getPassword());
            this.withOauthToken(instance.getOauthToken());
            this.withAutoOAuthToken(instance.getAutoOAuthToken());
            this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
            this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
            this.withConnectionTimeout(instance.getConnectionTimeout());
            this.withRequestTimeout(instance.getRequestTimeout());
            this.withScaleTimeout(instance.getScaleTimeout());
            this.withLoggingInterval(instance.getLoggingInterval());
            this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
            this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
            this.withHttp2Disable(instance.isHttp2Disable());
            this.withHttpProxy(instance.getHttpProxy());
            this.withHttpsProxy(instance.getHttpsProxy());
            this.withNoProxy(instance.getNoProxy());
            this.withErrorMessages(instance.getErrorMessages());
            this.withUserAgent(instance.getUserAgent());
            this.withTlsVersions(instance.getTlsVersions());
            this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
            this.withProxyUsername(instance.getProxyUsername());
            this.withProxyPassword(instance.getProxyPassword());
            this.withTrustStoreFile(instance.getTrustStoreFile());
            this.withTrustStorePassphrase(instance.getTrustStorePassphrase());
            this.withKeyStoreFile(instance.getKeyStoreFile());
            this.withKeyStorePassphrase(instance.getKeyStorePassphrase());
            this.withImpersonateUsername(instance.getImpersonateUsername());
            this.withImpersonateGroups(instance.getImpersonateGroups());
            this.withImpersonateExtras(instance.getImpersonateExtras());
            this.withOauthTokenProvider(instance.getOauthTokenProvider());
            this.withCustomHeaders(instance.getCustomHeaders());
            this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
            this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
            this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
            this.withOnlyHttpWatches(instance.isOnlyHttpWatches());
            this.withTrustCerts(instance.isTrustCerts());
            this.withDisableHostnameVerification(instance.isDisableHostnameVerification());
            this.withMasterUrl(instance.getMasterUrl());
            this.withApiVersion(instance.getApiVersion());
            this.withNamespace(instance.getNamespace());
            this.withDefaultNamespace(instance.isDefaultNamespace());
            this.withCaCertFile(instance.getCaCertFile());
            this.withCaCertData(instance.getCaCertData());
            this.withClientCertFile(instance.getClientCertFile());
            this.withClientCertData(instance.getClientCertData());
            this.withClientKeyFile(instance.getClientKeyFile());
            this.withClientKeyData(instance.getClientKeyData());
            this.withClientKeyAlgo(instance.getClientKeyAlgo());
            this.withClientKeyPassphrase(instance.getClientKeyPassphrase());
            this.withTrustStoreFile(instance.getTrustStoreFile());
            this.withTrustStorePassphrase(instance.getTrustStorePassphrase());
            this.withKeyStoreFile(instance.getKeyStoreFile());
            this.withKeyStorePassphrase(instance.getKeyStorePassphrase());
            this.withAuthProvider(instance.getAuthProvider());
            this.withUsername(instance.getUsername());
            this.withPassword(instance.getPassword());
            this.withOauthToken(instance.getOauthToken());
            this.withAutoOAuthToken(instance.getAutoOAuthToken());
            this.withOauthTokenProvider(instance.getOauthTokenProvider());
            this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
            this.withConnectionTimeout(instance.getConnectionTimeout());
            this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
            this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
            this.withContexts(instance.getContexts());
            this.withCurrentContext(instance.getCurrentContext());
            this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
            this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
            this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
            this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
            this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
            this.withRequestTimeout(instance.getRequestTimeout());
            this.withScaleTimeout(instance.getScaleTimeout());
            this.withLoggingInterval(instance.getLoggingInterval());
            this.withImpersonateUsername(instance.getImpersonateUsername());
            this.withImpersonateGroups(instance.getImpersonateGroups());
            this.withImpersonateExtras(instance.getImpersonateExtras());
            this.withHttp2Disable(instance.isHttp2Disable());
            this.withHttpProxy(instance.getHttpProxy());
            this.withHttpsProxy(instance.getHttpsProxy());
            this.withProxyUsername(instance.getProxyUsername());
            this.withProxyPassword(instance.getProxyPassword());
            this.withNoProxy(instance.getNoProxy());
            this.withUserAgent(instance.getUserAgent());
            this.withTlsVersions(instance.getTlsVersions());
            this.withOnlyHttpWatches(instance.isOnlyHttpWatches());
            this.withErrorMessages(instance.getErrorMessages());
            this.withCustomHeaders(instance.getCustomHeaders());
            this.withAutoConfigure(instance.getAutoConfigure());
            this.withFile(instance.getFile());
        }
    }

    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    public A withTrustCerts(boolean trustCerts) {
        this.trustCerts = trustCerts;
        return (A)this;
    }

    public boolean hasTrustCerts() {
        return true;
    }

    public boolean isDisableHostnameVerification() {
        return this.disableHostnameVerification;
    }

    public A withDisableHostnameVerification(boolean disableHostnameVerification) {
        this.disableHostnameVerification = disableHostnameVerification;
        return (A)this;
    }

    public boolean hasDisableHostnameVerification() {
        return true;
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public A withMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
        return (A)this;
    }

    public boolean hasMasterUrl() {
        return this.masterUrl != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public boolean isDefaultNamespace() {
        return this.defaultNamespace;
    }

    public A withDefaultNamespace(boolean defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
        return (A)this;
    }

    public boolean hasDefaultNamespace() {
        return true;
    }

    public String getCaCertFile() {
        return this.caCertFile;
    }

    public A withCaCertFile(String caCertFile) {
        this.caCertFile = caCertFile;
        return (A)this;
    }

    public boolean hasCaCertFile() {
        return this.caCertFile != null;
    }

    public String getCaCertData() {
        return this.caCertData;
    }

    public A withCaCertData(String caCertData) {
        this.caCertData = caCertData;
        return (A)this;
    }

    public boolean hasCaCertData() {
        return this.caCertData != null;
    }

    public String getClientCertFile() {
        return this.clientCertFile;
    }

    public A withClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
        return (A)this;
    }

    public boolean hasClientCertFile() {
        return this.clientCertFile != null;
    }

    public String getClientCertData() {
        return this.clientCertData;
    }

    public A withClientCertData(String clientCertData) {
        this.clientCertData = clientCertData;
        return (A)this;
    }

    public boolean hasClientCertData() {
        return this.clientCertData != null;
    }

    public String getClientKeyFile() {
        return this.clientKeyFile;
    }

    public A withClientKeyFile(String clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
        return (A)this;
    }

    public boolean hasClientKeyFile() {
        return this.clientKeyFile != null;
    }

    public String getClientKeyData() {
        return this.clientKeyData;
    }

    public A withClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
        return (A)this;
    }

    public boolean hasClientKeyData() {
        return this.clientKeyData != null;
    }

    public String getClientKeyAlgo() {
        return this.clientKeyAlgo;
    }

    public A withClientKeyAlgo(String clientKeyAlgo) {
        this.clientKeyAlgo = clientKeyAlgo;
        return (A)this;
    }

    public boolean hasClientKeyAlgo() {
        return this.clientKeyAlgo != null;
    }

    public String getClientKeyPassphrase() {
        return this.clientKeyPassphrase;
    }

    public A withClientKeyPassphrase(String clientKeyPassphrase) {
        this.clientKeyPassphrase = clientKeyPassphrase;
        return (A)this;
    }

    public boolean hasClientKeyPassphrase() {
        return this.clientKeyPassphrase != null;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public A withTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
        return (A)this;
    }

    public boolean hasTrustStoreFile() {
        return this.trustStoreFile != null;
    }

    public String getTrustStorePassphrase() {
        return this.trustStorePassphrase;
    }

    public A withTrustStorePassphrase(String trustStorePassphrase) {
        this.trustStorePassphrase = trustStorePassphrase;
        return (A)this;
    }

    public boolean hasTrustStorePassphrase() {
        return this.trustStorePassphrase != null;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public A withKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
        return (A)this;
    }

    public boolean hasKeyStoreFile() {
        return this.keyStoreFile != null;
    }

    public String getKeyStorePassphrase() {
        return this.keyStorePassphrase;
    }

    public A withKeyStorePassphrase(String keyStorePassphrase) {
        this.keyStorePassphrase = keyStorePassphrase;
        return (A)this;
    }

    public boolean hasKeyStorePassphrase() {
        return this.keyStorePassphrase != null;
    }

    public AuthProviderConfig getAuthProvider() {
        return this.authProvider;
    }

    public A withAuthProvider(AuthProviderConfig authProvider) {
        this.authProvider = authProvider;
        return (A)this;
    }

    public boolean hasAuthProvider() {
        return this.authProvider != null;
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    public boolean hasUsername() {
        return this.username != null;
    }

    public String getPassword() {
        return this.password;
    }

    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public A withOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return (A)this;
    }

    public boolean hasOauthToken() {
        return this.oauthToken != null;
    }

    public String getAutoOAuthToken() {
        return this.autoOAuthToken;
    }

    public A withAutoOAuthToken(String autoOAuthToken) {
        this.autoOAuthToken = autoOAuthToken;
        return (A)this;
    }

    public boolean hasAutoOAuthToken() {
        return this.autoOAuthToken != null;
    }

    public OAuthTokenProvider getOauthTokenProvider() {
        return this.oauthTokenProvider;
    }

    public A withOauthTokenProvider(OAuthTokenProvider oauthTokenProvider) {
        this.oauthTokenProvider = oauthTokenProvider;
        return (A)this;
    }

    public boolean hasOauthTokenProvider() {
        return this.oauthTokenProvider != null;
    }

    public long getWebsocketPingInterval() {
        return this.websocketPingInterval;
    }

    public A withWebsocketPingInterval(long websocketPingInterval) {
        this.websocketPingInterval = websocketPingInterval;
        return (A)this;
    }

    public boolean hasWebsocketPingInterval() {
        return true;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public A withConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return (A)this;
    }

    public boolean hasConnectionTimeout() {
        return true;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public A withMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        return (A)this;
    }

    public boolean hasMaxConcurrentRequests() {
        return true;
    }

    public int getMaxConcurrentRequestsPerHost() {
        return this.maxConcurrentRequestsPerHost;
    }

    public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost) {
        this.maxConcurrentRequestsPerHost = maxConcurrentRequestsPerHost;
        return (A)this;
    }

    public boolean hasMaxConcurrentRequestsPerHost() {
        return true;
    }

    public A addToContexts(int index, NamedContext item) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContext>();
        }
        this.contexts.add(index, item);
        return (A)this;
    }

    public A setToContexts(int index, NamedContext item) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContext>();
        }
        this.contexts.set(index, item);
        return (A)this;
    }

    public A addToContexts(NamedContext ... items) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContext>();
        }
        for (NamedContext item : items) {
            this.contexts.add(item);
        }
        return (A)this;
    }

    public A addAllToContexts(Collection<NamedContext> items) {
        if (this.contexts == null) {
            this.contexts = new ArrayList<NamedContext>();
        }
        for (NamedContext item : items) {
            this.contexts.add(item);
        }
        return (A)this;
    }

    public A removeFromContexts(NamedContext ... items) {
        if (this.contexts == null) {
            return (A)this;
        }
        for (NamedContext item : items) {
            this.contexts.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromContexts(Collection<NamedContext> items) {
        if (this.contexts == null) {
            return (A)this;
        }
        for (NamedContext item : items) {
            this.contexts.remove(item);
        }
        return (A)this;
    }

    public List<NamedContext> getContexts() {
        return this.contexts;
    }

    public NamedContext getContext(int index) {
        return this.contexts.get(index);
    }

    public NamedContext getFirstContext() {
        return this.contexts.get(0);
    }

    public NamedContext getLastContext() {
        return this.contexts.get(this.contexts.size() - 1);
    }

    public NamedContext getMatchingContext(Predicate<NamedContext> predicate) {
        for (NamedContext item : this.contexts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingContext(Predicate<NamedContext> predicate) {
        for (NamedContext item : this.contexts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContexts(List<NamedContext> contexts) {
        if (contexts != null) {
            this.contexts = new ArrayList<NamedContext>();
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        } else {
            this.contexts = null;
        }
        return (A)this;
    }

    public A withContexts(NamedContext ... contexts) {
        if (this.contexts != null) {
            this.contexts.clear();
            this._visitables.remove("contexts");
        }
        if (contexts != null) {
            for (NamedContext item : contexts) {
                this.addToContexts(item);
            }
        }
        return (A)this;
    }

    public boolean hasContexts() {
        return this.contexts != null && !this.contexts.isEmpty();
    }

    public NamedContext getCurrentContext() {
        return this.currentContext;
    }

    public A withCurrentContext(NamedContext currentContext) {
        this.currentContext = currentContext;
        return (A)this;
    }

    public boolean hasCurrentContext() {
        return this.currentContext != null;
    }

    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    public A withWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (A)this;
    }

    public boolean hasWatchReconnectInterval() {
        return true;
    }

    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    public A withWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (A)this;
    }

    public boolean hasWatchReconnectLimit() {
        return true;
    }

    public int getUploadRequestTimeout() {
        return this.uploadRequestTimeout;
    }

    public A withUploadRequestTimeout(int uploadRequestTimeout) {
        this.uploadRequestTimeout = uploadRequestTimeout;
        return (A)this;
    }

    public boolean hasUploadRequestTimeout() {
        return true;
    }

    public int getRequestRetryBackoffLimit() {
        return this.requestRetryBackoffLimit;
    }

    public A withRequestRetryBackoffLimit(int requestRetryBackoffLimit) {
        this.requestRetryBackoffLimit = requestRetryBackoffLimit;
        return (A)this;
    }

    public boolean hasRequestRetryBackoffLimit() {
        return true;
    }

    public int getRequestRetryBackoffInterval() {
        return this.requestRetryBackoffInterval;
    }

    public A withRequestRetryBackoffInterval(int requestRetryBackoffInterval) {
        this.requestRetryBackoffInterval = requestRetryBackoffInterval;
        return (A)this;
    }

    public boolean hasRequestRetryBackoffInterval() {
        return true;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public A withRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (A)this;
    }

    public boolean hasRequestTimeout() {
        return true;
    }

    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    public A withScaleTimeout(long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
        return (A)this;
    }

    public boolean hasScaleTimeout() {
        return true;
    }

    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    public A withLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
        return (A)this;
    }

    public boolean hasLoggingInterval() {
        return true;
    }

    public String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    public A withImpersonateUsername(String impersonateUsername) {
        this.impersonateUsername = impersonateUsername;
        return (A)this;
    }

    public boolean hasImpersonateUsername() {
        return this.impersonateUsername != null;
    }

    public A withImpersonateGroups(String ... impersonateGroups) {
        if (this.impersonateGroups != null) {
            this.impersonateGroups.clear();
            this._visitables.remove("impersonateGroups");
        }
        if (impersonateGroups != null) {
            for (String item : impersonateGroups) {
                this.addToImpersonateGroups(item);
            }
        }
        return (A)this;
    }

    public String[] getImpersonateGroups() {
        int size = this.impersonateGroups != null ? this.impersonateGroups.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.impersonateGroups) {
            result[index++] = item;
        }
        return result;
    }

    public A addToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.add(index, item);
        return (A)this;
    }

    public A setToImpersonateGroups(int index, String item) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        this.impersonateGroups.set(index, item);
        return (A)this;
    }

    public A addToImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    public A addAllToImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            this.impersonateGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    public A removeFromImpersonateGroups(String ... items) {
        if (this.impersonateGroups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromImpersonateGroups(Collection<String> items) {
        if (this.impersonateGroups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    public boolean hasImpersonateGroups() {
        return this.impersonateGroups != null && !this.impersonateGroups.isEmpty();
    }

    public A addToImpersonateExtras(String key, List<String> value) {
        if (this.impersonateExtras == null && key != null && value != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (key != null && value != null) {
            this.impersonateExtras.put(key, value);
        }
        return (A)this;
    }

    public A addToImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null && map != null) {
            this.impersonateExtras = new LinkedHashMap<String, List<String>>();
        }
        if (map != null) {
            this.impersonateExtras.putAll(map);
        }
        return (A)this;
    }

    public A removeFromImpersonateExtras(String key) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (key != null && this.impersonateExtras != null) {
            this.impersonateExtras.remove(key);
        }
        return (A)this;
    }

    public A removeFromImpersonateExtras(Map<String, List<String>> map) {
        if (this.impersonateExtras == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.impersonateExtras == null) continue;
                this.impersonateExtras.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, List<String>> getImpersonateExtras() {
        return this.impersonateExtras;
    }

    public <K, V> A withImpersonateExtras(Map<String, List<String>> impersonateExtras) {
        this.impersonateExtras = impersonateExtras == null ? null : new LinkedHashMap<String, List<String>>(impersonateExtras);
        return (A)this;
    }

    public boolean hasImpersonateExtras() {
        return this.impersonateExtras != null;
    }

    public boolean isHttp2Disable() {
        return this.http2Disable;
    }

    public A withHttp2Disable(boolean http2Disable) {
        this.http2Disable = http2Disable;
        return (A)this;
    }

    public boolean hasHttp2Disable() {
        return true;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    public A withHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        return (A)this;
    }

    public boolean hasHttpProxy() {
        return this.httpProxy != null;
    }

    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    public A withHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
        return (A)this;
    }

    public boolean hasHttpsProxy() {
        return this.httpsProxy != null;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public A withProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return (A)this;
    }

    public boolean hasProxyUsername() {
        return this.proxyUsername != null;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public A withProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return (A)this;
    }

    public boolean hasProxyPassword() {
        return this.proxyPassword != null;
    }

    public A withNoProxy(String ... noProxy) {
        if (this.noProxy != null) {
            this.noProxy.clear();
            this._visitables.remove("noProxy");
        }
        if (noProxy != null) {
            for (String item : noProxy) {
                this.addToNoProxy(item);
            }
        }
        return (A)this;
    }

    public String[] getNoProxy() {
        int size = this.noProxy != null ? this.noProxy.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.noProxy) {
            result[index++] = item;
        }
        return result;
    }

    public A addToNoProxy(int index, String item) {
        if (this.noProxy == null) {
            this.noProxy = new ArrayList<String>();
        }
        this.noProxy.add(index, item);
        return (A)this;
    }

    public A setToNoProxy(int index, String item) {
        if (this.noProxy == null) {
            this.noProxy = new ArrayList<String>();
        }
        this.noProxy.set(index, item);
        return (A)this;
    }

    public A addToNoProxy(String ... items) {
        if (this.noProxy == null) {
            this.noProxy = new ArrayList<String>();
        }
        for (String item : items) {
            this.noProxy.add(item);
        }
        return (A)this;
    }

    public A addAllToNoProxy(Collection<String> items) {
        if (this.noProxy == null) {
            this.noProxy = new ArrayList<String>();
        }
        for (String item : items) {
            this.noProxy.add(item);
        }
        return (A)this;
    }

    public A removeFromNoProxy(String ... items) {
        if (this.noProxy == null) {
            return (A)this;
        }
        for (String item : items) {
            this.noProxy.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromNoProxy(Collection<String> items) {
        if (this.noProxy == null) {
            return (A)this;
        }
        for (String item : items) {
            this.noProxy.remove(item);
        }
        return (A)this;
    }

    public boolean hasNoProxy() {
        return this.noProxy != null && !this.noProxy.isEmpty();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public A withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return (A)this;
    }

    public boolean hasUserAgent() {
        return this.userAgent != null;
    }

    public A withTlsVersions(TlsVersion ... tlsVersions) {
        if (this.tlsVersions != null) {
            this.tlsVersions.clear();
            this._visitables.remove("tlsVersions");
        }
        if (tlsVersions != null) {
            for (TlsVersion item : tlsVersions) {
                this.addToTlsVersions(item);
            }
        }
        return (A)this;
    }

    public TlsVersion[] getTlsVersions() {
        int size = this.tlsVersions != null ? this.tlsVersions.size() : 0;
        TlsVersion[] result = new TlsVersion[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (TlsVersion item : this.tlsVersions) {
            result[index++] = item;
        }
        return result;
    }

    public A addToTlsVersions(int index, TlsVersion item) {
        if (this.tlsVersions == null) {
            this.tlsVersions = new ArrayList<TlsVersion>();
        }
        this.tlsVersions.add(index, item);
        return (A)this;
    }

    public A setToTlsVersions(int index, TlsVersion item) {
        if (this.tlsVersions == null) {
            this.tlsVersions = new ArrayList<TlsVersion>();
        }
        this.tlsVersions.set(index, item);
        return (A)this;
    }

    public A addToTlsVersions(TlsVersion ... items) {
        if (this.tlsVersions == null) {
            this.tlsVersions = new ArrayList<TlsVersion>();
        }
        for (TlsVersion item : items) {
            this.tlsVersions.add(item);
        }
        return (A)this;
    }

    public A addAllToTlsVersions(Collection<TlsVersion> items) {
        if (this.tlsVersions == null) {
            this.tlsVersions = new ArrayList<TlsVersion>();
        }
        for (TlsVersion item : items) {
            this.tlsVersions.add(item);
        }
        return (A)this;
    }

    public A removeFromTlsVersions(TlsVersion ... items) {
        if (this.tlsVersions == null) {
            return (A)this;
        }
        for (TlsVersion item : items) {
            this.tlsVersions.remove((Object)item);
        }
        return (A)this;
    }

    public A removeAllFromTlsVersions(Collection<TlsVersion> items) {
        if (this.tlsVersions == null) {
            return (A)this;
        }
        for (TlsVersion item : items) {
            this.tlsVersions.remove((Object)item);
        }
        return (A)this;
    }

    public boolean hasTlsVersions() {
        return this.tlsVersions != null && !this.tlsVersions.isEmpty();
    }

    public boolean isOnlyHttpWatches() {
        return this.onlyHttpWatches;
    }

    public A withOnlyHttpWatches(boolean onlyHttpWatches) {
        this.onlyHttpWatches = onlyHttpWatches;
        return (A)this;
    }

    public boolean hasOnlyHttpWatches() {
        return true;
    }

    @Deprecated
    public A addToErrorMessages(Integer key, String value) {
        if (this.errorMessages == null && key != null && value != null) {
            this.errorMessages = new LinkedHashMap<Integer, String>();
        }
        if (key != null && value != null) {
            this.errorMessages.put(key, value);
        }
        return (A)this;
    }

    @Deprecated
    public A addToErrorMessages(Map<Integer, String> map) {
        if (this.errorMessages == null && map != null) {
            this.errorMessages = new LinkedHashMap<Integer, String>();
        }
        if (map != null) {
            this.errorMessages.putAll(map);
        }
        return (A)this;
    }

    @Deprecated
    public A removeFromErrorMessages(Integer key) {
        if (this.errorMessages == null) {
            return (A)this;
        }
        if (key != null && this.errorMessages != null) {
            this.errorMessages.remove(key);
        }
        return (A)this;
    }

    @Deprecated
    public A removeFromErrorMessages(Map<Integer, String> map) {
        if (this.errorMessages == null) {
            return (A)this;
        }
        if (map != null) {
            for (Integer key : map.keySet()) {
                if (this.errorMessages == null) continue;
                this.errorMessages.remove(key);
            }
        }
        return (A)this;
    }

    @Deprecated
    public Map<Integer, String> getErrorMessages() {
        return this.errorMessages;
    }

    @Deprecated
    public <K, V> A withErrorMessages(Map<Integer, String> errorMessages) {
        this.errorMessages = errorMessages == null ? null : new LinkedHashMap<Integer, String>(errorMessages);
        return (A)this;
    }

    @Deprecated
    public boolean hasErrorMessages() {
        return this.errorMessages != null;
    }

    public A addToCustomHeaders(String key, String value) {
        if (this.customHeaders == null && key != null && value != null) {
            this.customHeaders = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.customHeaders.put(key, value);
        }
        return (A)this;
    }

    public A addToCustomHeaders(Map<String, String> map) {
        if (this.customHeaders == null && map != null) {
            this.customHeaders = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.customHeaders.putAll(map);
        }
        return (A)this;
    }

    public A removeFromCustomHeaders(String key) {
        if (this.customHeaders == null) {
            return (A)this;
        }
        if (key != null && this.customHeaders != null) {
            this.customHeaders.remove(key);
        }
        return (A)this;
    }

    public A removeFromCustomHeaders(Map<String, String> map) {
        if (this.customHeaders == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.customHeaders == null) continue;
                this.customHeaders.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public <K, V> A withCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders == null ? null : new LinkedHashMap<String, String>(customHeaders);
        return (A)this;
    }

    public boolean hasCustomHeaders() {
        return this.customHeaders != null;
    }

    public boolean isAutoConfigure() {
        return this.autoConfigure;
    }

    public A withAutoConfigure(boolean autoConfigure) {
        this.autoConfigure = autoConfigure;
        return (A)this;
    }

    public boolean hasAutoConfigure() {
        return true;
    }

    public File getFile() {
        return this.file;
    }

    public A withFile(File file) {
        this.file = file;
        return (A)this;
    }

    public boolean hasFile() {
        return this.file != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigFluent that = (ConfigFluent)o;
        if (this.trustCerts != that.trustCerts) {
            return false;
        }
        if (this.disableHostnameVerification != that.disableHostnameVerification) {
            return false;
        }
        if (!Objects.equals(this.masterUrl, that.masterUrl)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (this.defaultNamespace != that.defaultNamespace) {
            return false;
        }
        if (!Objects.equals(this.caCertFile, that.caCertFile)) {
            return false;
        }
        if (!Objects.equals(this.caCertData, that.caCertData)) {
            return false;
        }
        if (!Objects.equals(this.clientCertFile, that.clientCertFile)) {
            return false;
        }
        if (!Objects.equals(this.clientCertData, that.clientCertData)) {
            return false;
        }
        if (!Objects.equals(this.clientKeyFile, that.clientKeyFile)) {
            return false;
        }
        if (!Objects.equals(this.clientKeyData, that.clientKeyData)) {
            return false;
        }
        if (!Objects.equals(this.clientKeyAlgo, that.clientKeyAlgo)) {
            return false;
        }
        if (!Objects.equals(this.clientKeyPassphrase, that.clientKeyPassphrase)) {
            return false;
        }
        if (!Objects.equals(this.trustStoreFile, that.trustStoreFile)) {
            return false;
        }
        if (!Objects.equals(this.trustStorePassphrase, that.trustStorePassphrase)) {
            return false;
        }
        if (!Objects.equals(this.keyStoreFile, that.keyStoreFile)) {
            return false;
        }
        if (!Objects.equals(this.keyStorePassphrase, that.keyStorePassphrase)) {
            return false;
        }
        if (!Objects.equals(this.authProvider, that.authProvider)) {
            return false;
        }
        if (!Objects.equals(this.username, that.username)) {
            return false;
        }
        if (!Objects.equals(this.password, that.password)) {
            return false;
        }
        if (!Objects.equals(this.oauthToken, that.oauthToken)) {
            return false;
        }
        if (!Objects.equals(this.autoOAuthToken, that.autoOAuthToken)) {
            return false;
        }
        if (!Objects.equals(this.oauthTokenProvider, that.oauthTokenProvider)) {
            return false;
        }
        if (this.websocketPingInterval != that.websocketPingInterval) {
            return false;
        }
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.maxConcurrentRequests != that.maxConcurrentRequests) {
            return false;
        }
        if (this.maxConcurrentRequestsPerHost != that.maxConcurrentRequestsPerHost) {
            return false;
        }
        if (!Objects.equals(this.contexts, that.contexts)) {
            return false;
        }
        if (!Objects.equals(this.currentContext, that.currentContext)) {
            return false;
        }
        if (this.watchReconnectInterval != that.watchReconnectInterval) {
            return false;
        }
        if (this.watchReconnectLimit != that.watchReconnectLimit) {
            return false;
        }
        if (this.uploadRequestTimeout != that.uploadRequestTimeout) {
            return false;
        }
        if (this.requestRetryBackoffLimit != that.requestRetryBackoffLimit) {
            return false;
        }
        if (this.requestRetryBackoffInterval != that.requestRetryBackoffInterval) {
            return false;
        }
        if (this.requestTimeout != that.requestTimeout) {
            return false;
        }
        if (this.scaleTimeout != that.scaleTimeout) {
            return false;
        }
        if (this.loggingInterval != that.loggingInterval) {
            return false;
        }
        if (!Objects.equals(this.impersonateUsername, that.impersonateUsername)) {
            return false;
        }
        if (!Objects.equals(this.impersonateGroups, that.impersonateGroups)) {
            return false;
        }
        if (!Objects.equals(this.impersonateExtras, that.impersonateExtras)) {
            return false;
        }
        if (this.http2Disable != that.http2Disable) {
            return false;
        }
        if (!Objects.equals(this.httpProxy, that.httpProxy)) {
            return false;
        }
        if (!Objects.equals(this.httpsProxy, that.httpsProxy)) {
            return false;
        }
        if (!Objects.equals(this.proxyUsername, that.proxyUsername)) {
            return false;
        }
        if (!Objects.equals(this.proxyPassword, that.proxyPassword)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.userAgent, that.userAgent)) {
            return false;
        }
        if (!Objects.equals(this.tlsVersions, that.tlsVersions)) {
            return false;
        }
        if (this.onlyHttpWatches != that.onlyHttpWatches) {
            return false;
        }
        if (!Objects.equals(this.errorMessages, that.errorMessages)) {
            return false;
        }
        if (!Objects.equals(this.customHeaders, that.customHeaders)) {
            return false;
        }
        if (this.autoConfigure != that.autoConfigure) {
            return false;
        }
        return Objects.equals(this.file, that.file);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.trustCerts, this.disableHostnameVerification, this.masterUrl, this.apiVersion, this.namespace, this.defaultNamespace, this.caCertFile, this.caCertData, this.clientCertFile, this.clientCertData, this.clientKeyFile, this.clientKeyData, this.clientKeyAlgo, this.clientKeyPassphrase, this.trustStoreFile, this.trustStorePassphrase, this.keyStoreFile, this.keyStorePassphrase, this.authProvider, this.username, this.password, this.oauthToken, this.autoOAuthToken, this.oauthTokenProvider, this.websocketPingInterval, this.connectionTimeout, this.maxConcurrentRequests, this.maxConcurrentRequestsPerHost, this.contexts, this.currentContext, this.watchReconnectInterval, this.watchReconnectLimit, this.uploadRequestTimeout, this.requestRetryBackoffLimit, this.requestRetryBackoffInterval, this.requestTimeout, this.scaleTimeout, this.loggingInterval, this.impersonateUsername, this.impersonateGroups, this.impersonateExtras, this.http2Disable, this.httpProxy, this.httpsProxy, this.proxyUsername, this.proxyPassword, this.noProxy, this.userAgent, this.tlsVersions, this.onlyHttpWatches, this.errorMessages, this.customHeaders, this.autoConfigure, this.file, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("trustCerts:");
        sb.append(this.trustCerts + ",");
        sb.append("disableHostnameVerification:");
        sb.append(this.disableHostnameVerification + ",");
        if (this.masterUrl != null) {
            sb.append("masterUrl:");
            sb.append(this.masterUrl + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        sb.append("defaultNamespace:");
        sb.append(this.defaultNamespace + ",");
        if (this.caCertFile != null) {
            sb.append("caCertFile:");
            sb.append(this.caCertFile + ",");
        }
        if (this.caCertData != null) {
            sb.append("caCertData:");
            sb.append(this.caCertData + ",");
        }
        if (this.clientCertFile != null) {
            sb.append("clientCertFile:");
            sb.append(this.clientCertFile + ",");
        }
        if (this.clientCertData != null) {
            sb.append("clientCertData:");
            sb.append(this.clientCertData + ",");
        }
        if (this.clientKeyFile != null) {
            sb.append("clientKeyFile:");
            sb.append(this.clientKeyFile + ",");
        }
        if (this.clientKeyData != null) {
            sb.append("clientKeyData:");
            sb.append(this.clientKeyData + ",");
        }
        if (this.clientKeyAlgo != null) {
            sb.append("clientKeyAlgo:");
            sb.append(this.clientKeyAlgo + ",");
        }
        if (this.clientKeyPassphrase != null) {
            sb.append("clientKeyPassphrase:");
            sb.append(this.clientKeyPassphrase + ",");
        }
        if (this.trustStoreFile != null) {
            sb.append("trustStoreFile:");
            sb.append(this.trustStoreFile + ",");
        }
        if (this.trustStorePassphrase != null) {
            sb.append("trustStorePassphrase:");
            sb.append(this.trustStorePassphrase + ",");
        }
        if (this.keyStoreFile != null) {
            sb.append("keyStoreFile:");
            sb.append(this.keyStoreFile + ",");
        }
        if (this.keyStorePassphrase != null) {
            sb.append("keyStorePassphrase:");
            sb.append(this.keyStorePassphrase + ",");
        }
        if (this.authProvider != null) {
            sb.append("authProvider:");
            sb.append(this.authProvider + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password + ",");
        }
        if (this.oauthToken != null) {
            sb.append("oauthToken:");
            sb.append(this.oauthToken + ",");
        }
        if (this.autoOAuthToken != null) {
            sb.append("autoOAuthToken:");
            sb.append(this.autoOAuthToken + ",");
        }
        if (this.oauthTokenProvider != null) {
            sb.append("oauthTokenProvider:");
            sb.append(this.oauthTokenProvider + ",");
        }
        sb.append("websocketPingInterval:");
        sb.append(this.websocketPingInterval + ",");
        sb.append("connectionTimeout:");
        sb.append(this.connectionTimeout + ",");
        sb.append("maxConcurrentRequests:");
        sb.append(this.maxConcurrentRequests + ",");
        sb.append("maxConcurrentRequestsPerHost:");
        sb.append(this.maxConcurrentRequestsPerHost + ",");
        if (this.contexts != null && !this.contexts.isEmpty()) {
            sb.append("contexts:");
            sb.append(this.contexts + ",");
        }
        if (this.currentContext != null) {
            sb.append("currentContext:");
            sb.append(this.currentContext + ",");
        }
        sb.append("watchReconnectInterval:");
        sb.append(this.watchReconnectInterval + ",");
        sb.append("watchReconnectLimit:");
        sb.append(this.watchReconnectLimit + ",");
        sb.append("uploadRequestTimeout:");
        sb.append(this.uploadRequestTimeout + ",");
        sb.append("requestRetryBackoffLimit:");
        sb.append(this.requestRetryBackoffLimit + ",");
        sb.append("requestRetryBackoffInterval:");
        sb.append(this.requestRetryBackoffInterval + ",");
        sb.append("requestTimeout:");
        sb.append(this.requestTimeout + ",");
        sb.append("scaleTimeout:");
        sb.append(this.scaleTimeout + ",");
        sb.append("loggingInterval:");
        sb.append(this.loggingInterval + ",");
        if (this.impersonateUsername != null) {
            sb.append("impersonateUsername:");
            sb.append(this.impersonateUsername + ",");
        }
        if (this.impersonateGroups != null && !this.impersonateGroups.isEmpty()) {
            sb.append("impersonateGroups:");
            sb.append(this.impersonateGroups + ",");
        }
        if (this.impersonateExtras != null && !this.impersonateExtras.isEmpty()) {
            sb.append("impersonateExtras:");
            sb.append(this.impersonateExtras + ",");
        }
        sb.append("http2Disable:");
        sb.append(this.http2Disable + ",");
        if (this.httpProxy != null) {
            sb.append("httpProxy:");
            sb.append(this.httpProxy + ",");
        }
        if (this.httpsProxy != null) {
            sb.append("httpsProxy:");
            sb.append(this.httpsProxy + ",");
        }
        if (this.proxyUsername != null) {
            sb.append("proxyUsername:");
            sb.append(this.proxyUsername + ",");
        }
        if (this.proxyPassword != null) {
            sb.append("proxyPassword:");
            sb.append(this.proxyPassword + ",");
        }
        if (this.noProxy != null && !this.noProxy.isEmpty()) {
            sb.append("noProxy:");
            sb.append(this.noProxy + ",");
        }
        if (this.userAgent != null) {
            sb.append("userAgent:");
            sb.append(this.userAgent + ",");
        }
        if (this.tlsVersions != null && !this.tlsVersions.isEmpty()) {
            sb.append("tlsVersions:");
            sb.append(this.tlsVersions + ",");
        }
        sb.append("onlyHttpWatches:");
        sb.append(this.onlyHttpWatches + ",");
        if (this.errorMessages != null && !this.errorMessages.isEmpty()) {
            sb.append("errorMessages:");
            sb.append(this.errorMessages + ",");
        }
        if (this.customHeaders != null && !this.customHeaders.isEmpty()) {
            sb.append("customHeaders:");
            sb.append(this.customHeaders + ",");
        }
        sb.append("autoConfigure:");
        sb.append(this.autoConfigure + ",");
        if (this.file != null) {
            sb.append("file:");
            sb.append(this.file);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withTrustCerts() {
        return this.withTrustCerts(true);
    }

    public A withDisableHostnameVerification() {
        return this.withDisableHostnameVerification(true);
    }

    public A withDefaultNamespace() {
        return this.withDefaultNamespace(true);
    }

    public A withHttp2Disable() {
        return this.withHttp2Disable(true);
    }

    public A withOnlyHttpWatches() {
        return this.withOnlyHttpWatches(true);
    }

    public A withAutoConfigure() {
        return this.withAutoConfigure(true);
    }
}

