/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.events.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.events.v1beta1.Event;
import io.fabric8.kubernetes.api.model.events.v1beta1.EventFluent;
import io.fabric8.kubernetes.api.model.events.v1beta1.EventSeries;
import io.fabric8.kubernetes.api.model.events.v1beta1.EventSeriesBuilder;
import io.fabric8.kubernetes.api.model.events.v1beta1.EventSeriesFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class EventFluentImpl<A extends EventFluent<A>>
extends BaseFluent<A>
implements EventFluent<A> {
    private String action;
    private String apiVersion;
    private Integer deprecatedCount;
    private String deprecatedFirstTimestamp;
    private String deprecatedLastTimestamp;
    private EventSource deprecatedSource;
    private MicroTime eventTime;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String note;
    private String reason;
    private ObjectReferenceBuilder regarding;
    private ObjectReferenceBuilder related;
    private String reportingController;
    private String reportingInstance;
    private EventSeriesBuilder series;
    private String type;
    private Map<String, Object> additionalProperties;

    public EventFluentImpl() {
    }

    public EventFluentImpl(Event instance) {
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withApiVersion(instance.getApiVersion());
            this.withDeprecatedCount(instance.getDeprecatedCount());
            this.withDeprecatedFirstTimestamp(instance.getDeprecatedFirstTimestamp());
            this.withDeprecatedLastTimestamp(instance.getDeprecatedLastTimestamp());
            this.withDeprecatedSource(instance.getDeprecatedSource());
            this.withEventTime(instance.getEventTime());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNote(instance.getNote());
            this.withReason(instance.getReason());
            this.withRegarding(instance.getRegarding());
            this.withRelated(instance.getRelated());
            this.withReportingController(instance.getReportingController());
            this.withReportingInstance(instance.getReportingInstance());
            this.withSeries(instance.getSeries());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    @Override
    public Boolean hasAction() {
        return this.action != null;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public Integer getDeprecatedCount() {
        return this.deprecatedCount;
    }

    @Override
    public A withDeprecatedCount(Integer deprecatedCount) {
        this.deprecatedCount = deprecatedCount;
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedCount() {
        return this.deprecatedCount != null;
    }

    @Override
    public String getDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp;
    }

    @Override
    public A withDeprecatedFirstTimestamp(String deprecatedFirstTimestamp) {
        this.deprecatedFirstTimestamp = deprecatedFirstTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedFirstTimestamp() {
        return this.deprecatedFirstTimestamp != null;
    }

    @Override
    public String getDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp;
    }

    @Override
    public A withDeprecatedLastTimestamp(String deprecatedLastTimestamp) {
        this.deprecatedLastTimestamp = deprecatedLastTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedLastTimestamp() {
        return this.deprecatedLastTimestamp != null;
    }

    @Override
    public EventSource getDeprecatedSource() {
        return this.deprecatedSource;
    }

    @Override
    public A withDeprecatedSource(EventSource deprecatedSource) {
        this.deprecatedSource = deprecatedSource;
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedSource() {
        return this.deprecatedSource != null;
    }

    @Override
    public A withNewDeprecatedSource(String component, String host) {
        return this.withDeprecatedSource(new EventSource(component, host));
    }

    @Override
    public MicroTime getEventTime() {
        return this.eventTime;
    }

    @Override
    public A withEventTime(MicroTime eventTime) {
        this.eventTime = eventTime;
        return (A)this;
    }

    @Override
    public Boolean hasEventTime() {
        return this.eventTime != null;
    }

    @Override
    public A withNewEventTime(String time) {
        return this.withEventTime(new MicroTime(time));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public EventFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EventFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EventFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public EventFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public EventFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public A withNote(String note) {
        this.note = note;
        return (A)this;
    }

    @Override
    public Boolean hasNote() {
        return this.note != null;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    @Deprecated
    public ObjectReference getRegarding() {
        return this.regarding != null ? this.regarding.build() : null;
    }

    @Override
    public ObjectReference buildRegarding() {
        return this.regarding != null ? this.regarding.build() : null;
    }

    @Override
    public A withRegarding(ObjectReference regarding) {
        this._visitables.get("regarding").remove(this.regarding);
        if (regarding != null) {
            this.regarding = new ObjectReferenceBuilder(regarding);
            this._visitables.get("regarding").add(this.regarding);
        } else {
            this.regarding = null;
            this._visitables.get("regarding").remove(this.regarding);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRegarding() {
        return this.regarding != null;
    }

    @Override
    public EventFluent.RegardingNested<A> withNewRegarding() {
        return new RegardingNestedImpl();
    }

    @Override
    public EventFluent.RegardingNested<A> withNewRegardingLike(ObjectReference item) {
        return new RegardingNestedImpl(item);
    }

    @Override
    public EventFluent.RegardingNested<A> editRegarding() {
        return this.withNewRegardingLike(this.getRegarding());
    }

    @Override
    public EventFluent.RegardingNested<A> editOrNewRegarding() {
        return this.withNewRegardingLike(this.getRegarding() != null ? this.getRegarding() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EventFluent.RegardingNested<A> editOrNewRegardingLike(ObjectReference item) {
        return this.withNewRegardingLike(this.getRegarding() != null ? this.getRegarding() : item);
    }

    @Override
    @Deprecated
    public ObjectReference getRelated() {
        return this.related != null ? this.related.build() : null;
    }

    @Override
    public ObjectReference buildRelated() {
        return this.related != null ? this.related.build() : null;
    }

    @Override
    public A withRelated(ObjectReference related) {
        this._visitables.get("related").remove(this.related);
        if (related != null) {
            this.related = new ObjectReferenceBuilder(related);
            this._visitables.get("related").add(this.related);
        } else {
            this.related = null;
            this._visitables.get("related").remove(this.related);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRelated() {
        return this.related != null;
    }

    @Override
    public EventFluent.RelatedNested<A> withNewRelated() {
        return new RelatedNestedImpl();
    }

    @Override
    public EventFluent.RelatedNested<A> withNewRelatedLike(ObjectReference item) {
        return new RelatedNestedImpl(item);
    }

    @Override
    public EventFluent.RelatedNested<A> editRelated() {
        return this.withNewRelatedLike(this.getRelated());
    }

    @Override
    public EventFluent.RelatedNested<A> editOrNewRelated() {
        return this.withNewRelatedLike(this.getRelated() != null ? this.getRelated() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EventFluent.RelatedNested<A> editOrNewRelatedLike(ObjectReference item) {
        return this.withNewRelatedLike(this.getRelated() != null ? this.getRelated() : item);
    }

    @Override
    public String getReportingController() {
        return this.reportingController;
    }

    @Override
    public A withReportingController(String reportingController) {
        this.reportingController = reportingController;
        return (A)this;
    }

    @Override
    public Boolean hasReportingController() {
        return this.reportingController != null;
    }

    @Override
    public String getReportingInstance() {
        return this.reportingInstance;
    }

    @Override
    public A withReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return (A)this;
    }

    @Override
    public Boolean hasReportingInstance() {
        return this.reportingInstance != null;
    }

    @Override
    @Deprecated
    public EventSeries getSeries() {
        return this.series != null ? this.series.build() : null;
    }

    @Override
    public EventSeries buildSeries() {
        return this.series != null ? this.series.build() : null;
    }

    @Override
    public A withSeries(EventSeries series) {
        this._visitables.get("series").remove(this.series);
        if (series != null) {
            this.series = new EventSeriesBuilder(series);
            this._visitables.get("series").add(this.series);
        } else {
            this.series = null;
            this._visitables.get("series").remove(this.series);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeries() {
        return this.series != null;
    }

    @Override
    public EventFluent.SeriesNested<A> withNewSeries() {
        return new SeriesNestedImpl();
    }

    @Override
    public EventFluent.SeriesNested<A> withNewSeriesLike(EventSeries item) {
        return new SeriesNestedImpl(item);
    }

    @Override
    public EventFluent.SeriesNested<A> editSeries() {
        return this.withNewSeriesLike(this.getSeries());
    }

    @Override
    public EventFluent.SeriesNested<A> editOrNewSeries() {
        return this.withNewSeriesLike(this.getSeries() != null ? this.getSeries() : new EventSeriesBuilder().build());
    }

    @Override
    public EventFluent.SeriesNested<A> editOrNewSeriesLike(EventSeries item) {
        return this.withNewSeriesLike(this.getSeries() != null ? this.getSeries() : item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventFluentImpl that = (EventFluentImpl)o;
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedCount, that.deprecatedCount)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedFirstTimestamp, that.deprecatedFirstTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedLastTimestamp, that.deprecatedLastTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedSource, that.deprecatedSource)) {
            return false;
        }
        if (!Objects.equals(this.eventTime, that.eventTime)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.note, that.note)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.regarding, that.regarding)) {
            return false;
        }
        if (!Objects.equals(this.related, that.related)) {
            return false;
        }
        if (!Objects.equals(this.reportingController, that.reportingController)) {
            return false;
        }
        if (!Objects.equals(this.reportingInstance, that.reportingInstance)) {
            return false;
        }
        if (!Objects.equals(this.series, that.series)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.action, this.apiVersion, this.deprecatedCount, this.deprecatedFirstTimestamp, this.deprecatedLastTimestamp, this.deprecatedSource, this.eventTime, this.kind, this.metadata, this.note, this.reason, this.regarding, this.related, this.reportingController, this.reportingInstance, this.series, this.type, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.deprecatedCount != null) {
            sb.append("deprecatedCount:");
            sb.append(this.deprecatedCount + ",");
        }
        if (this.deprecatedFirstTimestamp != null) {
            sb.append("deprecatedFirstTimestamp:");
            sb.append(this.deprecatedFirstTimestamp + ",");
        }
        if (this.deprecatedLastTimestamp != null) {
            sb.append("deprecatedLastTimestamp:");
            sb.append(this.deprecatedLastTimestamp + ",");
        }
        if (this.deprecatedSource != null) {
            sb.append("deprecatedSource:");
            sb.append(this.deprecatedSource + ",");
        }
        if (this.eventTime != null) {
            sb.append("eventTime:");
            sb.append(this.eventTime + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.note != null) {
            sb.append("note:");
            sb.append(this.note + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.regarding != null) {
            sb.append("regarding:");
            sb.append(this.regarding + ",");
        }
        if (this.related != null) {
            sb.append("related:");
            sb.append(this.related + ",");
        }
        if (this.reportingController != null) {
            sb.append("reportingController:");
            sb.append(this.reportingController + ",");
        }
        if (this.reportingInstance != null) {
            sb.append("reportingInstance:");
            sb.append(this.reportingInstance + ",");
        }
        if (this.series != null) {
            sb.append("series:");
            sb.append(this.series + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SeriesNestedImpl<N>
    extends EventSeriesFluentImpl<EventFluent.SeriesNested<N>>
    implements EventFluent.SeriesNested<N>,
    Nested<N> {
        EventSeriesBuilder builder;

        SeriesNestedImpl(EventSeries item) {
            this.builder = new EventSeriesBuilder(this, item);
        }

        SeriesNestedImpl() {
            this.builder = new EventSeriesBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withSeries(this.builder.build());
        }

        @Override
        public N endSeries() {
            return this.and();
        }
    }

    class RelatedNestedImpl<N>
    extends ObjectReferenceFluentImpl<EventFluent.RelatedNested<N>>
    implements EventFluent.RelatedNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        RelatedNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        RelatedNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withRelated(this.builder.build());
        }

        @Override
        public N endRelated() {
            return this.and();
        }
    }

    class RegardingNestedImpl<N>
    extends ObjectReferenceFluentImpl<EventFluent.RegardingNested<N>>
    implements EventFluent.RegardingNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        RegardingNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        RegardingNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withRegarding(this.builder.build());
        }

        @Override
        public N endRegarding() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<EventFluent.MetadataNested<N>>
    implements EventFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

