/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.fabric8.kubernetes.model.jackson.UnmatchedFieldTypeModule;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.representer.StandardRepresenter;

public class KubernetesSerialization {
    private final ObjectMapper mapper;
    private final UnmatchedFieldTypeModule unmatchedFieldTypeModule = new UnmatchedFieldTypeModule();
    private KubernetesDeserializer kubernetesDeserializer;
    private final boolean searchClassloaders;

    public KubernetesSerialization() {
        this(new ObjectMapper(), true);
    }

    public KubernetesSerialization(ObjectMapper mapper, boolean searchClassloaders) {
        this.mapper = mapper;
        this.searchClassloaders = searchClassloaders;
        this.configureMapper(mapper);
    }

    protected void configureMapper(ObjectMapper mapper) {
        mapper.registerModules(new JavaTimeModule(), this.unmatchedFieldTypeModule);
        mapper.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        final HandlerInstantiator instanciator = mapper.getDeserializationConfig().getHandlerInstantiator();
        mapper.setConfig((DeserializationConfig)mapper.getDeserializationConfig().with(new HandlerInstantiator(){

            @Override
            public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
                if (deserClass == KubernetesDeserializer.class) {
                    return KubernetesSerialization.this.getKubernetesDeserializer();
                }
                if (instanciator == null) {
                    return null;
                }
                return instanciator.deserializerInstance(config, annotated, deserClass);
            }

            @Override
            public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
                if (instanciator == null) {
                    return null;
                }
                return instanciator.keyDeserializerInstance(config, annotated, keyDeserClass);
            }

            @Override
            public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
                if (instanciator == null) {
                    return null;
                }
                return instanciator.serializerInstance(config, annotated, serClass);
            }

            @Override
            public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
                if (instanciator == null) {
                    return null;
                }
                return instanciator.typeResolverBuilderInstance(config, annotated, builderClass);
            }

            @Override
            public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
                if (instanciator == null) {
                    return null;
                }
                return instanciator.typeIdResolverInstance(config, annotated, resolverClass);
            }
        }));
    }

    private synchronized KubernetesDeserializer getKubernetesDeserializer() {
        if (this.kubernetesDeserializer == null) {
            this.kubernetesDeserializer = new KubernetesDeserializer(this.searchClassloaders);
        }
        return this.kubernetesDeserializer;
    }

    public <T> String asJson(T object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public <T> String asYaml(T object) {
        DumpSettings settings = DumpSettings.builder().setExplicitStart(true).setDefaultFlowStyle(FlowStyle.BLOCK).build();
        Dump yaml = new Dump(settings, new StandardRepresenter(settings){
            private boolean quote;
            {
                this.quote = true;
            }

            @Override
            protected NodeTuple representMappingEntry(Map.Entry<?, ?> entry) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    this.quote = false;
                    String str = (String)key;
                    if (str.length() == 1) {
                        char start = str.charAt(0);
                        this.quote = start == 'y' || start == 'Y' || start == 'n' || start == 'N';
                    }
                }
                Node nodeKey = this.representData(key);
                this.quote = true;
                return new NodeTuple(nodeKey, this.representData(entry.getValue()));
            }

            @Override
            protected Node representScalar(Tag tag, String value, ScalarStyle style) {
                if (style == ScalarStyle.PLAIN) {
                    style = this.quote && tag == Tag.STR ? ScalarStyle.DOUBLE_QUOTED : this.defaultScalarStyle;
                }
                return new ScalarNode(tag, value, style);
            }
        });
        return yaml.dumpToString(this.mapper.convertValue(object, Object.class));
    }

    public <T> T unmarshal(InputStream is) {
        return this.unmarshal(is, new TypeReference<T>(){

            @Override
            public Type getType() {
                return KubernetesResource.class;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T unmarshal(InputStream is, TypeReference<T> type) {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            Object result = intch != 123 && intch != 91 ? this.parseYaml(bis, type) : this.mapper.readerFor(type).readValue(bis);
            Object t = result;
            return t;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private <T> T parseYaml(BufferedInputStream bis, TypeReference<T> type) {
        T result = null;
        ArrayList<KubernetesResource> listResult = null;
        Load yaml = new Load(LoadSettings.builder().build());
        Iterable<Object> objs = yaml.loadAllFromInputStream(bis);
        for (Object obj : objs) {
            T value = null;
            if (obj instanceof Map) {
                value = this.mapper.convertValue(obj, type);
            } else if (obj != null) {
                value = this.mapper.convertValue((Object)new RawExtension(obj), type);
            }
            if (value == null) continue;
            if (result == null) {
                result = value;
                continue;
            }
            if (listResult == null) {
                listResult = new ArrayList<KubernetesResource>();
                KubernetesSerialization.accumulateResult(result, listResult);
            }
            KubernetesSerialization.accumulateResult(value, listResult);
        }
        if (listResult != null) {
            return (T)listResult;
        }
        return result;
    }

    private static <T> void accumulateResult(T result, List<KubernetesResource> listResult) {
        if (result instanceof KubernetesResourceList) {
            listResult.addAll(((KubernetesResourceList)result).getItems());
        } else {
            listResult.add((KubernetesResource)result);
        }
    }

    public <T> T unmarshal(String str) {
        return (T)this.unmarshal(str, KubernetesResource.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T unmarshal(String str, Class<T> type) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = this.unmarshal((InputStream)is, type);
            return t;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public <T> T unmarshal(InputStream is, final Class<T> type) {
        return this.unmarshal(is, new TypeReference<T>(){

            @Override
            public Type getType() {
                return type;
            }
        });
    }

    public <T> T clone(T resource) {
        try {
            return (T)this.mapper.readValue(this.mapper.writeValueAsString(resource), resource.getClass());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T convertValue(Object value, Class<T> type) {
        return this.mapper.convertValue(value, type);
    }

    public Type constructParametricType(Class<?> parameterizedClass, Class<?> parameterType) {
        return this.mapper.getTypeFactory().constructParametricType(parameterizedClass, parameterType);
    }

    public Class<? extends KubernetesResource> getRegisteredKubernetesResource(String apiVersion, String kind) {
        return this.getKubernetesDeserializer().getRegisteredKind(apiVersion, kind);
    }

    public UnmatchedFieldTypeModule getUnmatchedFieldTypeModule() {
        return this.unmatchedFieldTypeModule;
    }

    ObjectMapper getMapper() {
        return this.mapper;
    }

    public void registerKubernetesResource(Class<? extends KubernetesResource> clazz) {
        this.getKubernetesDeserializer().registerKubernetesResource(clazz);
    }

    public void registerKubernetesResource(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
        this.getKubernetesDeserializer().registerCustomKind(apiVersion, kind, clazz);
    }

    public String convertToJson(String input) {
        try {
            this.mapper.readTree(input);
            return input;
        }
        catch (JsonProcessingException e) {
            return this.asJson(this.unmarshal(input, JsonNode.class));
        }
    }
}

