/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.nodes;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GeneratorResult {
    private final List<ClassResult> topLevelClasses;
    private final List<ClassResult> innerClasses;

    public List<ClassResult> getInnerClasses() {
        return this.innerClasses;
    }

    public List<ClassResult> getTopLevelClasses() {
        return this.topLevelClasses;
    }

    public GeneratorResult() {
        this.topLevelClasses = new ArrayList<ClassResult>();
        this.innerClasses = new ArrayList<ClassResult>();
    }

    public GeneratorResult(List<ClassResult> topLevelClasses) {
        this.topLevelClasses = topLevelClasses;
        this.innerClasses = new ArrayList<ClassResult>();
    }

    public GeneratorResult(List<ClassResult> topLevelClasses, List<ClassResult> innerClasses) {
        this.topLevelClasses = topLevelClasses;
        this.innerClasses = innerClasses;
    }

    public static class ClassResult {
        private final String name;
        private final CompilationUnit cu;
        private final String javaSource;

        public ClassResult(String name, CompilationUnit cu) {
            this.name = name;
            this.cu = cu;
            this.javaSource = cu.toString();
        }

        public String getName() {
            return this.name;
        }

        public String getJavaSource() {
            return this.javaSource;
        }

        public Optional<PackageDeclaration> getPackageDeclaration() {
            return this.cu.getPackageDeclaration();
        }

        public Optional<EnumDeclaration> getEnumByName(String enumName) {
            return this.cu.getEnumByName(enumName);
        }

        public Optional<ClassOrInterfaceDeclaration> getClassByName(String className) {
            return this.cu.getClassByName(className);
        }
    }
}

