/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection.resourcelock;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.ResourceLock;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapLock
extends ResourceLock<ConfigMap> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigMapLock.class);

    public ConfigMapLock(String configMapNamespace, String configMapName, String identity) {
        super(configMapNamespace, configMapName, identity);
    }

    public ConfigMapLock(ObjectMeta meta, String identity) {
        super(meta, identity);
    }

    @Override
    protected Class<ConfigMap> getKind() {
        return ConfigMap.class;
    }

    @Override
    protected LeaderElectionRecord toRecord(ConfigMap resource) {
        return Optional.ofNullable(resource.getMetadata().getAnnotations()).map(annotations -> (String)annotations.get("control-plane.alpha.kubernetes.io/leader")).map(annotation -> {
            try {
                return Serialization.unmarshal(annotation, LeaderElectionRecord.class);
            }
            catch (KubernetesClientException ex) {
                LOGGER.error("Error deserializing LeaderElectionRecord from ConfigMap", ex);
                return null;
            }
        }).orElse(null);
    }

    @Override
    protected ConfigMap toResource(LeaderElectionRecord leaderElectionRecord, ObjectMeta meta) {
        return ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapBuilder)new ConfigMapBuilder().withMetadata(meta)).editMetadata().addToAnnotations("control-plane.alpha.kubernetes.io/leader", Serialization.asJson(leaderElectionRecord))).endMetadata()).build();
    }
}

