/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.events.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.MicroTime;
import io.fabric8.kubernetes.api.model.events.v1.EventSeries;
import io.fabric8.kubernetes.api.model.events.v1.EventSeriesFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class EventSeriesFluentImpl<A extends EventSeriesFluent<A>>
extends BaseFluent<A>
implements EventSeriesFluent<A> {
    private Integer count;
    private MicroTime lastObservedTime;
    private Map<String, Object> additionalProperties;

    public EventSeriesFluentImpl() {
    }

    public EventSeriesFluentImpl(EventSeries instance) {
        this.withCount(instance.getCount());
        this.withLastObservedTime(instance.getLastObservedTime());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public A withCount(Integer count) {
        this.count = count;
        return (A)this;
    }

    @Override
    public Boolean hasCount() {
        return this.count != null;
    }

    @Override
    public MicroTime getLastObservedTime() {
        return this.lastObservedTime;
    }

    @Override
    public A withLastObservedTime(MicroTime lastObservedTime) {
        this.lastObservedTime = lastObservedTime;
        return (A)this;
    }

    @Override
    public Boolean hasLastObservedTime() {
        return this.lastObservedTime != null;
    }

    @Override
    public A withNewLastObservedTime(String time) {
        return this.withLastObservedTime(new MicroTime(time));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSeriesFluentImpl that = (EventSeriesFluentImpl)o;
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.lastObservedTime != null ? !this.lastObservedTime.equals(that.lastObservedTime) : that.lastObservedTime != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.count, this.lastObservedTime, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.count != null) {
            sb.append("count:");
            sb.append(this.count + ",");
        }
        if (this.lastObservedTime != null) {
            sb.append("lastObservedTime:");
            sb.append(this.lastObservedTime + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

