/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.utils.StringEscapeUtils;
import io.fabric8.java.generator.Config;
import io.fabric8.java.generator.exceptions.JavaGeneratorException;
import io.fabric8.java.generator.nodes.AbstractJSONSchema2Pojo;
import io.fabric8.java.generator.nodes.GeneratorResult;
import io.fabric8.java.generator.nodes.JObjectExtraAnnotations;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JObject
extends AbstractJSONSchema2Pojo
implements JObjectExtraAnnotations {
    private final String type;
    private final String className;
    private final String pkg;
    private final Map<String, AbstractJSONSchema2Pojo> fields;
    private final Set<String> required;
    private final boolean preserveUnknownFields;

    public JObject(String pkg, String type, Map<String, JSONSchemaProps> fields, List<String> required, boolean preserveUnknownFields, String classPrefix, String classSuffix, Config config, String description, boolean isNullable, JsonNode defaultValue) {
        super(config, description, isNullable, defaultValue, null);
        this.required = new HashSet<String>(Optional.ofNullable(required).orElse(Collections.emptyList()));
        this.fields = new HashMap<String, AbstractJSONSchema2Pojo>();
        this.preserveUnknownFields = preserveUnknownFields;
        this.pkg = pkg == null ? "" : pkg.trim();
        String pkgPrefix = this.pkg.isEmpty() ? this.pkg : this.pkg + ".";
        String clazzPrefix = classPrefix == null ? "" : classPrefix.trim();
        String clazzSuffix = classSuffix == null || type.toLowerCase(Locale.ROOT).endsWith(classSuffix.toLowerCase(Locale.ROOT)) ? "" : classSuffix.trim();
        String upperCasedClassName = type.substring(0, 1).toUpperCase() + type.substring(1);
        this.className = AbstractJSONSchema2Pojo.sanitizeString(clazzPrefix + upperCasedClassName + clazzSuffix);
        this.type = pkgPrefix + this.className;
        if (fields != null) {
            String nextPackagePath = null;
            switch (config.getCodeStructure()) {
                case FLAT: {
                    nextPackagePath = this.pkg;
                    break;
                }
                case PACKAGE_NESTED: {
                    nextPackagePath = pkgPrefix + AbstractJSONSchema2Pojo.packageName(this.className);
                }
            }
            for (Map.Entry<String, JSONSchemaProps> field : fields.entrySet()) {
                String nextPrefix = config.getPrefixStrategy() == Config.Prefix.ALWAYS ? classPrefix : "";
                String nextSuffix = config.getSuffixStrategy() == Config.Suffix.ALWAYS ? classSuffix : "";
                this.fields.put(field.getKey(), AbstractJSONSchema2Pojo.fromJsonSchema(field.getKey(), field.getValue(), nextPackagePath, nextPrefix, nextSuffix, config));
            }
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    private String getSortedFieldsAsParam(Set<String> list) {
        List sortedFields = list.stream().map(AbstractJSONSchema2Pojo::escapeQuotes).sorted().collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        while (!sortedFields.isEmpty()) {
            sb.append("\"" + (String)sortedFields.remove(0) + "\"");
            if (sortedFields.isEmpty()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public GeneratorResult generateJava() {
        CompilationUnit cu = new CompilationUnit();
        if (!this.pkg.isEmpty()) {
            cu.setPackageDeclaration(new PackageDeclaration(new Name(this.pkg)));
        }
        ClassOrInterfaceDeclaration clz = cu.addClass(this.className);
        clz.addAnnotation(new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonInclude"), new NameExpr("com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL")));
        clz.addAnnotation(new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonPropertyOrder"), new NameExpr(this.getSortedFieldsAsParam(this.fields.keySet()))));
        clz.addAnnotation(new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.databind.annotation.JsonDeserialize"), new NameExpr("using = com.fasterxml.jackson.databind.JsonDeserializer.None.class")));
        if (this.config.isGeneratedAnnotations()) {
            clz.addAnnotation(JObject.newGeneratedAnnotation());
        }
        if (this.config.isObjectExtraAnnotations()) {
            this.addExtraAnnotations(clz);
        }
        clz.addImplementedType(new ClassOrInterfaceType(null, "io.fabric8.kubernetes.api.model.KubernetesResource"));
        ArrayList<GeneratorResult.ClassResult> buffer = new ArrayList<GeneratorResult.ClassResult>(this.fields.size() + 1);
        List sortedKeys = this.fields.keySet().stream().sorted().collect(Collectors.toList());
        for (String k : sortedKeys) {
            boolean isEnum;
            AbstractJSONSchema2Pojo prop = this.fields.get(k);
            boolean isRequired = this.required.contains(k);
            GeneratorResult gr = prop.generateJava();
            boolean bl = isEnum = !gr.getInnerClasses().isEmpty();
            if (isEnum) {
                for (GeneratorResult.ClassResult enumCR : gr.getInnerClasses()) {
                    Optional<EnumDeclaration> ed = enumCR.getEnumByName(enumCR.getName());
                    if (!ed.isPresent()) continue;
                    clz.addMember((BodyDeclaration)ed.get());
                }
            }
            buffer.addAll(gr.getTopLevelClasses());
            String originalFieldName = AbstractJSONSchema2Pojo.escapeQuotes(k);
            String fieldName = AbstractJSONSchema2Pojo.sanitizeString(k);
            String fieldType = prop.getType();
            try {
                Expression primitiveDefault;
                FieldDeclaration objField = clz.addField(JObject.toClassOrInterfaceType(fieldType), fieldName, Modifier.Keyword.PRIVATE);
                objField.addAnnotation(new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonProperty"), new StringLiteralExpr(originalFieldName)));
                if (isRequired) {
                    objField.addAnnotation("io.fabric8.generator.annotation.Required");
                }
                if (prop.getMaximum() != null) {
                    objField.addAnnotation(new SingleMemberAnnotationExpr(new Name("io.fabric8.generator.annotation.Max"), new DoubleLiteralExpr(prop.getMaximum())));
                }
                if (prop.getMinimum() != null) {
                    objField.addAnnotation(new SingleMemberAnnotationExpr(new Name("io.fabric8.generator.annotation.Min"), new DoubleLiteralExpr(prop.getMinimum())));
                }
                if (prop.getPattern() != null) {
                    objField.addAnnotation(new SingleMemberAnnotationExpr(new Name("io.fabric8.generator.annotation.Pattern"), new StringLiteralExpr(StringEscapeUtils.escapeJava(prop.getPattern()))));
                }
                objField.createGetter();
                objField.createSetter();
                if (Utils.isNotNullOrEmpty(prop.getDescription())) {
                    objField.setJavadocComment(prop.getDescription().replace("*/", "&#042;&#047;"));
                    objField.addAnnotation(new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonPropertyDescription"), new StringLiteralExpr(StringEscapeUtils.escapeJava(prop.getDescription()))));
                }
                if (!prop.isNullable) {
                    objField.addAnnotation(new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonSetter"), new NameExpr("nulls = com.fasterxml.jackson.annotation.Nulls.SKIP")));
                } else {
                    objField.addAnnotation(new SingleMemberAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonSetter"), new NameExpr("nulls = com.fasterxml.jackson.annotation.Nulls.SET")));
                    objField.addAnnotation(new NormalAnnotationExpr(new Name("io.fabric8.generator.annotation.Nullable"), new NodeList<MemberValuePair>()));
                }
                if (prop.getDefaultValue() == null) continue;
                Expression expression = primitiveDefault = isEnum ? null : this.generatePrimitiveDefaultInitializerExpression(prop);
                if (primitiveDefault != null) {
                    objField.getVariable(0).setInitializer(primitiveDefault);
                    continue;
                }
                objField.getVariable(0).setInitializer(new NameExpr("io.fabric8.kubernetes.client.utils.Serialization.unmarshal(\"" + StringEscapeUtils.escapeJava(Serialization.asJson(prop.getDefaultValue())) + "\", " + prop.getClassType() + ".class)"));
            }
            catch (Exception cause) {
                throw new JavaGeneratorException("Error generating field " + fieldName + " with type " + prop.getType(), cause);
            }
        }
        if (this.preserveUnknownFields || this.config.isAlwaysPreserveUnknownFields()) {
            ClassOrInterfaceType mapType = (ClassOrInterfaceType)((ClassOrInterfaceType)new ClassOrInterfaceType().setName("java.util.Map")).setTypeArguments((Type)new ClassOrInterfaceType().setName("String"), (Type)new ClassOrInterfaceType().setName("Object"));
            FieldDeclaration objField = clz.addField(mapType, "additionalProperties", Modifier.Keyword.PRIVATE);
            objField.setVariables(new NodeList((Node[])new VariableDeclarator[]{((VariableDeclarator)new VariableDeclarator().setName("additionalProperties")).setType(mapType).setInitializer("new java.util.HashMap<>()")}));
            objField.addAnnotation(new NormalAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonIgnore"), new NodeList<MemberValuePair>()));
            objField.createGetter().addAnnotation(new NormalAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonAnyGetter"), new NodeList<MemberValuePair>()));
            objField.createSetter().addAnnotation(new NormalAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonAnySetter"), new NodeList<MemberValuePair>()));
            MethodDeclaration additionalSetter = clz.addMethod("setAdditionalProperty", Modifier.Keyword.PUBLIC);
            additionalSetter.addAnnotation(new NormalAnnotationExpr(new Name("com.fasterxml.jackson.annotation.JsonAnySetter"), new NodeList<MemberValuePair>()));
            additionalSetter.addParameter(new ClassOrInterfaceType(null, "java.lang.String"), "key");
            additionalSetter.addParameter(new ClassOrInterfaceType(null, "java.lang.Object"), "value");
            additionalSetter.setBody((BlockStmt)new BlockStmt().addStatement(new NameExpr("this.additionalProperties.put(key, value)")));
        }
        buffer.add(new GeneratorResult.ClassResult(this.className, cu));
        return new GeneratorResult(buffer);
    }

    private Expression generatePrimitiveDefaultInitializerExpression(AbstractJSONSchema2Pojo prop) {
        if (prop.getDefaultValue().isValueNode()) {
            String value = prop.getDefaultValue().toString();
            if (prop.getClassType().equals("Long") && prop.getDefaultValue().canConvertToLong()) {
                return new LongLiteralExpr(value + "L");
            }
            if (prop.getClassType().equals("Float") && prop.getDefaultValue().isFloatingPointNumber()) {
                return new DoubleLiteralExpr(value + "f");
            }
            if (prop.getClassType().equals("Boolean") && prop.getDefaultValue().isBoolean()) {
                return new BooleanLiteralExpr(prop.getDefaultValue().booleanValue());
            }
            return new NameExpr(value);
        }
        return null;
    }

    static ClassOrInterfaceType toClassOrInterfaceType(String className) {
        String withoutDollars = className.replace("$", ".");
        return withoutDollars.indexOf(60) >= 0 ? StaticJavaParser.parseClassOrInterfaceType(withoutDollars) : new ClassOrInterfaceType(null, withoutDollars);
    }
}

