/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.model.jackson;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonUnwrappedDeserializer<T>
extends JsonDeserializer<T>
implements ContextualDeserializer {
    private static final JsonUnwrapped cancelUnwrappedAnnotation;
    private JsonDeserializer<T> beanDeserializer;
    private Set<String> ownPropertyNames;
    private List<UnwrappedInfo> unwrappedInfos;

    public JsonUnwrappedDeserializer() {
    }

    public JsonUnwrappedDeserializer(DeserializationContext deserializationContext) throws JsonMappingException {
        JavaType type = deserializationContext.getContextualType();
        BeanDescription description = deserializationContext.getConfig().introspect(type);
        List unwrappedProperties = description.findProperties().stream().filter(prop -> Stream.of(prop.getConstructorParameter(), prop.getMutator(), prop.getField()).filter(Objects::nonNull).anyMatch(member -> {
            JsonUnwrapped unwrappedAnnotation = member.getAnnotation(JsonUnwrapped.class);
            if (unwrappedAnnotation != null) {
                member.getAllAnnotations().add(cancelUnwrappedAnnotation);
            }
            return unwrappedAnnotation != null;
        })).collect(Collectors.toList());
        if (unwrappedProperties.isEmpty()) {
            throw new UnsupportedOperationException("@JsonUnwrapped properties not found in " + type.getTypeName());
        }
        this.ownPropertyNames = description.findProperties().stream().map(BeanPropertyDefinition::getName).collect(Collectors.toSet());
        this.ownPropertyNames.removeAll(description.getIgnoredPropertyNames());
        JsonDeserializer<Object> rawBeanDeserializer = deserializationContext.getFactory().createBeanDeserializer(deserializationContext, type, description);
        ((ResolvableDeserializer)((Object)rawBeanDeserializer)).resolve(deserializationContext);
        this.beanDeserializer = rawBeanDeserializer;
        this.unwrappedInfos = new ArrayList<UnwrappedInfo>();
        for (BeanPropertyDefinition unwrappedProperty : unwrappedProperties) {
            this.unwrappedInfos.add(new UnwrappedInfo(deserializationContext, unwrappedProperty));
            this.ownPropertyNames.remove(unwrappedProperty.getName());
        }
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        return new JsonUnwrappedDeserializer<T>(deserializationContext);
    }

    @Override
    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectNode node = (ObjectNode)jsonParser.readValueAsTree();
        ObjectNode ownNode = deserializationContext.getNodeFactory().objectNode();
        HashMap unwrappedNodes = new HashMap();
        node.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            boolean replaced = false;
            for (UnwrappedInfo unwrapped : this.unwrappedInfos) {
                String transformed = unwrapped.nameTransformer.reverse(key);
                ObjectNode unwrappedNode = unwrappedNodes.getOrDefault(unwrapped, deserializationContext.getNodeFactory().objectNode());
                if (transformed == null || this.ownPropertyNames.contains(key) || !unwrapped.beanPropertyNames.contains(transformed)) continue;
                unwrappedNodes.putIfAbsent(unwrapped, unwrappedNode);
                unwrappedNode.replace(transformed, value);
                replaced = true;
            }
            if (!replaced && this.ownPropertyNames.contains(key)) {
                ownNode.replace(key, value);
            }
        });
        for (Map.Entry entry2 : unwrappedNodes.entrySet()) {
            ownNode.replace(((UnwrappedInfo)entry2.getKey()).propertyName, (JsonNode)entry2.getValue());
        }
        try (TreeTraversingParser syntheticParser = new TreeTraversingParser(ownNode, jsonParser.getCodec());){
            syntheticParser.nextToken();
            T t = this.beanDeserializer.deserialize(syntheticParser, deserializationContext);
            return t;
        }
    }

    static {
        try {
            cancelUnwrappedAnnotation = CancelUnwrapped.class.getField("dummy").getAnnotation(JsonUnwrapped.class);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class CancelUnwrapped {
        @JsonUnwrapped(enabled=false)
        public Object dummy;

        private CancelUnwrapped() {
        }
    }

    private static final class UnwrappedInfo {
        final String propertyName;
        final NameTransformer nameTransformer;
        final Set<String> beanPropertyNames;

        public UnwrappedInfo(DeserializationContext context, BeanPropertyDefinition unwrappedProperty) {
            this.propertyName = unwrappedProperty.getName();
            JsonUnwrapped annotation = unwrappedProperty.getField().getAnnotation(JsonUnwrapped.class);
            this.nameTransformer = NameTransformer.simpleTransformer(annotation.prefix(), annotation.suffix());
            this.beanPropertyNames = new HashSet<String>();
            HashSet processedTypes = new HashSet();
            UnwrappedInfo.extractPropertiesDeep(context, processedTypes, this.beanPropertyNames, unwrappedProperty);
        }

        private static void extractPropertiesDeep(DeserializationContext context, Set<Class<?>> processedTypes, Set<String> properties, BeanPropertyDefinition bean) {
            Collection<NamedType> types = context.getConfig().getSubtypeResolver().collectAndResolveSubtypesByClass(context.getConfig(), context.getConfig().introspect(bean.getPrimaryType()).getClassInfo());
            for (NamedType type : types) {
                if (!processedTypes.add(type.getType())) continue;
                for (BeanPropertyDefinition property : context.getConfig().introspect(context.constructType(type.getType())).findProperties()) {
                    properties.add(property.getName());
                    UnwrappedInfo.extractPropertiesDeep(context, processedTypes, properties, property);
                }
            }
        }
    }
}

