package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelector;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RequestAuthenticationSpecFluent<A extends RequestAuthenticationSpecFluent<A>> extends BaseFluent<A>{
  public RequestAuthenticationSpecFluent() {
  }
  
  public RequestAuthenticationSpecFluent(RequestAuthenticationSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<JWTRuleBuilder> jwtRules = new ArrayList<JWTRuleBuilder>();
  private WorkloadSelectorBuilder selector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RequestAuthenticationSpec instance) {
    instance = (instance != null ? instance : new RequestAuthenticationSpec());
    if (instance != null) {
          this.withJwtRules(instance.getJwtRules());
          this.withSelector(instance.getSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToJwtRules(int index,JWTRule item) {
    if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
    JWTRuleBuilder builder = new JWTRuleBuilder(item);
    if (index < 0 || index >= jwtRules.size()) { _visitables.get("jwtRules").add(builder); jwtRules.add(builder); } else { _visitables.get("jwtRules").add(index, builder); jwtRules.add(index, builder);}
    return (A)this;
  }
  
  public A setToJwtRules(int index,JWTRule item) {
    if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
    JWTRuleBuilder builder = new JWTRuleBuilder(item);
    if (index < 0 || index >= jwtRules.size()) { _visitables.get("jwtRules").add(builder); jwtRules.add(builder); } else { _visitables.get("jwtRules").set(index, builder); jwtRules.set(index, builder);}
    return (A)this;
  }
  
  public A addToJwtRules(io.fabric8.istio.api.security.v1beta1.JWTRule... items) {
    if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
    for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").add(builder);this.jwtRules.add(builder);} return (A)this;
  }
  
  public A addAllToJwtRules(Collection<JWTRule> items) {
    if (this.jwtRules == null) {this.jwtRules = new ArrayList<JWTRuleBuilder>();}
    for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").add(builder);this.jwtRules.add(builder);} return (A)this;
  }
  
  public A removeFromJwtRules(io.fabric8.istio.api.security.v1beta1.JWTRule... items) {
    if (this.jwtRules == null) return (A)this;
    for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").remove(builder); this.jwtRules.remove(builder);} return (A)this;
  }
  
  public A removeAllFromJwtRules(Collection<JWTRule> items) {
    if (this.jwtRules == null) return (A)this;
    for (JWTRule item : items) {JWTRuleBuilder builder = new JWTRuleBuilder(item);_visitables.get("jwtRules").remove(builder); this.jwtRules.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromJwtRules(Predicate<JWTRuleBuilder> predicate) {
    if (jwtRules == null) return (A) this;
    final Iterator<JWTRuleBuilder> each = jwtRules.iterator();
    final List visitables = _visitables.get("jwtRules");
    while (each.hasNext()) {
      JWTRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<JWTRule> buildJwtRules() {
    return this.jwtRules != null ? build(jwtRules) : null;
  }
  
  public JWTRule buildJwtRule(int index) {
    return this.jwtRules.get(index).build();
  }
  
  public JWTRule buildFirstJwtRule() {
    return this.jwtRules.get(0).build();
  }
  
  public JWTRule buildLastJwtRule() {
    return this.jwtRules.get(jwtRules.size() - 1).build();
  }
  
  public JWTRule buildMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
      for (JWTRuleBuilder item : jwtRules) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
      for (JWTRuleBuilder item : jwtRules) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withJwtRules(List<JWTRule> jwtRules) {
    if (this.jwtRules != null) {
      this._visitables.get("jwtRules").clear();
    }
    if (jwtRules != null) {
        this.jwtRules = new ArrayList();
        for (JWTRule item : jwtRules) {
          this.addToJwtRules(item);
        }
    } else {
      this.jwtRules = null;
    }
    return (A) this;
  }
  
  public A withJwtRules(io.fabric8.istio.api.security.v1beta1.JWTRule... jwtRules) {
    if (this.jwtRules != null) {
        this.jwtRules.clear();
        _visitables.remove("jwtRules");
    }
    if (jwtRules != null) {
      for (JWTRule item : jwtRules) {
        this.addToJwtRules(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasJwtRules() {
    return this.jwtRules != null && !this.jwtRules.isEmpty();
  }
  
  public JwtRulesNested<A> addNewJwtRule() {
    return new JwtRulesNested(-1, null);
  }
  
  public JwtRulesNested<A> addNewJwtRuleLike(JWTRule item) {
    return new JwtRulesNested(-1, item);
  }
  
  public JwtRulesNested<A> setNewJwtRuleLike(int index,JWTRule item) {
    return new JwtRulesNested(index, item);
  }
  
  public JwtRulesNested<A> editJwtRule(int index) {
    if (jwtRules.size() <= index) throw new RuntimeException("Can't edit jwtRules. Index exceeds size.");
    return setNewJwtRuleLike(index, buildJwtRule(index));
  }
  
  public JwtRulesNested<A> editFirstJwtRule() {
    if (jwtRules.size() == 0) throw new RuntimeException("Can't edit first jwtRules. The list is empty.");
    return setNewJwtRuleLike(0, buildJwtRule(0));
  }
  
  public JwtRulesNested<A> editLastJwtRule() {
    int index = jwtRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last jwtRules. The list is empty.");
    return setNewJwtRuleLike(index, buildJwtRule(index));
  }
  
  public JwtRulesNested<A> editMatchingJwtRule(Predicate<JWTRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<jwtRules.size();i++) { 
    if (predicate.test(jwtRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching jwtRules. No match found.");
    return setNewJwtRuleLike(index, buildJwtRule(index));
  }
  
  public WorkloadSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(WorkloadSelector selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new WorkloadSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public TypeSelectorNested<A> withNewTypeSelector() {
    return new TypeSelectorNested(null);
  }
  
  public TypeSelectorNested<A> withNewSelectorLike(WorkloadSelector item) {
    return new TypeSelectorNested(item);
  }
  
  public TypeSelectorNested<A> editTypeSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public TypeSelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new WorkloadSelectorBuilder().build()));
  }
  
  public TypeSelectorNested<A> editOrNewSelectorLike(WorkloadSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RequestAuthenticationSpecFluent that = (RequestAuthenticationSpecFluent) o;
    if (!java.util.Objects.equals(jwtRules, that.jwtRules)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(jwtRules,  selector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (jwtRules != null && !jwtRules.isEmpty()) { sb.append("jwtRules:"); sb.append(jwtRules + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class JwtRulesNested<N> extends JWTRuleFluent<JwtRulesNested<N>> implements Nested<N>{
    JwtRulesNested(int index,JWTRule item) {
      this.index = index;
      this.builder = new JWTRuleBuilder(this, item);
    }
    JWTRuleBuilder builder;
    int index;
    
    public N and() {
      return (N) RequestAuthenticationSpecFluent.this.setToJwtRules(index,builder.build());
    }
    
    public N endJwtRule() {
      return and();
    }
    
  
  }
  public class TypeSelectorNested<N> extends WorkloadSelectorFluent<TypeSelectorNested<N>> implements Nested<N>{
    TypeSelectorNested(WorkloadSelector item) {
      this.builder = new WorkloadSelectorBuilder(this, item);
    }
    WorkloadSelectorBuilder builder;
    
    public N and() {
      return (N) RequestAuthenticationSpecFluent.this.withSelector(builder.build());
    }
    
    public N endTypeSelector() {
      return and();
    }
    
  
  }

}